/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.log;

import org.jfree.base.log.LogConfiguration;
import org.jfree.util.Log;
import org.jfree.util.PrintStreamLogTarget;

public class DefaultLog
extends Log {
    private static final PrintStreamLogTarget DEFAULT_LOG_TARGET = new PrintStreamLogTarget();
    private static final DefaultLog defaultLogInstance = new DefaultLog();

    static {
        Log.defineLog(defaultLogInstance);
        defaultLogInstance.addTarget(DEFAULT_LOG_TARGET);
        try {
            if (Boolean.getBoolean("org.jfree.DebugDefault")) {
                defaultLogInstance.setDebuglevel(3);
            } else {
                defaultLogInstance.setDebuglevel(1);
            }
        }
        catch (SecurityException securityException) {
            defaultLogInstance.setDebuglevel(1);
        }
    }

    public static DefaultLog getDefaultLog() {
        return defaultLogInstance;
    }

    public void init() {
        this.removeTarget(DEFAULT_LOG_TARGET);
        String logLevel = LogConfiguration.getLogLevel();
        if (logLevel.equalsIgnoreCase("error")) {
            this.setDebuglevel(0);
        } else if (logLevel.equalsIgnoreCase("warn")) {
            this.setDebuglevel(1);
        } else if (logLevel.equalsIgnoreCase("info")) {
            this.setDebuglevel(2);
        } else if (logLevel.equalsIgnoreCase("debug")) {
            this.setDebuglevel(3);
        }
    }
}

