/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.base;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.experlog.base.ESServletRequest;
import org.experlog.base.OpenClient;
import org.experlog.db.ESPersistentHashtable;
import org.experlog.openeas.api.DataObject;
import org.experlog.util.AppConfiguration;
import org.experlog.util.Cookie;

public class ESCookie
implements Cookie,
DataObject {
    private static final long serialVersionUID = 645936686936756797L;
    boolean usecookies_ = false;
    int maxage_ = -1;
    boolean persist_ = false;
    String persistDs_ = null;
    ESPersistentHashtable info_ = null;
    transient OpenClient session_ = null;
    protected double lastmodified_ = Double.POSITIVE_INFINITY;
    boolean exchangeSession_ = false;

    public ESCookie(OpenClient session, HttpServletRequest req, boolean usecookies, String persistDs, int maxage) throws Exception {
        this.exchangeSession_ = session != null && "true".equalsIgnoreCase(session.getAppConfiguration().get("app.exchangesession"));
        this.persist_ = persistDs != null;
        this.persistDs_ = "main".equalsIgnoreCase(persistDs) ? null : persistDs;
        this.info_ = new ESPersistentHashtable(this.persist_ ? session : null, this.persistDs_, null, null);
        this.setSession(session);
        this.setCookie(req);
        this.usecookies_ = usecookies;
        this.maxage_ = maxage;
    }

    protected void setSession(OpenClient session) throws SQLException {
        this.session_ = session;
        if (session != null) {
            this.set("S_", session.getClientId(), false);
        }
    }

    protected void setLastModified(double date) {
        this.lastmodified_ = date;
    }

    public void setCookie(HttpServletRequest req) throws SQLException {
        if (req != null) {
            this.setCookie(new ESServletRequest(req, null, null));
        }
    }

    public void setCookie(ESServletRequest req) throws SQLException {
        if (req == null) {
            return;
        }
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.endsWith("_") || name.equals("S_")) continue;
            String val = req.getParameter(name);
            if (val == null) {
                val = "";
            }
            this.info_.put(name, val);
            if (name.equals("A_")) {
                this.info_.put("AdminId", val);
            }
            if (name.equals("AP_")) {
                this.info_.put("AdminPwd", val);
            }
            if (name.equals("L_")) {
                this.info_.put("Lang", val);
            }
            if (name.equals("W_")) {
                this.info_.put("CustId", val);
            }
            if (name.equals("ML_")) {
                this.info_.put("AffLogged", val);
            }
            if (!name.equals("M_")) continue;
            this.info_.put("AffId", val);
        }
    }

    public String get(String name) throws SQLException {
        Object obj = this.info_.get(name);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public void set(String name, Object val) throws SQLException {
        this.set(name, val, true);
    }

    private void set(String name, Object val, boolean persist) throws SQLException {
        if (persist) {
            this.info_.put(name, val);
        } else {
            this.info_.putNoPersist(name, val);
        }
    }

    public void clear() {
        if (this.info_ != null) {
            this.info_.clear();
        }
    }

    protected void finalize() {
        if (this.info_ != null) {
            this.info_.clear();
        }
        this.info_ = null;
    }

    public void toHttpSession(HttpSession s) throws SQLException {
        if (s == null) {
            return;
        }
        Enumeration keys = this.info_.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            try {
                if (!this.exchangeSession_ && !"S_".equals(key)) continue;
                s.setAttribute(key, this.info_.get(key));
            }
            catch (IllegalStateException e) {
                return;
            }
        }
    }

    public void fromHttpSession(HttpSession s, AppConfiguration cnf, HttpServletRequest req, HttpServletResponse rsp) throws SQLException {
        Enumeration keys;
        if (s == null) {
            return;
        }
        try {
            keys = s.getAttributeNames();
        }
        catch (IllegalStateException e) {
            return;
        }
        while (this.exchangeSession_ && keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (key.equals("S_")) continue;
            this.set(key, s.getAttribute(key).toString(), false);
            if (!this.usecookies_ || rsp == null || !cnf.storeInCookie(key)) continue;
            javax.servlet.http.Cookie c = new javax.servlet.http.Cookie(key, s.getAttribute(key).toString());
            c.setMaxAge(this.maxage_);
            rsp.addCookie(c);
        }
        if (this.usecookies_ && req != null) {
            javax.servlet.http.Cookie[] c = req.getCookies();
            for (int i = 0; c != null && i < c.length; ++i) {
                String val = c[i].getValue();
                if (val.startsWith("\"") && val.endsWith("\"") && (val.indexOf(32) > 0 || val.indexOf(9) > 0 || val.indexOf(10) > 0 || val.indexOf(13) > 0)) {
                    val = val.substring(1, val.length() - 1);
                }
                this.set(c[i].getName(), val, false);
            }
        }
    }

    public Hashtable getInfo() {
        return this.info_.toHashtable();
    }

    public void setInfo(Hashtable info) {
        try {
            this.info_.fromHashtable(info);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setObject(String name, Object obj) throws SQLException {
        if (obj != null) {
            this.info_.put(name, obj);
        }
    }

    public Object getObject(String name) throws SQLException {
        if (name != null) {
            return this.info_.get(name);
        }
        return null;
    }

    public void removeObject(String name) throws SQLException {
        if (name != null) {
            this.info_.remove(name);
        }
    }
}

