/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.base;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.experlog.base.OpenClient;

public class ESServletRequest {
    OpenClient client_ = null;
    HttpServletRequest req_ = null;
    HttpServletResponse rsp_ = null;
    Hashtable params_ = new Hashtable();

    public ESServletRequest(HttpServletRequest req, HttpServletResponse rsp, OpenClient client) {
        this.req_ = req;
        this.rsp_ = rsp;
        this.client_ = client;
    }

    public String getParameter(String name) {
        String ret = (String)this.params_.get(name);
        if (ret == null && this.req_ != null) {
            ret = this.req_.getParameter(name);
        }
        return ret;
    }

    public int getIntParam(String name, int errval) {
        try {
            String val = this.getParameter(name);
            if (val == null) {
                return errval;
            }
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return errval;
        }
    }

    public double getDoubleParam(String name, double errval) {
        try {
            String val = this.getParameter(name);
            if (val == null) {
                return errval;
            }
            return Double.valueOf(val);
        }
        catch (NumberFormatException e) {
            return errval;
        }
    }

    public long getLongParam(String name, long errval) {
        try {
            String val = this.getParameter(name);
            if (val == null) {
                return errval;
            }
            return Long.valueOf(val);
        }
        catch (NumberFormatException e) {
            return errval;
        }
    }

    public boolean isHttpParameter(String name) {
        if (this.params_.get(name) != null) {
            return false;
        }
        return this.req_.getParameter(name) != null;
    }

    public void addParameter(String name, String val) {
        if (name != null && val != null) {
            this.params_.put(name, val);
        }
    }

    public String[] getParameterValues(String name) {
        String p;
        String[] tmp = null;
        if (this.req_ != null) {
            tmp = this.req_.getParameterValues(name);
        }
        if ((p = (String)this.params_.get(name)) == null) {
            return tmp;
        }
        int sz = tmp == null ? 1 : tmp.length + 1;
        String[] ret = new String[sz];
        ret[0] = p;
        if (tmp != null && sz > 1) {
            for (int i = 1; i <= tmp.length; ++i) {
                ret[i] = tmp[i - 1];
            }
        }
        return ret;
    }

    public void addParameterValues(String name, String[] val) {
        if (name != null && val != null) {
            this.params_.put(name, val);
        }
    }

    public String checkParameters(String[] names, boolean all) {
        StringBuffer buf = new StringBuffer();
        boolean err = false;
        for (int i = 0; i < names.length; ++i) {
            String p = this.getParameter(names[i]);
            if (p != null && p.trim().length() >= 1) continue;
            err = true;
            if (!all) {
                return names[i];
            }
            buf.append(names[i] + ',');
        }
        if (err) {
            return buf.toString();
        }
        return null;
    }

    public Enumeration getParameterNames() {
        Enumeration en;
        Vector<String> v = new Vector<String>();
        if (this.req_ != null) {
            en = this.req_.getParameterNames();
            while (en.hasMoreElements()) {
                v.addElement(en.nextElement().toString());
            }
        }
        en = this.params_.keys();
        while (en.hasMoreElements()) {
            String s = en.nextElement().toString();
            if (v.contains(s)) continue;
            v.addElement(s);
        }
        return v.elements();
    }

    public Hashtable getAllParams() {
        Enumeration names = this.getParameterNames();
        Hashtable<String, String> h = new Hashtable<String, String>();
        while (names.hasMoreElements()) {
            StringBuffer b = new StringBuffer();
            String name = (String)names.nextElement();
            String[] vals = this.getParameterValues(name);
            for (int i = 0; i < vals.length; ++i) {
                if (i >= vals.length - 1) {
                    b.append(vals[i]);
                    continue;
                }
                b.append(vals[i] + ",");
            }
            h.put(name, b.toString());
        }
        return h;
    }

    public String toString() {
        return this.getAllParams().toString();
    }

    public HttpServletRequest getServletRequest() {
        return this.req_;
    }

    public HttpServletResponse getServletResponse() {
        return this.rsp_;
    }
}

