/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Category;
import org.experlog.base.DatasourceRequest;
import org.experlog.base.OpenClient;
import org.experlog.db.ESConnectionPool;
import org.experlog.util.AppConfiguration;
import org.experlog.util.Client;
import org.experlog.util.ConnectionPool;
import org.experlog.util.ESCategory;
import org.experlog.util.ESTimer;
import org.experlog.util.ESTimerThread;
import org.experlog.util.Store;

public class ESStore
implements Store,
ESTimer {
    private Hashtable clientPool_ = new Hashtable();
    public ConnectionPool connectionPool_;
    private AppConfiguration shopConfig_ = null;
    private String shopName_ = "openeas";
    private int state_ = 1;
    private int max = 0;
    private int maxClients_ = 0;
    private int countClients_ = 0;
    private long timeoutmillis_ = 3600000L;
    private ESTimerThread timer_;
    private Category logger;
    private String confdir_ = null;
    private String conffile_;
    private Properties general_ = new Properties();
    private static ESStore theStore_ = null;

    public static synchronized ESStore getInstance() {
        return ESStore.getInstance(null);
    }

    public static synchronized ESStore getInstance(ServletConfig cfg) {
        if (theStore_ == null) {
            theStore_ = new ESStore(cfg);
        }
        return theStore_;
    }

    public ESStore(ServletConfig cfg) {
        if (this.logger != null) {
            this.logger.debug((Object)("shopName=<" + this.shopName_ + ">"));
        }
        if (this.logger != null) {
            this.logger.debug((Object)("conf=<" + this.conffile_ + "> \nconfdir_=<" + this.confdir_ + "> \nconffile_=<" + this.conffile_ + ">"));
        }
        try {
            block10: {
                this.configure(cfg);
                this.shopConfig_ = new AppConfiguration(this.shopName_, this.general_, true, this.conffile_, this.confdir_);
                try {
                    this.connectionPool_ = new ESConnectionPool();
                }
                catch (Exception e) {
                    if (this.logger == null) break block10;
                    this.logger.error((Object)"ESStore impossible to create a new pool of connections", (Throwable)e);
                }
            }
            if (this.shopConfig_ == null) {
                if (this.logger != null) {
                    this.logger.debug((Object)"shopConfig_ is null name=<openeas>");
                } else {
                    if (this.logger != null) {
                        this.logger.debug((Object)"shopConfig_ is not null name=<openeas>");
                    }
                    this.timeoutmillis_ = this.shopConfig_.getTimeout() * 1000;
                }
            }
            this.connectionPool_.setShopConfig(this.shopConfig_, "openeas");
            this.timer_ = new ESTimerThread(this, this.timeoutmillis_ / 2000L, null);
            this.timer_.start();
            this.maxClients_ = this.shopConfig_.getMaxClients();
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace(System.err);
        }
    }

    private synchronized void configure(ServletConfig cfg) {
        block15: {
            String conf;
            this.logger = ESCategory.getCategory("openeas.store");
            if (this.logger != null) {
                this.logger.debug((Object)"configure");
            }
            this.confdir_ = cfg.getInitParameter("SHOPDIR");
            if (this.confdir_ == null) {
                this.confdir_ = cfg.getInitParameter("shopdir");
            }
            if ((conf = cfg.getInitParameter("CONFIGFILE")) == null) {
                conf = cfg.getInitParameter("configfile");
            }
            if (conf == null) {
                conf = ESStore.onWindows() ? new String("examples/lite/DemoWin.cfg") : new String("examples/lite/Demo.cfg");
            }
            FileInputStream f = null;
            try {
                StringBuffer conffile = new StringBuffer();
                if (this.confdir_ != null) {
                    conffile.append(this.confdir_);
                    if (!this.confdir_.endsWith(File.separator)) {
                        conffile.append(File.separator);
                    }
                }
                conffile.append(conf);
                this.conffile_ = conffile.toString();
                if (!new File(this.conffile_).isAbsolute()) {
                    this.confdir_ = cfg.getServletContext().getRealPath("/");
                    if (this.confdir_ != null) {
                        if (!this.confdir_.endsWith(File.separator)) {
                            this.confdir_ = this.confdir_ + File.separator;
                        }
                        this.conffile_ = this.confdir_ + this.conffile_;
                    }
                }
                f = new FileInputStream(this.conffile_);
                this.general_.load(f);
                f.close();
                f = null;
            }
            catch (IOException e) {
                block14: {
                    if (f != null) {
                        try {
                            f.close();
                        }
                        catch (Exception ee) {
                            if (this.logger == null) break block14;
                            this.logger.error((Object)("configure fail to close file :" + ee));
                        }
                    }
                }
                if (this.logger == null) break block15;
                this.logger.error((Object)("configure IO Exception :" + e));
            }
        }
    }

    protected static boolean onWindows() {
        return File.separatorChar == '\\';
    }

    public static synchronized String makeId(String name, boolean unique) {
        long val;
        if (name == null) {
            name = new String("");
            unique = true;
        }
        if (unique) {
            val = System.currentTimeMillis();
            while (val == System.currentTimeMillis()) {
            }
        } else {
            val = (long)Math.ceil(Math.random() * 100000.0 - 1.0);
        }
        String s = name.length() > 4 ? name.substring(0, 4) : name;
        String base = s.trim().replace('\t', '-').replace(' ', '-');
        return new String(base + val);
    }

    private String getClientId(String id) {
        if (id == null) {
            return new String(this.getShopConfiguration().getName() + "__" + ESStore.makeId(null, true));
        }
        if (id.indexOf("__") < 0) {
            return new String(id + "__" + ESStore.makeId(null, true));
        }
        return id;
    }

    public OpenClient getClient(String id, HttpServletRequest req) throws Exception {
        String clientId = this.getClientId(id);
        OpenClient ret = (OpenClient)this.clientPool_.get(clientId);
        if (ret != null) {
            ret.getCookie().setCookie(req);
            return ret;
        }
        return this.syncGetClient(clientId, req);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized OpenClient syncGetClient(String clientId, HttpServletRequest req) throws Exception {
        OpenClient ret = (OpenClient)this.clientPool_.get(clientId);
        if (ret == null && this.state_ == 1) {
            if (this.countClients_ >= this.maxClients_) return null;
            ret = new OpenClient(clientId, req, this.connectionPool_);
            ++this.countClients_;
            this.clientPool_.put(clientId, ret);
            if (this.clientPool_.size() <= this.max) return ret;
            this.max = this.clientPool_.size();
            return ret;
        } else {
            ret = (OpenClient)this.clientPool_.get(clientId);
            if (ret == null) return null;
            ret.getCookie().setCookie(req);
        }
        return ret;
    }

    public OpenClient findClient(String clientId) {
        return (OpenClient)this.clientPool_.get(clientId);
    }

    public Enumeration listClients() {
        return this.clientPool_.keys();
    }

    public void endClient(String cid) {
        if (this.logger != null) {
            this.logger.debug((Object)"ESStore:endClient");
        }
        OpenClient c = (OpenClient)this.clientPool_.remove(cid);
        c.endClient();
        --this.countClients_;
    }

    public AppConfiguration getShopConfiguration() {
        return this.shopConfig_;
    }

    public int getClientPool() {
        if (this.clientPool_ != null) {
            return this.clientPool_.size();
        }
        return 0;
    }

    public String getConPool() {
        return ((Object)this.connectionPool_).toString();
    }

    public String toString() {
        return "ESStore:toString { shopName=[" + this.shopName_ + "], " + "clientPool=[" + this.getClientPool() + "], " + "cnxPool=[" + this.getConPool() + "] }";
    }

    public void setShopName(String shop) {
        this.shopName_ = shop;
    }

    public void setClientPoolTable(Hashtable table) {
        this.clientPool_ = table;
    }

    public void setConnectionPool(ConnectionPool conn) {
        this.connectionPool_ = conn;
    }

    public void setShopConfig(AppConfiguration conf) {
        this.shopConfig_ = conf;
    }

    public void setShopProps(Properties shopProps) {
        this.general_ = shopProps;
    }

    public String getShopName() {
        return this.shopName_;
    }

    public Hashtable getClientPoolTable() {
        return this.clientPool_;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool_;
    }

    public AppConfiguration getShopConfig() {
        return this.shopConfig_;
    }

    public Properties getShopProps() {
        return this.general_;
    }

    public int getState() {
        return this.state_;
    }

    public void setState(int state) {
        if (state == -1) {
            Enumeration enu = this.clientPool_.keys();
            while (enu.hasMoreElements()) {
                String cl = (String)enu.nextElement();
                this.endClient(cl);
            }
        }
        this.state_ = state;
    }

    public int getMaxClients() {
        return this.max;
    }

    public void setLevel(String newLevel) {
        ESCategory.setLevel(newLevel, this.shopName_);
    }

    public String getLevel() {
        return ESCategory.getLevel(this.shopName_);
    }

    public String getOutput() {
        return ESCategory.getOutput(this.shopName_);
    }

    public String getLogRequest() {
        if (this.logger != null) {
            this.logger.debug((Object)"ESStore: getLogRequest call");
        }
        String result = new String();
        Enumeration enu = this.clientPool_.elements();
        while (enu.hasMoreElements()) {
            OpenClient ec = (OpenClient)enu.nextElement();
            Hashtable lr = ec.getLogRequest();
            Enumeration enulog = lr.elements();
            while (enulog.hasMoreElements()) {
                DatasourceRequest dr = (DatasourceRequest)enulog.nextElement();
                result = result + dr.toString();
            }
        }
        if (this.logger != null) {
            this.logger.debug((Object)("ESStore: getLogRequest [" + this.getShopName() + "] call result=(" + result + ")"));
        }
        return result;
    }

    public void tick(Object info) {
        block3: {
            Enumeration keys = this.clientPool_.keys();
            while (keys.hasMoreElements()) {
                String cid = (String)keys.nextElement();
                if (!((Client)this.clientPool_.get(cid)).sessionExpired()) continue;
                this.endClient(cid);
            }
            this.timer_ = new ESTimerThread(this, this.timeoutmillis_ / 2000L, null);
            try {
                Runtime.getRuntime().gc();
            }
            catch (Exception te) {
                if (this.logger == null) break block3;
                this.logger.error((Object)("ESStore:tick() - gc problem :" + te));
            }
        }
        this.timer_.start();
    }
}

