/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.base;

import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Category;
import org.experlog.base.DatasourceRequest;
import org.experlog.base.ESCookie;
import org.experlog.base.ESServletRequest;
import org.experlog.base.ESStore;
import org.experlog.gencode.ESDynHtml;
import org.experlog.gencode.UserObject;
import org.experlog.util.AppConfiguration;
import org.experlog.util.Client;
import org.experlog.util.ConnectionPool;
import org.experlog.util.Cookie;
import org.experlog.util.ESCategory;
import org.experlog.util.ESDbMapper;
import org.experlog.util.Store;

public class OpenClient
implements Client {
    public ConnectionPool connectionPool_;
    public String clientId_;
    public ESCookie cookie_ = null;
    public ESDbMapper dbmapper_ = null;
    public boolean nocomment_ = false;
    public long lastaccess_ = 0L;
    public long timeoutmillis_;
    public int qryattempts_ = 1;
    public boolean reconnect_on_err_ = false;
    public String sqlencodesep_ = null;
    public String sqlencoderules_ = null;
    public boolean isadm_ = false;
    public String page_ = null;
    public Hashtable param_ = null;
    public Category logger;
    public Hashtable datasourceConnections_ = null;
    public Hashtable datasourceLogs_ = null;
    public Hashtable connectionCounts_ = null;
    public Hashtable multiPagesObjects_ = null;

    public OpenClient() {
    }

    public OpenClient(String id, HttpServletRequest req, ConnectionPool conPool) throws Exception {
        this.logger = ESCategory.getCategory(ESStore.getInstance().getShopName(), "openeas.client");
        this.logger.debug((Object)"ESClient create a new client");
        this.clientId_ = id;
        this.connectionPool_ = conPool;
        String qa = this.getAppConfiguration().get("jdbc.QryAttempts");
        if (qa != null) {
            try {
                this.qryattempts_ = Integer.parseInt(qa);
            }
            catch (NumberFormatException e) {
                this.qryattempts_ = 1;
            }
        }
        if ((qa = this.getAppConfiguration().get("jdbc.ReconnectOnError")) != null) {
            this.setReconnect_on_err(qa.equalsIgnoreCase("true"));
        }
        if ((qa = this.getAppConfiguration().get("internal.NoComment")) != null) {
            this.nocomment_ = qa.equalsIgnoreCase("true");
        }
        this.resetTimer();
        this.timeoutmillis_ = this.getAppConfiguration().getTimeout() * 1000;
        this.dbmapper_ = new ESDbMapper(this.getAppConfiguration().get("app.dbmapper"));
        this.datasourceConnections_ = new Hashtable();
        this.datasourceLogs_ = new Hashtable();
        this.connectionCounts_ = new Hashtable();
        this.multiPagesObjects_ = new Hashtable();
        this.cookie_ = new ESCookie(this, req, this.getAppConfiguration().useCookies(), this.getAppConfiguration().get("app.persistcookie"), this.getAppConfiguration().getCookieTimeout());
        this.logger.debug((Object)"ESClient a new client is created");
    }

    public Store getStore() {
        return ESStore.getInstance();
    }

    public boolean sessionExpired() {
        boolean expired;
        boolean bl = expired = System.currentTimeMillis() - this.lastaccess_ >= this.timeoutmillis_;
        if (expired) {
            try {
                String template = this.getAppConfiguration().get("session.ontimeout");
                if (template != null) {
                    String fnm = this.getAppConfiguration().getRootDir();
                    fnm = fnm.endsWith(File.separator) ? fnm + template : fnm + File.separator + template;
                    fnm = fnm.replace('/', File.separatorChar).replace('\\', File.separatorChar);
                    ESDynHtml expander = new ESDynHtml(this, new File(fnm));
                    ESServletRequest sr = new ESServletRequest(null, null, this);
                    sr.addParameter("S_", this.clientId_);
                    expander.setServletRequest(sr);
                    expander.expand(new PrintWriter(System.out));
                }
            }
            catch (Exception te) {
                this.logger.error((Object)("ESClient:sessionExpired() - session.ontimeout error:" + te));
            }
            this.getStore().endClient(this.clientId_);
        }
        return expired;
    }

    public void addUserObject(String name, UserObject uobj) {
        if (this.multiPagesObjects_ != null) {
            this.multiPagesObjects_.put(name, uobj);
        } else {
            this.logger.warn((Object)"multiPagesObjects is null, it should not !");
        }
    }

    public UserObject getUserObject(String name) {
        if (this.multiPagesObjects_ == null) {
            this.logger.warn((Object)"multiPagesObjects is null, it should not !");
            return null;
        }
        return (UserObject)this.multiPagesObjects_.get(name);
    }

    public Hashtable getUserObjects() {
        return this.multiPagesObjects_;
    }

    public void closeUserObject(String name) {
        if (this.multiPagesObjects_ == null) {
            this.logger.warn((Object)"multiPagesObjects is null, it should not !");
        } else {
            UserObject uo = (UserObject)this.multiPagesObjects_.get(name);
            uo.close();
            uo = null;
            this.multiPagesObjects_.remove(name);
        }
    }

    public void endClient() {
        if (this.multiPagesObjects_ == null) {
            this.logger.warn((Object)"multiPagesObjects is null, it should not !");
        } else {
            Enumeration en = this.multiPagesObjects_.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                UserObject val = (UserObject)this.multiPagesObjects_.get(key);
                val.close();
                Object var3_3 = null;
            }
            en = null;
            this.multiPagesObjects_.clear();
            this.multiPagesObjects_ = null;
        }
        if (this.cookie_ != null) {
            this.cookie_.clear();
        }
    }

    public AppConfiguration getAppConfiguration() {
        return ESStore.getInstance().getShopConfiguration();
    }

    public ESDbMapper getDbMapper() {
        return this.dbmapper_;
    }

    public String getClientId() {
        return this.clientId_;
    }

    public void setClientId(String id) {
        this.clientId_ = new String(id);
    }

    public Cookie getCookie() {
        return this.cookie_;
    }

    public String getAppName() {
        return ESStore.getInstance().getShopName();
    }

    public boolean isAdministrator() {
        return true;
    }

    public boolean cacheRS() {
        try {
            String cac = this.getAppConfiguration().get("jdbc.cacheRS");
            if (cac == null) {
                return false;
            }
            return cac.trim().toLowerCase().equals("true");
        }
        catch (Exception e) {
            this.logger.error((Object)("ESClient:cacheRS Exception " + e));
            return false;
        }
    }

    public boolean multithread() {
        try {
            String mt = this.getAppConfiguration().get("jdbc.threadSafe");
            if (mt == null) {
                return true;
            }
            return !mt.trim().toLowerCase().equals("false");
        }
        catch (Exception e) {
            this.logger.error((Object)("ESClient:multithread Exception " + e));
            return true;
        }
    }

    public void resetTimer() {
        this.lastaccess_ = System.currentTimeMillis();
    }

    public String sqlEncode(String s) {
        return this.sqlEncode(null, s);
    }

    public String sqlEncode(String datasourcename, String s) {
        if (this.sqlencodesep_ == null) {
            this.sqlencodesep_ = this.getAppConfiguration().getSqlEncodeSeparator(datasourcename);
            if (this.sqlencodesep_ == null) {
                this.sqlencodesep_ = ";";
            }
        }
        if (this.sqlencoderules_ == null) {
            this.sqlencoderules_ = this.getAppConfiguration().getSqlEncodeSubst(datasourcename);
            if (this.sqlencoderules_ == null) {
                this.sqlencoderules_ = "'='';\r=\" \";\n=\" \";";
            }
        }
        StringTokenizer st = new StringTokenizer(this.sqlencoderules_, this.sqlencodesep_);
        Hashtable<String, String> subst = new Hashtable<String, String>();
        while (st.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st.nextToken(), "=");
            if (!st2.hasMoreTokens()) continue;
            String k = st2.nextToken();
            if (!st2.hasMoreTokens()) continue;
            String v = st2.nextToken();
            if (v.equals("\" \"")) {
                v = " ";
            } else if (v.equals("\"\"")) {
                v = "";
            }
            subst.put(k, v);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String sub = (String)subst.get(String.valueOf(c));
            if (sub == null) {
                buf.append(c);
                continue;
            }
            buf.append(sub.toString());
        }
        return buf.toString();
    }

    public boolean noComment() {
        return this.nocomment_;
    }

    public void updateDB(String sql) throws SQLException, Exception {
        this.updateDB(null, sql);
    }

    public void updateDB(String datasource, String sql) throws SQLException, Exception {
        Connection con = null;
        try {
            con = this.getConnection(datasource);
            this.logRequest(datasource, sql);
            this.connectionPool_.updateDB(con, sql);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.closeConnection(con, datasource);
        }
    }

    public synchronized Connection getConnection(String datasourcename) throws Exception {
        this.logger.debug((Object)("OpenClient: getConnection datasourcename=(" + datasourcename + ")"));
        String dsname = null;
        if (datasourcename == null) {
            dsname = "__";
        } else {
            dsname = datasourcename;
            datasourcename = this.getAppConfiguration().getName() + "__" + datasourcename;
        }
        Integer ii = (Integer)this.connectionCounts_.get(dsname);
        int i = 0;
        Connection con = null;
        if (ii != null) {
            i = ii;
        }
        if (i == 0) {
            con = this.connectionPool_.connectDb(datasourcename);
            this.datasourceConnections_.put(dsname, con);
            i = 1;
            this.connectionCounts_.put(dsname, new Integer(i));
        } else {
            con = (Connection)this.datasourceConnections_.get(dsname);
            this.connectionCounts_.put(dsname, new Integer(++i));
        }
        this.logger.debug((Object)("OpenClient: getConnection total connection (" + dsname + ")=" + i));
        return con;
    }

    public void logRequest(String dsn, String request) {
        DatasourceRequest dr;
        this.logger.debug((Object)("OpenClient: logRequest datasourcename=(" + dsn + ") request:=(" + request + ")"));
        String dsname = null;
        dsname = dsn == null ? "__" : dsn;
        if (this.datasourceLogs_ == null) {
            this.datasourceLogs_ = new Hashtable();
        }
        if ((dr = (DatasourceRequest)this.datasourceLogs_.remove(dsname)) == null) {
            dr = new DatasourceRequest();
        }
        dr.addLog(request);
        this.datasourceLogs_.put(dsname, dr);
        this.logger.debug((Object)("OpenClient: logRequest phrase=(" + request + ")"));
    }

    public Hashtable getLogRequest() {
        return this.datasourceLogs_;
    }

    public synchronized void closeConnection(Connection con, String datasourcename) throws SQLException {
        DatasourceRequest dr;
        this.logger.debug((Object)("OpenClient: closeConnection datasourcename=(" + datasourcename + ")"));
        String dsname = null;
        dsname = datasourcename == null ? "__" : datasourcename;
        Integer ii = (Integer)this.connectionCounts_.get(dsname);
        int i = 0;
        if (ii != null) {
            i = ii;
        }
        if (i == 1) {
            this.datasourceConnections_.remove(dsname);
            if (con != null) {
                con.close();
            }
            i = 0;
            this.connectionCounts_.put(dsname, new Integer(i));
        } else if (i > 1) {
            this.connectionCounts_.put(dsname, new Integer(--i));
        } else if (i <= 0) {
            this.logger.warn((Object)("One more closeConnection + [" + i + "]"));
        }
        if (this.datasourceLogs_ != null && (dr = (DatasourceRequest)this.datasourceLogs_.remove(dsname)) != null) {
            dr.removeFirstLog();
            if (dr.size() == 0) {
                dr.clear();
            } else {
                this.datasourceLogs_.put(dsname, dr);
            }
        }
        this.logger.debug((Object)("OpenClient: closeConnection total connection (" + dsname + ")=" + i));
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool_;
    }

    public boolean isNocomment() {
        return this.nocomment_;
    }

    public long getLastaccess() {
        return this.lastaccess_;
    }

    public long getTimeoutmillis() {
        return this.timeoutmillis_;
    }

    public int getQryattempts() {
        return this.qryattempts_;
    }

    public boolean isReconnect_on_err() {
        return this.reconnect_on_err_;
    }

    public String getSqlencodesep() {
        return this.sqlencodesep_;
    }

    public String getSqlencoderules() {
        return this.sqlencoderules_;
    }

    public boolean isAdm() {
        return this.isAdministrator();
    }

    public void setNocomment(boolean nocomment) {
        this.nocomment_ = nocomment;
    }

    public void setLastaccess(long lastaccess) {
        this.lastaccess_ = lastaccess;
    }

    public void setQryattempts(int qryattempts) {
        this.qryattempts_ = qryattempts;
    }

    public void setReconnect_on_err(boolean reconnect) {
        this.reconnect_on_err_ = reconnect;
        this.connectionPool_.setReconnect_on_err(reconnect);
    }

    public void setSqlencodesep(String sqlencodesep) {
        this.sqlencodesep_ = sqlencodesep;
    }

    public void setSqlencoderules(String sqlencoderules) {
        this.sqlencoderules_ = sqlencoderules;
    }

    public void setConnectionPool(ConnectionPool obj) {
        this.connectionPool_ = obj;
    }

    public void setCookie(Cookie cook) {
        this.cookie_ = (ESCookie)cook;
    }

    public void setDbmapper(ESDbMapper mapper) {
        this.dbmapper_ = mapper;
    }

    public void setParam(Hashtable param) {
        this.param_ = param;
    }

    public Hashtable getParam() {
        return this.param_;
    }

    public String toString() {
        return this.getClientId();
    }
}

