/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import org.experlog.openeas.api.DataObject;
import org.experlog.util.Client;

public class ESCallable
implements DataObject {
    private CallableStatement callable;
    private Hashtable outparam = null;
    private String datasource = null;
    private Connection con_ = null;
    private Client session_ = null;

    public ESCallable(CallableStatement stat, String adatasource, Connection con, Client session) {
        this.callable = stat;
        this.outparam = new Hashtable();
        this.con_ = con;
        this.session_ = session;
        this.datasource = adatasource;
    }

    public void registerOutParameter(int pos, int type) {
        try {
            this.callable.registerOutParameter(pos, type);
        }
        catch (SQLException sql) {
            sql.printStackTrace();
            System.err.println("impossible to register an out parameter onthe current callable statement");
        }
        this.outparam.put(new Integer(pos).toString(), "null");
    }

    public Hashtable getParams() {
        return this.outparam;
    }

    public CallableStatement getCallable() {
        return this.callable;
    }

    public String get(String name) throws SQLException {
        return (String)this.outparam.get(name);
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void close() throws SQLException {
        this.datasource = null;
        this.outparam.clear();
        this.callable.close();
        this.session_.closeConnection(this.con_, this.datasource);
    }

    public Connection getConnection() {
        return this.con_;
    }
}

