/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import org.enhydra.jdbc.pool.GenerationObject;
import org.enhydra.jdbc.pool.GenericPool;
import org.enhydra.jdbc.pool.StandardPoolDataSource;
import org.enhydra.jdbc.standard.StandardConnectionPoolDataSource;
import org.enhydra.jdbc.util.Logger;
import org.experlog.db.DatasourceProperty;
import org.experlog.util.AppConfiguration;
import org.experlog.util.DataSourceWrapper;
import org.experlog.util.ESCategory;

public class ESDataSourceWrapper
implements DataSourceWrapper {
    private String dataSourceName_;
    private DataSource dataSource_;
    public int errorCount = 0;
    public int maxCount = 0;
    private Category logger;
    Logger logWriter;
    private String user_ = null;
    private String password_ = null;

    public ESDataSourceWrapper(String name) {
    }

    public void init(AppConfiguration shopConfig, DatasourceProperty dsprop) throws Exception, SQLException {
        this.logger = ESCategory.getCategory(shopConfig.getName(), "openeas.db");
        this.logger.debug((Object)"ESDataSourceWrapper create dataSource wrapper");
        this.logger.debug((Object)"ESDataSourceWrapper the datasource property is null, create an ESDataSource object");
        StandardConnectionPoolDataSource connect = new StandardConnectionPoolDataSource();
        connect.setDebug(true);
        if (dsprop == null) {
            this.dataSourceName_ = shopConfig.getName();
            this.user_ = shopConfig.getJdbcUser();
            this.password_ = shopConfig.getJdbcPassword();
            connect.setUrl(shopConfig.getJdbcUrl());
            connect.setDriverName(shopConfig.getJdbcDriverClass());
            connect.setUser(this.user_);
            connect.setPassword(this.password_);
            this.dataSource_ = new StandardPoolDataSource((ConnectionPoolDataSource)connect);
            ((StandardPoolDataSource)this.dataSource_).setUser(this.user_);
            ((StandardPoolDataSource)this.dataSource_).setPassword(this.password_);
            ((StandardPoolDataSource)this.dataSource_).setMinSize(shopConfig.getMinConn());
            ((StandardPoolDataSource)this.dataSource_).setMaxSize(shopConfig.getMaxConn());
            ((StandardPoolDataSource)this.dataSource_).setLifeTime(shopConfig.getLifeTime());
            ((StandardPoolDataSource)this.dataSource_).setSleepTime(shopConfig.getSleepTime());
        } else {
            this.dataSourceName_ = dsprop.getName();
            this.user_ = dsprop.getUser();
            this.password_ = dsprop.getPassword();
            connect.setUrl(dsprop.getUrl());
            connect.setDriverName(dsprop.getDriver());
            connect.setUser(this.user_);
            connect.setPassword(this.password_);
            this.dataSource_ = new StandardPoolDataSource((ConnectionPoolDataSource)connect);
            ((StandardPoolDataSource)this.dataSource_).setUser(this.user_);
            ((StandardPoolDataSource)this.dataSource_).setPassword(this.password_);
            ((StandardPoolDataSource)this.dataSource_).setMinSize(dsprop.getMinConn());
            ((StandardPoolDataSource)this.dataSource_).setMaxSize(dsprop.getMaxConn());
            ((StandardPoolDataSource)this.dataSource_).setLifeTime(dsprop.getLifeTime());
            ((StandardPoolDataSource)this.dataSource_).setSleepTime(dsprop.getSleepTime());
        }
        ((StandardPoolDataSource)this.dataSource_).setJdbcTestStmt(shopConfig.getJdbcTestStmt());
        ((StandardPoolDataSource)this.dataSource_).setCheckLevelObject(shopConfig.getCheckLevelObject());
        ((StandardPoolDataSource)this.dataSource_).setDataSourceName("xsds");
        this.logger.debug((Object)"ESDataSourceWrapper set the logWriter for the datasource");
    }

    public synchronized Connection getConnection() throws SQLException, Exception {
        return this.getConnection(this.user_, this.password_);
    }

    public synchronized Connection getConnection(String _user, String _password) throws SQLException, Exception {
        Connection con = null;
        if (this.getMaxCon() == ((StandardPoolDataSource)this.dataSource_).getLockedObjectCount()) {
            ++this.errorCount;
        }
        con = this.dataSource_.getConnection(_user, _password);
        int i = ((StandardPoolDataSource)this.dataSource_).getLockedObjectCount();
        if (i > this.maxCount) {
            this.maxCount = i;
        }
        return con;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName_ = name;
    }

    public String getDataSourceName() {
        return this.dataSourceName_;
    }

    public DataSource getDataSource() {
        return this.dataSource_;
    }

    public int getMinCon() {
        return ((StandardPoolDataSource)this.dataSource_).getMinSize();
    }

    public int getMaxCon() {
        return ((StandardPoolDataSource)this.dataSource_).getMaxSize();
    }

    public String getJdbcTestStmt() {
        return ((StandardPoolDataSource)this.dataSource_).getJdbcTestStmt();
    }

    public int getCheckLevelObject() {
        return ((StandardPoolDataSource)this.dataSource_).getCheckLevelObject();
    }

    public void setMinCon(int min) {
        try {
            ((StandardPoolDataSource)this.dataSource_).setMinSize(min);
        }
        catch (Exception e) {
            this.logger.error((Object)"ESDataSourceWrapper:setMinCon error in setMinSize");
        }
    }

    public void setMaxCon(int max) {
        try {
            ((StandardPoolDataSource)this.dataSource_).setMaxSize(max);
        }
        catch (Exception e) {
            this.logger.error((Object)"ESDataSourceWrapper:setMaxCon error in setMaxSize");
        }
    }

    public void setJdbcTestStmt(String jdbcTestStmt) {
        ((StandardPoolDataSource)this.dataSource_).setJdbcTestStmt(jdbcTestStmt);
    }

    public void setCheckLevelObject(int checkLevelObject) {
        ((StandardPoolDataSource)this.dataSource_).setCheckLevelObject(checkLevelObject);
    }

    public void setLogWriter(PrintWriter log) {
        try {
            this.dataSource_.setLogWriter(log);
        }
        catch (SQLException e) {
            this.logger.error((Object)("ESDataSourceWrapper:setLogWriter error " + e));
        }
    }

    public void setDebug(boolean debug) {
        ((StandardPoolDataSource)this.dataSource_).setDebug(debug);
    }

    public void setUser(String user) {
        ((StandardPoolDataSource)this.dataSource_).setUser(user);
    }

    public void setPassword(String password) {
        ((StandardPoolDataSource)this.dataSource_).setPassword(password);
    }

    public PrintWriter getLogWriter() {
        try {
            return this.dataSource_.getLogWriter();
        }
        catch (SQLException e) {
            this.logger.error((Object)("ESDataSourceWrapper:setLogWriter error " + e));
            return null;
        }
    }

    public boolean isDebug() {
        return ((StandardPoolDataSource)this.dataSource_).isDebug();
    }

    public String getUser() {
        return ((StandardPoolDataSource)this.dataSource_).getUser();
    }

    public String getPassword() {
        return ((StandardPoolDataSource)this.dataSource_).getPassword();
    }

    public String getUrl() {
        return ((StandardConnectionPoolDataSource)((StandardPoolDataSource)this.dataSource_).cpds).getUrl();
    }

    public String getDriverName() {
        return ((StandardConnectionPoolDataSource)((StandardPoolDataSource)this.dataSource_).cpds).getDriverName();
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void cleanup() {
        ((StandardPoolDataSource)this.dataSource_).stopPool();
    }

    public Hashtable getPool() {
        GenericPool gp = ((StandardPoolDataSource)this.dataSource_).getPool();
        Hashtable hgp = gp.getUnlockedPool();
        System.out.println("gp.getUnlockedPool:" + hgp.toString());
        return hgp;
    }

    public void removeUnlockedObject(GenerationObject obj) {
        GenericPool gp = ((StandardPoolDataSource)this.dataSource_).getPool();
        gp.removeUnlockedObject(obj);
    }

    public Hashtable getUsedPool() {
        GenericPool gp = ((StandardPoolDataSource)this.dataSource_).getUsedPool();
        Hashtable hgp = gp.getLockedPool();
        System.out.println("gp.getLockedPool:" + hgp.toString());
        return hgp;
    }

    public void removeLockedObject(GenerationObject obj) {
        GenericPool gp = ((StandardPoolDataSource)this.dataSource_).getUsedPool();
        gp.removeLockedObject((Object)obj);
    }
}

