/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.gencode;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.experlog.openeas.api.DataObject;

public class ESDateAccess
implements DataObject {
    private int[] daysOfMonth_ = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public String get(String name) throws SQLException {
        return this.get(name, System.currentTimeMillis());
    }

    public String get(String name, long tm) {
        if ((name = name.trim().toUpperCase()).equals("NOW")) {
            return Long.toString(tm);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(tm));
        if (name.startsWith("YEAR")) {
            int offset = this.getOffset(name.substring(4));
            if (offset != 0) {
                cal.set(1, cal.get(1) + offset);
            }
            return Long.toString(cal.getTime().getTime());
        }
        if (name.startsWith("MONTH")) {
            int day;
            int offset = this.getOffset(name.substring(5));
            int curmonth = cal.get(2);
            int ny = offset >= 0 ? (curmonth + offset) / 12 : (curmonth + offset - 11) / 12;
            int nm = offset >= 0 ? (curmonth + offset) % 12 : (curmonth + offset + 12) % 12;
            if (ny != 0) {
                cal.set(1, cal.get(1) + ny);
            }
            if ((day = cal.get(5)) > this.daysOfMonth_[nm]) {
                cal.set(5, this.daysOfMonth_[nm]);
            }
            cal.set(2, nm);
            return Long.toString(cal.getTime().getTime());
        }
        if (name.startsWith("DAY")) {
            int offset = this.getOffset(name.substring(3));
            long rdate = cal.getTime().getTime() + (long)offset * 24L * 60L * 60L * 1000L;
            int hour = cal.get(11);
            cal.setTime(new Date(rdate));
            int diff = cal.get(11) - hour;
            if (diff > 0) {
                rdate += 3600000L;
            } else if (diff < 0) {
                rdate -= 3600000L;
            }
            return Long.toString(rdate);
        }
        if (name.startsWith("HOUR")) {
            int offset = this.getOffset(name.substring(4));
            return Long.toString(cal.getTime().getTime() + (long)offset * 60L * 60L * 1000L);
        }
        return null;
    }

    private int getOffset(String off) {
        int val;
        try {
            val = Integer.parseInt(off.substring(1));
        }
        catch (Exception e) {
            val = 0;
        }
        if (off.startsWith("-")) {
            return -val;
        }
        return val;
    }
}

