/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.openeas.api;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.experlog.db.ESDBDataSet;
import org.experlog.openeas.api.DataObject;
import org.experlog.openeas.api.DataSet;
import org.experlog.openeas.api.Session;

public class DBDataSet
implements DataSet {
    ESDBDataSet ds_ = null;

    public DBDataSet(Session s, String sql, String datasource) throws SQLException {
        Connection c = null;
        try {
            c = s.getConnection(datasource);
            Statement st = c.createStatement();
            ResultSet rs = st.executeQuery(sql);
            this.ds_ = new ESDBDataSet(rs, s.getSession(), s.getConnection(datasource), datasource, st);
        }
        catch (SQLException e) {
            if (c != null) {
                try {
                    s.closeConnection(c, datasource);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            this.ds_ = null;
            throw e;
        }
        catch (Exception e) {
            if (c != null) {
                try {
                    s.closeConnection(c, datasource);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            this.ds_ = null;
            throw new SQLException(e.getMessage());
        }
    }

    public DBDataSet(Session s, String sql) throws SQLException {
        this(s, sql, null);
    }

    public void close() throws SQLException {
        if (this.ds_ != null) {
            this.ds_.close();
        }
    }

    public boolean dataAvailable() throws SQLException {
        return this.ds_ == null ? false : this.ds_.dataAvailable();
    }

    public DataObject getTuple() throws SQLException {
        return this.ds_ == null ? null : this.ds_.getTuple();
    }

    public boolean isTransient() {
        return this.ds_ == null ? false : this.ds_.isTransient();
    }

    public boolean next() throws SQLException {
        return this.ds_ == null ? false : this.ds_.next();
    }

    public void open() throws SQLException {
        if (this.ds_ != null) {
            this.ds_.open();
        }
    }

    public void setBoundaries(int low, int high) throws SQLException {
        if (this.ds_ != null) {
            this.ds_.setBoundaries(low, high);
        }
    }
}

