/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.enhydra.instantdb.db.LongColumn;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.Transaction;
import org.enhydra.instantdb.db.idbDataOutputStream;
import org.enhydra.instantdb.db.tokenList;
import org.enhydra.instantdb.db.utils;

class DateColumn
extends LongColumn {
    String formatStr;
    int[] formatArray;
    int formatStrLen;
    char[] pad;
    Date dateVal;
    String preferredParseFormat;
    static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    static String[] dateFormats = new String[]{"yMdHms", "MdyHms", "dMyHms", "HmsMdy", "HmsdMy", "HmsyMd"};
    static final int DD = 1;
    static final int MM = 2;
    static final int MMM = 3;
    static final int YY = 4;
    static final int YYYY = 5;
    static final int HH = 7;
    static final int NN = 8;
    static final int SS = 9;
    static final int LLL = 10;
    static long time;

    DateColumn(Table table, String string, String string2) throws SQLException, NumberFormatException {
        super(table, string);
        this.type = 5;
        if (string2 == null) {
            string2 = "yyyy-mmm-dd hh:nn:ss";
        }
        this.formatStr = string2;
        this.setFormatArray();
        this.dateVal = new Date();
    }

    void close(RandomAccessFile randomAccessFile) throws IOException {
        super.close(randomAccessFile);
        utils.writeString(randomAccessFile, this.formatStr);
    }

    Object getDefault() {
        Object object = this.toObject(this.defaultValue);
        return object;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    String pad0(int n, int n2) {
        String string = new Integer(n).toString();
        if (string.length() >= n2) {
            return string;
        }
        int n3 = n2 - string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.append('0');
            ++n4;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    void read(RandomAccessFile randomAccessFile) throws IOException {
        super.read(randomAccessFile);
        this.formatStr = utils.readString(randomAccessFile);
        this.setFormatArray();
    }

    void setFormatArray() {
        this.formatStrLen = this.formatStr.length();
        this.pad = new char[this.formatStrLen];
        int n = 0;
        while (n < this.formatStrLen) {
            this.pad[n] = 32;
            ++n;
        }
        tokenList tokenList2 = null;
        try {
            tokenList2 = new tokenList(this.formatStr, false);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        this.formatArray = new int[tokenList2.size()];
        String string = null;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(10);
        int n3 = 0;
        while (n3 < tokenList2.size()) {
            string = tokenList2.getNext();
            if (string.equals("dd")) {
                this.formatArray[n2++] = 1;
                stringBuffer.append('d');
            } else if (string.equals("mm")) {
                this.formatArray[n2++] = 2;
                stringBuffer.append('M');
            } else if (string.equals("mmm")) {
                this.formatArray[n2++] = 3;
                stringBuffer.append('M');
            } else if (string.equals("yy")) {
                this.formatArray[n2++] = 4;
                stringBuffer.append('y');
            } else if (string.equals("yyyy")) {
                this.formatArray[n2++] = 5;
                stringBuffer.append('y');
            } else if (string.equals("hh")) {
                this.formatArray[n2++] = 7;
                stringBuffer.append('H');
            } else if (string.equals("nn")) {
                this.formatArray[n2++] = 8;
                stringBuffer.append('m');
            } else if (string.equals("ss")) {
                this.formatArray[n2++] = 9;
                stringBuffer.append('s');
            } else if (string.equals("lll")) {
                this.formatArray[n2++] = 10;
            }
            ++n3;
        }
        this.preferredParseFormat = stringBuffer.toString();
    }

    void setProperty(int n, Object object) {
        switch (n) {
            case 4: {
                if (object == null) {
                    this.defaultValue = object;
                    return;
                }
                if (!(object instanceof String)) break;
                this.defaultValue = object;
                return;
            }
        }
        super.setProperty(n, object);
    }

    static int stringToInt(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public static Long toDate(String string, String string2, int n, boolean bl) {
        if (string2.length() == 0) {
            return null;
        }
        boolean bl2 = false;
        long l = System.currentTimeMillis();
        if (string2.equalsIgnoreCase("NOW")) {
            if (string != null && string.indexOf(72) < 0 && !bl) {
                l /= 86400000L;
                l *= 86400000L;
            }
            return new Long(l);
        }
        if (string2.equalsIgnoreCase("current time")) {
            return new Long(l);
        }
        tokenList tokenList2 = null;
        try {
            tokenList2 = new tokenList(string2, true);
            if (tokenList2.size() < 3) {
                return null;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        if (string != null) {
            Date date = DateColumn.tryDateFormat(tokenList2, string.toCharArray(), n);
            if (date != null) {
                return new Long(date.getTime());
            }
            tokenList2.reset(0);
        }
        int n2 = 0;
        while (n2 < dateFormats.length) {
            Date date = DateColumn.tryDateFormat(tokenList2, dateFormats[n2].toCharArray(), n);
            if (date != null) {
                return new Long(date.getTime());
            }
            tokenList2.reset(0);
            ++n2;
        }
        return null;
    }

    Object toObject(Object object) {
        Long l;
        if (object == null) {
            return this.nullObj;
        }
        if (object instanceof String) {
            l = DateColumn.toDate(this.preferredParseFormat, (String)object, this.dbase.milleniumBoundary, this.dbase.nowMeansTime);
            if (l == null) {
                return null;
            }
        } else if (object instanceof Date) {
            Date date = (Date)object;
            l = new Long(date.getTime());
        } else {
            return super.toObject(object);
        }
        if (l == Long.MIN_VALUE) {
            return null;
        }
        return l;
    }

    public String toString(Object object) {
        Object object2;
        long l = (Long)object;
        StringBuffer stringBuffer = new StringBuffer(this.formatStrLen + 5);
        if (l == Long.MIN_VALUE) {
            stringBuffer.append("NULL");
        } else {
            this.dateVal.setTime(l);
            object2 = Calendar.getInstance();
            ((Calendar)object2).setTime(this.dateVal);
            int n = ((Calendar)object2).get(5);
            int n2 = ((Calendar)object2).get(2);
            int n3 = ((Calendar)object2).get(1);
            int n4 = ((Calendar)object2).get(11);
            int n5 = ((Calendar)object2).get(12);
            int n6 = ((Calendar)object2).get(13);
            int n7 = ((Calendar)object2).get(14);
            int n8 = 0;
            while (n8 < this.formatArray.length) {
                switch (this.formatArray[n8]) {
                    case 1: {
                        stringBuffer.append(this.pad0(n, 2));
                        break;
                    }
                    case 2: {
                        stringBuffer.append(this.pad0(n2 + 1, 2));
                        break;
                    }
                    case 3: {
                        stringBuffer.append(months[n2]);
                        break;
                    }
                    case 4: {
                        String string = new Integer(n3).toString();
                        int n9 = string.length();
                        stringBuffer.append(string.substring(n9 - 2, n9));
                        break;
                    }
                    case 5: {
                        stringBuffer.append(n3);
                        break;
                    }
                    case 7: {
                        stringBuffer.append(this.pad0(n4, 2));
                        break;
                    }
                    case 8: {
                        stringBuffer.append(this.pad0(n5, 2));
                        break;
                    }
                    case 9: {
                        stringBuffer.append(this.pad0(n6, 2));
                        break;
                    }
                    case 10: {
                        stringBuffer.append(this.pad0(n7, 3));
                        break;
                    }
                }
                if (stringBuffer.length() < this.formatStr.length()) {
                    stringBuffer.append(this.formatStr.charAt(stringBuffer.length()));
                }
                ++n8;
            }
        }
        object2 = stringBuffer.toString();
        return object2;
    }

    static Date tryDateFormat(tokenList tokenList2, char[] cArray, int n) {
        Object object;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < cArray.length) {
            object = tokenList2.getNext();
            if (object == null) break;
            if (((String)object).length() == 1 && !Character.isDigit(((String)object).charAt(0))) {
                object = tokenList2.getNext();
            }
            if (object == null) break;
            int n10 = DateColumn.stringToInt((String)object);
            if (cArray[n9] == 'y') {
                if (n10 < 0 || n10 > 9999) {
                    return null;
                }
                n2 = n10;
            } else if (cArray[n9] == 'M') {
                if (((String)object).length() == 3) {
                    int n11 = 0;
                    while (n11 < months.length) {
                        if (((String)object).equalsIgnoreCase(months[n11])) {
                            n3 = n11;
                            break;
                        }
                        ++n11;
                    }
                    if (n3 == -1) {
                        return null;
                    }
                } else {
                    if (n10 < 1 || n10 > 12) {
                        return null;
                    }
                    n3 = n10 - 1;
                }
            } else if (cArray[n9] == 'd') {
                if (n10 < 1 || n10 > 31) {
                    return null;
                }
                n4 = n10;
            } else if (cArray[n9] == 'H') {
                if (n10 >= 0 || n10 <= 23) {
                    n5 = n10;
                }
            } else if (cArray[n9] == 'm') {
                if (n10 >= 0 || n10 <= 59) {
                    n6 = n10;
                }
            } else if (cArray[n9] == 's') {
                try {
                    Float f = new Float((String)object);
                    n10 = f.intValue();
                    if (n10 >= 0 || n10 <= 59) {
                        n7 = n10;
                        float f2 = f.floatValue();
                        n10 = (int)((f2 - (float)n7) * 1000.0f);
                        if (n10 >= 0 || n10 <= 999) {
                            n8 = n10;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            ++n9;
        }
        if (n2 == -1 || n3 == -1 || n4 == -1) {
            return null;
        }
        if (n2 < 100) {
            n2 = n != 0 ? (n2 < n ? (n2 += 2000) : (n2 += 1900)) : (n2 += 1900);
        }
        object = Calendar.getInstance();
        ((Calendar)object).setLenient(false);
        try {
            ((Calendar)object).set(n2, n3, n4, n5, n6, n7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid date");
        }
        ((Calendar)object).set(14, n8);
        Date date = ((Calendar)object).getTime();
        return date;
    }

    void write(RandomAccessFile randomAccessFile) throws IOException {
        super.write(randomAccessFile);
        utils.writeString(randomAccessFile, this.formatStr);
    }

    void writeObject(idbDataOutputStream idbDataOutputStream2, Object object, Transaction transaction, int n) throws IOException {
        super.writeObject(idbDataOutputStream2, object, transaction, n);
    }
}

