/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import org.enhydra.instantdb.db.Column;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.Transaction;
import org.enhydra.instantdb.db.idbDataOutputStream;

class FloatColumn
extends Column {
    static final float NULL_VALUE = Float.NaN;
    static int time;

    FloatColumn(Table table, String string) throws SQLException, NumberFormatException {
        super(table, string, 4);
        this.nullObj = new Float(Float.NaN);
        this.type = 7;
    }

    void close(RandomAccessFile randomAccessFile) throws IOException {
    }

    boolean compare(int n, Object object, int n2, boolean bl) throws SQLException {
        return FloatColumn.compareVals(this.getByRow(n), object, n2, bl);
    }

    static boolean compareVals(Object object, Object object2, int n, boolean bl) throws SQLException {
        float f = ((Number)object).floatValue();
        float f2 = ((Number)object2).floatValue();
        if (object instanceof Float && object2 instanceof Float) {
            if (bl) {
                if (n == 1) {
                    if (((Float)object).isNaN() && ((Float)object2).isNaN()) {
                        return true;
                    }
                } else if (n == 4 && ((Float)object).isNaN() && ((Float)object2).isNaN()) {
                    return false;
                }
            } else {
                if (((Float)object).isNaN()) {
                    return false;
                }
                if (((Float)object2).isNaN()) {
                    return false;
                }
            }
        }
        switch (n) {
            case 1: {
                return f == f2;
            }
            case 4: {
                return f != f2;
            }
            case 7: {
                return f < f2;
            }
            case 8: {
                return f <= f2;
            }
            case 5: {
                return f > f2;
            }
            case 6: {
                return f >= f2;
            }
        }
        throw new SQLException("Internal error: undefined operation: " + n, "XOPEN?");
    }

    Object getByRow(int n) throws SQLException {
        Object object = super.getByRow(n);
        if (object == null) {
            try {
                float f = this.cTable.dataIn.readFloat();
                this.cTable.rndFile.freeReadAhead();
                object = new Float(f);
            }
            catch (Exception exception) {
                this.cTable.rndFile.freeReadAhead();
                throw new SQLException("Problem reading column, " + this.colName + ", in table, " + this.cTable.tableName + ", " + exception.toString());
            }
            this.rowCache.add(object, n);
        }
        return object;
    }

    int getHash(Object object) {
        return Float.floatToIntBits(((Number)object).floatValue());
    }

    boolean hashPreservesOrder() {
        return false;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    public boolean isNull(Object object) {
        Float f = (Float)object;
        return f.equals(this.nullObj);
    }

    boolean numeric() {
        return true;
    }

    void read(RandomAccessFile randomAccessFile) throws IOException {
    }

    void setBooleanProperty(int n, boolean bl) {
        super.setBooleanProperty(n, bl);
    }

    void setProperty(int n, Object object) {
        switch (n) {
            case 4: {
                if (object == null) {
                    super.setProperty(n, null);
                    return;
                }
                Float f = new Float((String)object);
                if (f.floatValue() == Float.NaN && !this.dbase.microsoftVM) {
                    throw new NumberFormatException(object.toString());
                }
                super.setProperty(n, f);
                break;
            }
            default: {
                super.setProperty(n, object);
            }
        }
    }

    Object toObject(Object object) {
        Float f;
        if (object == null) {
            return this.nullObj;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return this.nullObj;
            }
            try {
                f = new Float(string);
            }
            catch (Exception exception) {
                return null;
            }
        } else {
            if (object instanceof Float) {
                return (Float)object;
            }
            if (object instanceof Number) {
                float f2 = ((Number)object).floatValue();
                f = new Float(f2);
            } else {
                return null;
            }
        }
        if (f.floatValue() == Float.NaN && !this.allowAccidentalNulls) {
            if (f.floatValue() == 0.0f) {
                return f;
            }
            return null;
        }
        return f;
    }

    public String toString(Object object) {
        String string = ((Float)object).isNaN() ? "NULL" : object.toString();
        return string;
    }

    void write(RandomAccessFile randomAccessFile) throws IOException {
    }

    void writeObject(idbDataOutputStream idbDataOutputStream2, Object object, Transaction transaction, int n) throws IOException {
        float f = ((Float)object).floatValue();
        idbDataOutputStream2.writeFloat(f);
    }
}

