/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.commandeclient;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;

import org.opensi.api.ActionError;
import org.opensi.api.ActionOSI;
import org.opensi.api.LeevElement;
import org.opensi.api.Parameters;
import org.opensi.api.SessionOSI;
import org.opensi.bo.commandeclient.BOCommandeClient;
import org.opensi.data.dossier.Adresse;
import org.opensi.data.dossier.CommandeClient;
import org.opensi.data.dossier.Contact;
import org.opensi.data.dossier.HistoriqueCommandeClient;
import org.opensi.dbm.dossier.DBM_CommandeClient;
import org.opensi.dbm.dossier.DBM_HistoriqueCommandeClient;
import org.opensi.util.tools.DateTime;


public class UpdateCommande implements ActionOSI {
	
	BOCommandeClient boComCli = null;
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		int user = sosi.getUtilisateurId();
		
		boComCli = new BOCommandeClient(con,baseDossier);
		DBM_CommandeClient dbmComCli = new DBM_CommandeClient(con,baseDossier);

		
		long dateCourante = new DateTime().getTimeInMillis();
		long dateDelai = param.getParameter("Date_Delai").equals("")?0:param.getDateParameter("Date_Delai");
		int utilM = user;
		int utilR = param.getIntParameter("Util_R");
		int modeExpedition = Integer.parseInt(param.getParameter("Mode_Expedition"));
		int secteurActivite = Integer.parseInt(param.getParameter("Secteur_Activite"));
		String clientId = param.getParameter("Client_Id");
		int commandeClientId = param.getNullParameter("Commande_Id")!=null?param.getIntParameter("Commande_Id"):0;
		if (commandeClientId!=0) {
			String refCommande = param.getParameter("Ref_Commande");
			boolean editionTTC = Integer.parseInt(param.getParameter("Edition_TTC"))==0?false:true;
			String regimeTVA = param.getParameter("Regime_TVA");
			boolean assujettiTVA = Integer.parseInt(param.getParameter("Assujetti_TVA"))==0?false:true;
			String numTVAIntra = param.getParameter("Num_TVA_Intra");
			int codeTarif = Integer.parseInt(param.getParameter("Code_Tarif"));
			int modeReglement = Integer.parseInt(param.getParameter("Mode_Reglement"));
			String commentairesFin = param.getParameter("Commentaires_Fin");
			String commentairesInt = param.getParameter("Commentaires_Int");
			double remise = Double.parseDouble(param.getParameter("Taux_Remise"));
			double montantRemise = Double.parseDouble(param.getParameter("Montant_Remise"));
			double pRemiseFP = Double.parseDouble(param.getParameter("PRemise_FP"));
			double mRemiseFP = Double.parseDouble(param.getParameter("MRemise_FP"));
			double escompte = Double.parseDouble(param.getParameter("Escompte"));
			double fraisPort = Double.parseDouble(param.getParameter("Frais_Port"));
			int codeTVAPort = Integer.parseInt(param.getParameter("Code_TVA_Port"));
			double tauxTVAPort = Double.parseDouble(param.getParameter("Taux_TVA_Port"));
			
			
			
			String listeMentions = "";
			PreparedStatement psSelMentions = con.prepareStatement(" select lm.Libelle from "+baseDossier+".LISTE_MENTIONS lm, "+baseDossier+".MENTION_COMMANDE_CLIENT mcc where lm.Mention_Id=mcc.Mention_Id and mcc.Commande_Id=?");
			psSelMentions.setInt(1, commandeClientId);
			ResultSet rset = psSelMentions.executeQuery();
			while (rset.next()) {
				listeMentions +=rset.getString("Libelle")+"\n";
			}
			
			CommandeClient commandeClient = dbmComCli.load(commandeClientId);
			
			Adresse adresseFact = new Adresse(param.getParameter("Denomination_Fact"), param.getParameter("Adresse_1_Fact"), param.getParameter("Adresse_2_Fact"), param.getParameter("Adresse_3_Fact"), param.getParameter("Code_Postal_Fact"), param.getParameter("Ville_Fact"), param.getParameter("Code_Pays_Fact"));
			Contact contactFact = new Contact(Integer.parseInt(param.getParameter("Civ_Inter_Fact")),param.getParameter("Nom_Inter_Fact"),param.getParameter("Prenom_Inter_Fact"),param.getParameter("Tel_Inter_Fact"),param.getParameter("Fax_Inter_Fact"),param.getParameter("Email_Inter_Fact"));
			commandeClient.setAdresseFact(adresseFact);
			commandeClient.setContactFact(contactFact);
			
			Adresse adresseLiv = new Adresse(param.getParameter("Denomination_Liv"), param.getParameter("Adresse_1_Liv"), param.getParameter("Adresse_2_Liv"), param.getParameter("Adresse_3_Liv"), param.getParameter("Code_Postal_Liv"), param.getParameter("Ville_Liv"), param.getParameter("Code_Pays_Liv"));
			Contact contactLiv = new Contact(Integer.parseInt(param.getParameter("Civ_Inter_Liv")),param.getParameter("Nom_Inter_Liv"),param.getParameter("Prenom_Inter_Liv"),param.getParameter("Tel_Inter_Liv"),param.getParameter("Fax_Inter_Liv"),param.getParameter("Email_Inter_Liv"));
			commandeClient.setAdresseLiv(adresseLiv);
			commandeClient.setContactLiv(contactLiv);
	
			Adresse adresseEnvoi = new Adresse(param.getParameter("Denomination_Envoi"), param.getParameter("Adresse_1_Envoi"), param.getParameter("Adresse_2_Envoi"), param.getParameter("Adresse_3_Envoi"), param.getParameter("Code_Postal_Envoi"), param.getParameter("Ville_Envoi"), param.getParameter("Code_Pays_Envoi"));
			Contact contactEnvoi = new Contact(Integer.parseInt(param.getParameter("Civ_Inter_Envoi")),param.getParameter("Nom_Inter_Envoi"),param.getParameter("Prenom_Inter_Envoi"),param.getParameter("Tel_Inter_Envoi"),param.getParameter("Fax_Inter_Envoi"),param.getParameter("Email_Inter_Envoi"));
			commandeClient.setAdresseEnvoi(adresseEnvoi);
			commandeClient.setContactEnvoi(contactEnvoi);
	
			commandeClient.setUtilM(utilM);
			commandeClient.setUtilR(utilR);
			commandeClient.setDateM(dateCourante);
			commandeClient.setRefCommande(refCommande);
			commandeClient.setEditionTTC(editionTTC);
			commandeClient.setRegimeTVA(regimeTVA);
			commandeClient.setAssujettiTVA(assujettiTVA);
			commandeClient.setNumTVAIntra(numTVAIntra);
			commandeClient.setCodeTarif(codeTarif);
			commandeClient.setDelai(dateDelai);
			commandeClient.setClientId(clientId);
			commandeClient.setModeReglement(modeReglement);
			commandeClient.setCommentairesFin(commentairesFin);
			commandeClient.setCommentairesInt(commentairesInt);
			commandeClient.setMentions(listeMentions);
			commandeClient.setRemise(remise);
			commandeClient.setMontantRemise(montantRemise);
			commandeClient.setPRemiseFP(pRemiseFP);
			commandeClient.setMRemiseFP(mRemiseFP);
			commandeClient.setEscompte(escompte);
			commandeClient.setFraisPort(fraisPort);
			commandeClient.setCodeTVAPort(codeTVAPort);
			commandeClient.setTauxTVAPort(tauxTVAPort);
			commandeClient.setModeExpedition(modeExpedition);
			commandeClient.setSecteurActivite(secteurActivite);
	
			CommandeClient commandeClientBase = dbmComCli.load(commandeClient.getCommandeId());
	
			if (boComCli.isCloturee(commandeClientBase)) {
				error.addError(1002, "Impossible de modifier la commande car celle-ci est cl\u00F4tur\u00E9e !");
			}
			else if (commandeClientBase.getEtat().equals("T")) {
				HashMap<String, String> diff = commandeClient.diff(commandeClientBase,con, baseDossier);
				if (diff.containsKey("Remise") && boComCli.getNbFacture(commandeClientBase.getCommandeId())>0) {
					error.addError(1011, "Impossible de modifier la remise de la commande !");
				}
				if (diff.containsKey("Escompte") && boComCli.getNbFacture(commandeClientBase.getCommandeId())>0) {
					error.addError(1012, "Impossible de modifier l'escompte de la commande !");
				}
				if (boComCli.hasDocumentEnCours(commandeClientBase.getCommandeId())) {
					if(!(diff.containsKey("CommentairesInt") && diff.size()==1)) {
						error.addError(1003, "Impossible de modifier la commande car celle-ci est li\u00E9e \u00E0 des documents en cours !");
					}
				}
			}
			if (error.isEmpty()) {
				if (commandeClient.getEtat().equals("T") && !commandeClient.getBloque()) {
					DBM_HistoriqueCommandeClient dbmHistComCli = new DBM_HistoriqueCommandeClient(con, baseDossier);
					HistoriqueCommandeClient histComCli = new HistoriqueCommandeClient(0,new DateTime().getTimeInMillis(),"",commandeClient.getCommandeId(),user, 0);
					
					HashMap<String, String> diff = commandeClient.diff(commandeClientBase, con, baseDossier);
					Iterator<String> i = diff.keySet().iterator();
					
					while (i.hasNext()) {
						String difference = i.next();
						histComCli.setLibelle(diff.get(difference));
						dbmHistComCli.save(histComCli);
					}
					if (diff.containsKey("FraisPort") && commandeClient.getFraisPort()< boComCli.getFraisPortFacturee(commandeClient.getCommandeId())) {
						result.addEntity("Message", "Attention : la diminution des frais de port devra faire l'objet d'un avoir !");
					}
				}
	
				dbmComCli.save(commandeClient);
				boComCli.majStatutFacture(commandeClient.getCommandeId(), user);
				boComCli.majTotaux(commandeClient.getCommandeId());
	
				if (commandeClient.getEtat().equals("T") && !commandeClient.getBloque()) {
					DBM_HistoriqueCommandeClient dbmHistComCli = new DBM_HistoriqueCommandeClient(con, baseDossier);
					HistoriqueCommandeClient histComCli = new HistoriqueCommandeClient(0,new DateTime().getTimeInMillis(),"",commandeClient.getCommandeId(),user, 0);
					commandeClient = dbmComCli.load(commandeClientId);
					HashMap<String, String> diff = commandeClient.diff(commandeClientBase, con, baseDossier);
					Iterator<String> i = diff.keySet().iterator();
					while (i.hasNext()) {
						String difference = i.next();
						if (difference.equals("TotalHT") || difference.equals("TotalTTC")) {
							histComCli.setLibelle(diff.get(difference));
							dbmHistComCli.save(histComCli);
						}
					}
				}
			}
		}
		else {
			System.out.println("problme com"+user+" : "+baseDossier);
		}
	}
} // fin UpdateCommande

