/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.comptes;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.bo.BO_Comptes;

import org.opensi.dbm.dossier.DBM_Compte;

import org.opensi.data.dossier.Compte;


public class SaveCompte implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		String baseExo = sosi.getBaseExo();
		
		String numeroCompte = param.getParameter("Numero_Compte");
		boolean creation = param.getBooleanParameter("Creation");
		
		DBM_Compte dbmCompte = new DBM_Compte(con, baseDossier);				
		
		Compte compte = dbmCompte.load(numeroCompte);
		
		if (creation && compte!=null) {
			error.addError(1, "Le num\u00E9ro de compte existe d\u00E9j\u00E0.");
		} else {
			if (compte==null) compte = new Compte();
			
			BO_Comptes boComptes = new BO_Comptes(con, baseDossier, baseExo);
			
			compte.setNumeroCompte(numeroCompte);
			compte.setIntitule(param.getParameter("Intitule"));
			compte.setTypeCompte(param.getParameter("Type_Compte"));
			compte.setCollectif(param.getNullParameter("Collectif"));
			compte.setContrepartie(param.getNullParameter("Contrepartie"));
			compte.setCodeTVA(param.getIntParameter("Code_TVA"));
			compte.setCumulJournal(param.getBooleanParameter("Cumul_Journal"));
			compte.setDetailCloture(param.getBooleanParameter("Detail_Cloture"));
			compte.setTvaEncaissement(param.getBooleanParameter("Tva_Encaissement"));
			compte.setCentralisateur(compte.getTypeCompte().equals("G") && boComptes.isCentralisateurValide(numeroCompte));

			if (compte.getContrepartie()!=null && !dbmCompte.exist(compte.getContrepartie())) {
				error.addError(1, "Le compte de contrepartie n'existe pas.");
			} else if (compte.getCollectif()!=null && !dbmCompte.exist(compte.getCollectif())) {
				error.addError(1, "Le compte collectif n'existe pas.");
			}
			else {
				boComptes.saveCompte(compte, sosi.getDossierId(), sosi.getEntrepriseId());
			}
		}
	}
		

} // fin SaveCompte

