/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.ecritures;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.bo.BO_Ecritures;
import org.opensi.bo.BO_Comptes;
import org.opensi.bo.BO_Exercices;

import org.opensi.util.sql.SqlUtils;


public class Lettrer implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseExo = sosi.getBaseExo();
		String baseDossier = sosi.getBaseDossier();
		
		String listeOp = SqlUtils.normalizeCSList(param.getParameter("Liste_Op"));
		String numeroCompte = param.getParameter("Numero_Compte");
				
		BO_Ecritures boEcritures = new BO_Ecritures(con, baseDossier, baseExo);
		BO_Comptes boComptes = new BO_Comptes(con, baseDossier, baseExo);
		BO_Exercices boExercices = new BO_Exercices(con, baseDossier, baseExo);
		
		if (listeOp.isEmpty()) {
			error.addError(1, "Impossible de lettrer : aucune op\u00E9ration \u00E0 lettrer !");
		}
		else if (!boComptes.isAssignableCompte(numeroCompte)) {
			error.addError(1, "Impossible de lettrer : le num\u00E9ro de compte est invalide !");
		}
		else if (!boExercices.isExoPrecClos(sosi.getExerciceId()) && boEcritures.opBelongToAN(listeOp)) {
			error.addError(1, "Impossible de lettrer : le lettrage est interdit sur les \u00E0 nouveaux temporaires !");
		}
		else if (!boEcritures.checkOpNonLettrees(listeOp)) {
			error.addError(1, "Impossible de lettrer : une ou plusieurs op\u00E9rations sont d\u00E9j\u00E0 lettr\u00E9es !");
		}
		else if (!boEcritures.checkEquiLettrage(listeOp)) {
			error.addError(1, "Impossible de lettrer : les op\u00E9rations \u00E0 lettrer ne sont pas \u00E9quilibr\u00E9es !");
		}
		else {
			String lettre = boEcritures.lettrer(numeroCompte, listeOp);
			result.addEntity("Lettre", lettre);
		}
	}
	

} // fin Lettrer

