/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.ecritures;


import java.sql.*;

import java.util.HashMap;
import java.util.Iterator;

import org.opensi.api.*;

import org.opensi.util.sql.SqlUtils;
import org.opensi.util.tools.DateTime;

import org.opensi.dbm.exercice.DBM_Ecriture;
import org.opensi.bo.BO_Ecritures;
import org.opensi.bo.BO_Journaux;
import org.opensi.data.exercice.Operation;
import org.opensi.data.exercice.Ecriture;



public class TransferEcrituresJournal implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();	
		
		int numExerciceSrc = param.getIntParameter("ExerciceSrc");
		int numExerciceDest = param.getIntParameter("ExerciceDest");
		String journalSrc = param.getParameter("JournalSrc");
		String journalDest = param.getParameter("JournalDest");	
		
		long periodeSrcDebut = param.getPeriodeParameter("PeriodeSrcDebut");
		long periodeSrcFin = param.getPeriodeParameter("PeriodeSrcFin");		
		long periodeDestDebut = param.getPeriodeParameter("PeriodeDestDebut");
		
		String choix = param.getParameter("TypeSel");
		
		int numEcrDebut = 0;
		int numEcrFin = 0;
		int jourDebut = 0;
		int jourFin = 0;
		
		if (choix.equals("B")) {
			numEcrDebut = param.getIntParameter("NumEcrDebut");
			numEcrFin = param.getIntParameter("NumEcrFin");
		} else if (choix.equals("C")) {
			jourDebut = param.getIntParameter("JourDebut");
			jourFin = param.getIntParameter("JourFin");
		}
		
		boolean extourne = param.getBooleanParameter("Extourne");  
		
		
		
		Statement stt = con.createStatement();
		ResultSet rset = stt.executeQuery("select Nom_Base from "+ baseDossier +".EXERCICE where Num_Exercice="+ numExerciceSrc);

		rset.next();
		
		String baseSrc = rset.getString("Nom_Base");
		
		rset = stt.executeQuery("select Nom_Base from "+ baseDossier +".EXERCICE where Num_Exercice="+ numExerciceDest);

		rset.next();
		
		String baseDest = rset.getString("Nom_Base");
		
		stt.close();
		
		String reqEcr = "select distinct e.Ecriture_Id from "+ baseSrc +".ECRITURE e"
									+" join "+ baseSrc +".OPERATION o on e.Ecriture_Id=o.Ecriture_Id"
									+" left join "+ baseDossier +".LIGNE_RAPPROCHEMENT r on o.Op_Id=r.Op_Id and r.Nom_Base='"+ baseSrc +"'"
									+" where r.Op_Id is null and e.Code_Journal=? and e.Date_Ecriture>=? and e.Date_Ecriture<=?";
		
		if (choix.equals("B")) {
			reqEcr += " and e.Numero>=? and e.Numero<=?";
		}
		else if (choix.equals("C")) {			
			
			reqEcr += " and (";
			
			DateTime currentPeriode = new DateTime(periodeSrcDebut);
		
			while (currentPeriode.getDateInMillis()<=periodeSrcFin) {				
				
				int maxDay = currentPeriode.currentMaxDay();				
				    	 	
				currentPeriode.setDay(jourDebut<maxDay?jourDebut:maxDay);

				long dateDebut = currentPeriode.getDateInMillis();

				currentPeriode.setDay(jourFin<maxDay?jourFin:maxDay);
				
				long dateFin = currentPeriode.getDateFullTime();
				
				currentPeriode.addMonth(1);
				
				reqEcr += "(o.Date_Op>="+ dateDebut +" and o.Date_Op<="+ dateFin +") or ";
			}
			
			reqEcr += "false)";	
		}				
		
		reqEcr += " order by e.Date_Ecriture";
		
		
		PreparedStatement psEcr = con.prepareStatement(reqEcr);
		
		psEcr.setString(1, journalSrc);
		psEcr.setLong(2, periodeSrcDebut);
		psEcr.setLong(3, periodeSrcFin);
		
		if (choix.equals("B")) {
			psEcr.setInt(4, numEcrDebut);
			psEcr.setInt(5, numEcrFin);
		}
		
		String listeEcr = "";
		
		rset = psEcr.executeQuery();
		while (rset.next()) {
			listeEcr += rset.getInt(1) +",";
		}
		
		listeEcr = SqlUtils.normalizeCSList(listeEcr);
		
		psEcr.close();

		
		
		DBM_Ecriture dbmEcrSrc = new DBM_Ecriture(con, baseSrc);
		DBM_Ecriture dbmEcrDest = new DBM_Ecriture(con, baseDest);
		BO_Ecritures boEcrSrc = new BO_Ecritures(con, baseDossier, baseSrc);
		BO_Ecritures boEcrDest = new BO_Ecritures(con, baseDossier, baseDest);
		
		
		BO_Journaux boJournaux = new BO_Journaux(con, baseDossier);
		
		if (listeEcr.equals("")) {
			error.addError(1, "Il n'existe pas d'\u00E9critures dans la s\u00E9lection !");
		} else if (boJournaux.isJournalAN(journalSrc)) {
			error.addError(1, "Vous ne pouvez pas transf\u00E9rer des \u00E9critures d' nouveau");
		}
		else {
		
			//pour chaque criture, load d'un objet criture
			long periodeSrc = periodeSrcDebut;
			long periodeDest = periodeDestDebut;
			boolean transOk;
			int nbe = 0;

			String ids[] = listeEcr.split(",");			

	  	for (int i=0; i<ids.length; i++) {

				int ecritureId = Integer.parseInt(ids[i]);
				transOk = true;

				Ecriture loadecr = dbmEcrSrc.loadWithOp(ecritureId);

				loadecr.setCodeJournal(journalDest);	        

				DateTime dtpci = new DateTime(periodeSrc);
				DateTime dtpc = new DateTime(periodeDest);
				long dateEcriture = loadecr.getDateEcriture();

				while (periodeSrc < dateEcriture) {
					periodeSrc = dtpci.addMonth(1);
					periodeDest = dtpc.addMonth(1);
				}			

				loadecr.setDateEcriture(periodeDest);	

				//changement des donnes, par les donnes cibles	        		
				//sur chaque opration, on initialise les donnes opId, lettrage, date chance, numro de piece
				HashMap<Integer, Operation> operations = loadecr.getOperations();
				Iterator it = operations.keySet().iterator();

				while (it.hasNext()) {

					Operation op = operations.get(it.next());

					//	si les operations sont sur le meme exercice meme lettres on recuppere les ecritures

					if (op.getLettre().isEmpty() || baseSrc.equals(baseDest)) {

						op.setOpId(0);
						//on garde le lettrage si on est sur le meme exercice sinon on ne copie pas l'ecriture
						DateTime dt0 = new DateTime(op.getDateOp());
						DateTime dt1 = new DateTime(periodeDest);
						//si le jour de l'opration est suprieur que sur la priode donn (ex transfert 31=>30)
						if (dt0.getDay()>dt1.currentMaxDay()){	        						        						
							dt1.setDay(dt1.currentMaxDay());
						}	        				
						else{
							dt1.setDay(dt0.getDay());	
						}
						op.setDateOp(dt1.getDateInMillis());

						if (extourne) {
							op.extourner();
						}
					}
					else {
						transOk = false;
					}
				}

				//si les operations sont sur le meme exercice meme lettres on transfere les ecritures
				if (transOk) {
					loadecr.setEcritureId(0);				
					boEcrDest.saveEcriture(loadecr);
					boEcrSrc.deleteEcriture(ecritureId);
				}
				else {
					nbe++; //nombre d'ecritures non transfres
				}
			}

			result.addEntity("NbEcrTrans", ids.length-nbe);
			result.addEntity("NbEcrNonTrans", nbe);
			result.addEntity("NonTransRB", boEcrSrc.getNbEcrInRB(listeEcr));
		}	
		
	}
	

} // fin TransferEcrituresJournal

