/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.transferts;

import java.sql.*;

import org.opensi.api.ActionError;
import org.opensi.api.ActionOSI;
import org.opensi.api.LeevElement;
import org.opensi.api.Parameters;
import org.opensi.api.SessionOSI;
import org.opensi.util.tools.DateTime;


public class VerifTransfert implements ActionOSI {
	
	ActionError actionError;


	protected Connection con;
	protected String baseDossier;


	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
		this.baseDossier = sosi.getBaseDossier();
		this.con = sosi.getConnection();
		this.actionError = error;
		
		String[] listeId = param.getParameter("Liste_Id").split(",");
		String typeListe = param.getParameter("Type");
		
		
		String reqDateDoc = "";
		if (typeListe.equals("FACTURE")) {
			reqDateDoc = "select Date_Facture as Date_Doc, coalesce(Client_Id,'') as Tiers from "+ baseDossier +".FACTURE where Facture_Id=?";
		} else if (typeListe.equals("AVOIR")) {
			reqDateDoc = "select Date_Avoir as Date_Doc, coalesce(Client_Id,'') as Tiers from "+ baseDossier +".AVOIR where Avoir_Id=?";
		} else if (typeListe.equals("ACOMPTE")) {
			reqDateDoc = "select Date_Acompte as Date_Doc, coalesce(Client_Id,'') as Tiers from "+ baseDossier +".ACOMPTE_CLIENT where Acompte_Id=?";
		} else if (typeListe.equals("FACTURE_FOURNISSEUR")) {
			reqDateDoc = "select Date_Facture as Date_Doc, coalesce(Fournisseur_Id,'') as Tiers from "+ baseDossier +".FACTURE_FOURNISSEUR where Facture_Id=?";
		} else if (typeListe.equals("AVOIR_FOURNISSEUR")) {
			reqDateDoc = "select Date_Avoir as Date_Doc, coalesce(Fournisseur_Id,'') as Tiers from "+ baseDossier +".AVOIR_FOURNISSEUR where Avoir_Id=?";
		} else if (typeListe.equals("ENCAISSEMENT")) {
			reqDateDoc = "select Date_Reg as Date_Doc, coalesce(Client_Id,'') as Tiers, Mode_Reg_Id from "+ baseDossier +".REGLEMENT_CLIENT where Reglement_Id=?";
		} else if (typeListe.equals("REMISE_REGL")) {
			reqDateDoc = "select distinct rb.Date_Remise as Date_Doc, coalesce(rc.Client_Id,'') as Tiers, rb.Banque_Remise as Banque from "+ baseDossier +".REGLEMENT_CLIENT rc join "+ baseDossier +".REMISE_REGLEMENT_CLIENT rrc on rc.Reglement_Id=rrc.Reglement_Id join "+ baseDossier +".REMISE_BANQUE rb on rrc.Remise_Id=rb.Remise_Id where rb.Remise_Id=?";
		} else if (typeListe.equals("REMISE_ESP")) {
			reqDateDoc = "select rb.Date_Remise as Date_Doc, '' as Tiers, rb.Banque_Remise as Banque from "+ baseDossier +".REMISE_BANQUE rb where rb.Remise_Id=?";
		} else if (typeListe.equals("REMBOURSEMENT")) {
			reqDateDoc = "select Date_Remboursement as Date_Doc, coalesce(Client_Id,'') as Tiers, Banque_Retrait as Banque from "+ baseDossier +".REMBOURSEMENT_CLIENT where Remboursement_Id=?";
		} else if (typeListe.equals("REGUL_ECHEANCE")) {
			reqDateDoc = "select rec.Date_Regul as Date_Doc, coalesce(ec.Client_Id,'') as Tiers from "+ baseDossier +".REGULARISATION_ECHEANCE_CLIENT rec join "+ baseDossier +".IMPUTATION_ECHEANCE_CLIENT iec on rec.Imputation_Id=iec.Imputation_Id join "+ baseDossier +".ECHEANCE_CLIENT ec on iec.Echeance_Id=ec.Echeance_Id where rec.Regularisation_Id=?";
		} else if (typeListe.equals("REGUL_REGLEMENT")) {
			reqDateDoc = "select rrc.Date_Regul as Date_Doc, coalesce(rc.Client_Id,'') as Tiers from "+ baseDossier +".REGULARISATION_REGLEMENT_CLIENT rrc join "+ baseDossier +".IMPUTATION_REGLEMENT_CLIENT irc on rrc.Imputation_Id=irc.Imputation_Id join "+ baseDossier +".REGLEMENT_CLIENT rc on irc.Reglement_Id=rc.Reglement_Id where rrc.Regularisation_Id=?";
		} else if (typeListe.equals("REGUL_AVOIR")) {
			reqDateDoc = "select rac.Date_Regul as Date_Doc, coalesce(a.Client_Id,'') as Tiers from "+ baseDossier +".REGULARISATION_AVOIR_CLIENT rac join "+ baseDossier +".IMPUTATION_AVOIR_CLIENT iac on rac.Imputation_Id=iac.Imputation_Id join "+ baseDossier +".AVOIR a on iac.Avoir_Id=a.Avoir_Id where rac.Regularisation_Id=?";
		}
		PreparedStatement psDateDoc = con.prepareStatement(reqDateDoc);
		
		int i=0;
		boolean continuer = true;
		while (continuer && i<listeId.length) {
			psDateDoc.setInt(1, Integer.parseInt(listeId[i]));
			ResultSet rset = psDateDoc.executeQuery();
			while (continuer && rset.next()) {
				continuer=false;
				if (existeExercice(rset.getLong("Date_Doc"))) {
					String tiers = rset.getString("Tiers");
					boolean tiersOk = true;
					if (!tiers.equals("")) {
						tiersOk = (typeListe.equals("FACTURE_FOURNISSEUR") || typeListe.equals("AVOIR_FOURNISSEUR")?checkCompteFournisseur(tiers):checkCompteClient(tiers));
					}
					if (tiersOk) {
						if (typeListe.equals("ENCAISSEMENT")) {
							continuer = checkJournalModeReg(rset.getInt("Mode_Reg_Id"));
						} else if (typeListe.equals("REMISE_REGL") || typeListe.equals("REMISE_ESP") || typeListe.equals("REMBOURSEMENT")) {
							continuer = checkJournalBanque(rset.getInt("Banque"));
						} else if (typeListe.equals("ACOMPTE")) {
							continuer = checkJournalAcompte();
						} else if (typeListe.equals("REGUL_ECHEANCE") || typeListe.equals("REGUL_REGLEMENT") || typeListe.equals("REGUL_AVOIR")) {
							continuer = checkJournalRegul();
						} else {
							continuer = true;
						}
					}
				}
			}
			rset.close();
			
			i++;
		}
		psDateDoc.close();
	}
	
	
	public boolean existeExercice(long dateOperation) throws SQLException {
		
		boolean existe = false;
		PreparedStatement psExercice = con.prepareStatement("select Debut_Exercice, Nom_Base from "+ baseDossier +".EXERCICE where Cloture=0 and Verrouille=0 and Debut_Exercice<=? and Fin_Exercice>=?");
		psExercice.setLong(1, dateOperation);
		psExercice.setLong(2, dateOperation);
		ResultSet rset = psExercice.executeQuery();
		if (rset.next()) {
			PreparedStatement psPeriode = con.prepareStatement("select Periode_Id from "+ rset.getString("Nom_Base") +".PERIODE_EXERCICE where Periode>=? and Periode<=? and Cloture=0");
			psPeriode.setLong(1, rset.getLong("Debut_Exercice"));
			psPeriode.setLong(2, dateOperation);
			ResultSet rset2 = psPeriode.executeQuery();
			if (rset2.next()) {
				existe = true;
			} else {
				actionError.addError(1001, "Il n'existe pas de p\u00E9riode non cl\u00F4tur\u00E9e correspondant \u00E0 la date "+ DateTime.formatTime(dateOperation, "dd/MM/yyyy") +" !");
			}
			rset.close();
			psPeriode.close();
			
		} else {
			actionError.addError(1001, "Il n'existe pas d'exercice correspondant \u00E0 la date "+ DateTime.formatTime(dateOperation, "dd/MM/yyyy") +" !");
		}
		rset.close();
		psExercice.close();
		
		return existe;
	}
	
	
	public boolean checkJournalModeReg(int modeRegId) throws SQLException {
		
		boolean existe = false;
		PreparedStatement psModeReg = con.prepareStatement("select Libelle, coalesce(Code_Journal,'') as Code_Journal from "+ baseDossier +".MODE_REGLEMENT where Mode_Reg_Id=?");
		psModeReg.setInt(1, modeRegId);
		ResultSet rset = psModeReg.executeQuery();
		rset.next();
		String libelle = rset.getString("Libelle");
		String codeJournal = rset.getString("Code_Journal");
		rset.close();
		psModeReg.close();
		if (!codeJournal.equals("")) {
			existe = checkContrepartie(codeJournal);
		} else {
			actionError.addError(1001, "Il n'y a pas de journal attach\u00E9 au mode de r\u00E8glement '"+ libelle +"' !");
		}
		
		return existe;
	}
	
	
	public boolean checkJournalBanque(int banqueId) throws SQLException {
		
		boolean existe = false;
		PreparedStatement psBanque = con.prepareStatement("select Nom, coalesce(Code_Journal,'') as Code_Journal from "+ baseDossier +".BANQUE where Banque_Id=?");
		psBanque.setInt(1, banqueId);
		ResultSet rset = psBanque.executeQuery();
		rset.next();
		String libelle = rset.getString("Nom");
		String codeJournal = rset.getString("Code_Journal");
		rset.close();
		psBanque.close();
		if (!codeJournal.equals("")) {
			existe = checkContrepartie(codeJournal);
		} else {
			actionError.addError(1001, "Il n'y a pas de journal attach\u00E9 \u00E0 la banque '"+ libelle +"' !");
		}
		
		return existe;
	}
	
	
	public boolean checkJournalAcompte() throws SQLException {
		
		boolean existe = false;
		PreparedStatement psJournal = con.prepareStatement("select coalesce(Code_Journal_Acpte,'') as Code_Journal from "+ baseDossier +".PARAM_DOSSIER");
		ResultSet rset = psJournal.executeQuery();
		rset.next();
		String codeJournal = rset.getString("Code_Journal");
		rset.close();
		psJournal.close();
		if (!codeJournal.equals("")) {
			existe = true;
		} else {
			actionError.addError(1001, "Le code journal d'acomptes n'a pas \u00E9t\u00E9 param\u00E9tr\u00E9 !");
		}
		
		return existe;
	}
	
	
	public boolean checkJournalRegul() throws SQLException {
		
		boolean existe = false;
		PreparedStatement psJournal = con.prepareStatement("select coalesce(Code_Journal_Regul,'') as Code_Journal from "+ baseDossier +".PARAM_DOSSIER");
		ResultSet rset = psJournal.executeQuery();
		rset.next();
		String codeJournal = rset.getString("Code_Journal");
		rset.close();
		psJournal.close();
		if (!codeJournal.equals("")) {
			existe = true;
		} else {
			actionError.addError(1001, "Le code journal de r\u00E9gularisation n'a pas \u00E9t\u00E9 param\u00E9tr\u00E9 !");
		}
		
		return existe;
	}
	
	
	public boolean checkContrepartie(String codeJournal) throws SQLException {
		
		boolean existe = false;
		PreparedStatement psJournal = con.prepareStatement("select Intitule, coalesce(Contrepartie,'') as Contrepartie from "+ baseDossier +".JOURNAL where Code_Journal=?");
		psJournal.setString(1, codeJournal);
		ResultSet rset = psJournal.executeQuery();
		rset.next();
		String intitule = rset.getString("Intitule");
		if (!rset.getString("Contrepartie").equals("")) {
			existe = true;
		} else {
			actionError.addError(1001, "Le journal '"+ codeJournal +": "+ intitule +"' n'a pas de compte de contrepartie !");
		}
		rset.close();
		psJournal.close();
		
		return existe;
	}


	public boolean checkCompteClient(String clientId) throws SQLException {
		
		boolean existe = false;
		
		PreparedStatement psCompteClient = con.prepareStatement("select Numero_Compte from "+ baseDossier +".FICHE_CLIENT where Numero_Compte is not null and Client_Id=?");
		psCompteClient.setString(1, clientId);
		ResultSet rset = psCompteClient.executeQuery();
		if (rset.next()) {
			existe = true;
		} else {
			actionError.addError(1001, "Le client '"+ clientId +"' n'a pas de compte !");
		}
		rset.close();
		psCompteClient.close();
		
		return existe;
	}
	
	
	public boolean checkCompteFournisseur(String fournisseurId) throws SQLException {
		
		boolean existe = false;
		
		PreparedStatement psCompteFournisseur = con.prepareStatement("select Numero_Compte from "+ baseDossier +".FICHE_FOURNISSEUR where Numero_Compte is not null and Fournisseur_Id=?");
		psCompteFournisseur.setString(1, fournisseurId);
		ResultSet rset = psCompteFournisseur.executeQuery();
		if (rset.next()) {
			existe = true;
		} else {
			actionError.addError(1001, "Le fournisseur '"+ fournisseurId +"' n'a pas de compte !");
		}
		rset.close();
		psCompteFournisseur.close();
		
		return existe;
	}



} // fin VerifTransfert

