/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.api;


import java.sql.*;

import org.experlog.openeas.api.Session;



public class SessionOSI {


	private Session s;
	private Connection con;
	
	
	public SessionOSI(String nSession) {
	
		this.s = Session.findClient(nSession);
	}
	
	
	public SessionOSI(Session s) {
	
		this.s = s;
	}
	
	
	public String getBaseDossier() {
		try {
			return s.getCookie().get("BaseDossier");
		}
		catch(Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	
	public String getDossierId() {
		try {
			return s.getCookie().get("Dossier_Id");
		}
		catch(Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	public int getExerciceId() {
		try {
			return Integer.parseInt(s.getCookie().get("Exercice_Id"));
		}
		catch(Exception e) {
			e.printStackTrace();
			return -1;
		}
	}
	
	public int getEntrepriseId() {
		try {
			return Integer.parseInt(s.getCookie().get("Entreprise_Id"));
		}
		catch(Exception e) {
			e.printStackTrace();
			return -1;
		}
	}
	
	
	public String getBaseExo() {
		try {
			return s.getCookie().get("BaseExo");
		}
		catch(Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	
	public int getUtilisateurId() {
		try {
			return Integer.parseInt(s.getCookie().get("User"));
		}
		catch(Exception e) {
			e.printStackTrace();
			return -1;
		}
	}
	
	
	public String getPdfDirectory() {
		try {
			return this.s.getAppConfiguration().get("opensi.absdir") +"/pdf/";
		}
		catch(Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	
	public String getIODirectory() {
		try {
			return this.s.getAppConfiguration().get("opensi.absdir") +"/iobuffer/";
		}
		catch(Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	
	public String getDatabaseDirectory() {
		try {
			return this.s.getAppConfiguration().get("opensi.absdir") +"/database/";
		}
		catch(Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	
	public String getPhotosArticlesDirectory() {
		try {
			return this.s.getAppConfiguration().get("opensi.absdir") +"/photos_articles/";
		}
		catch(Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	
	public String getLogosDirectory() {
		try {
			return this.s.getAppConfiguration().get("opensi.absdir") +"/logos/";
		}
		catch(Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	
	public String getImagesDirectory() {
		try {
			return this.s.getAppConfiguration().get("opensi.absdir") +"/images/";
		}
		catch(Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	
	public Connection getConnection() {
		try {
		
			if (this.con==null) {
				this.con = s.getConnection(null);
			}
		
			return this.con;
		
		}
		catch(Exception e) {
			return null;
		}
	}
	
	
	private void closeConnection() {
		try {
		
			if (s!=null) {
				s.closeConnection(con, null);
			}
			
		}
		catch(SQLException sqle) {
			sqle.printStackTrace();
		}
	}
	
	
	public void close() {
	
		this.closeConnection();
	}
	

} // fin SessionOSI

