/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.api.data;


import java.util.HashMap;
import java.util.Iterator;


public abstract class DataOSI {
	
	
	private HashMap<String, Field> fields = new HashMap<String, Field>();
	
		
	public boolean isValid() {
	
		Iterator<String> i = fields.keySet().iterator();
		
		while (i.hasNext()) {
			if (!fields.get(i.next()).isValid()) return false;
		}		
		
		return true;
	}
	
	
	public String getDisplay() {
		
		String display = "Objet "+ getClass().getName() +"\n";
		
		Iterator<String> i = fields.keySet().iterator();
		
		while (i.hasNext()) {
			display += fields.get(i.next()).getDisplay();
		}
		
		return display;
	}
	
	
	
	
	public final void setString(String fieldName, String fieldValue) {
		
		fields.get(fieldName).setValue(fieldValue);
	}
	
	
	public final void setBoolean(String fieldName, Boolean fieldValue) {
		
		fields.get(fieldName).setValue(fieldValue);
	}
	
	
	public final void setInt(String fieldName, Integer fieldValue) {
		
		fields.get(fieldName).setValue(fieldValue);
	}
	
	
	public final void setDouble(String fieldName, Double fieldValue) {
		
		fields.get(fieldName).setValue(fieldValue);
	}
	
	
	public final void setLong(String fieldName, Long fieldValue) {
		
		fields.get(fieldName).setValue(fieldValue);
	}
	
	
	
	
	
	public final String getString(String fieldName) {
	
		return (String) fields.get(fieldName).getValue();
	}
	
	
	public final Boolean getBoolean(String fieldName) {
	
		return (Boolean) fields.get(fieldName).getValue();
	}
	
	
	public final Integer getInt(String fieldName) {
	
		return (Integer) fields.get(fieldName).getValue();
	}
	
	
	public final Double getDouble(String fieldName) {
	
		return (Double) fields.get(fieldName).getValue();
	}
	
	
	public final Long getLong(String fieldName) {
	
		return (Long) fields.get(fieldName).getValue();
	}
	
	
	
	
	
	protected final void register(Field field) {
	
		fields.put(field.getName(), field);
	}
		

} // fin DataOSI

