/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un tat des stocks en csv
 */

package org.opensi.compta.actions.etats;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;


public class CsvPlanComptableGeneral {

	public CsvPlanComptableGeneral(String buffer, String fichier, DataPlanComptableGeneral dataPCG) throws Exception {

		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Code");
		lf.addToLine("Lib\u00E9l\u00E9");
		lf.addToLine("Niveau");
		lf.addToLine("Numero classe");
		

		int nbLignes = dataPCG.getNbLignes();

		for (int i=0; i<nbLignes; i++) {
			LignePlanGeneral lpg = dataPCG.lignes.get(i);

			lf.newLine();
			lf.addToLine("" + lpg.code);
			lf.addToLine("" + lpg.libClasse + "");
			lf.addToLine(("" + lpg.niveau));
			lf.addToLine(("" + lpg.numClasse));
			
		}

		lf.write(buffer, fichier, true);
	}



} // fin CsvEtatStock
