/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes pour l'edition de tat d'avancement
 */

package org.opensi.compta.actions.etats;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;


public class DataEtatAvancement {
	
	protected ArrayList<ArrayList<String>> etatAvancement = new ArrayList<ArrayList<String>>();
	
	protected String dossierId;
	protected String raisonSociale;
	protected String adresse;
	protected String compAdresse;
	protected String codePostal;
	protected String ville;
	
	protected String debutExercice;
	protected String finExercice;
	protected String dateCourante;
	
	public DataEtatAvancement(Session s, String typeExercice) {	
		try {
			Connection con = s.getConnection(null);
			this.dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			String baseExo = s.getCookie().get("BaseExo");
			
			String reqLeDossier = "select * from "+ base +".SOCIETE";
			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery(reqLeDossier);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse = rset.getString("Adresse_1");
			this.compAdresse = rset.getString("Adresse_2");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			rset.close();

			int numExercice = Integer.parseInt(s.getCookie().get("Num_Exercice"));
			long debutEx = Long.parseLong(s.getCookie().get("Debut_Exercice"));
			long finEx = Long.parseLong(s.getCookie().get("Fin_Exercice"));
			
			if (typeExercice.equals("N1")) {
				String reqLastExercice = "select Nom_Base, Debut_Exercice, Fin_Exercice from "+ base +".EXERCICE where Num_Exercice<"+ numExercice +" order by Num_Exercice desc limit 1";
				rset = stt.executeQuery(reqLastExercice);
				if (rset.next()) {
					baseExo = rset.getString("Nom_Base");
					debutEx = rset.getLong("Debut_Exercice");
					finEx = rset.getLong("Fin_Exercice");
				}
				rset.close();
			}
			
			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			this.debutExercice = formatDate.format(new Date(debutEx));
			this.finExercice = formatDate.format(new Date(finEx));
			
			int totalGeneral = 0;
			ArrayList<String> listeJournaux = new ArrayList<String>();
			ArrayList<Integer> listeNbOp = new ArrayList<Integer>();
			ArrayList<Integer> listeNbOpPeriodes = new ArrayList<Integer>();
			ArrayList<Integer> listeTotauxPeriodes = new ArrayList<Integer>();

			String reqJournaux = "select Code_Journal from "+ base +".JOURNAL j, ORDRE_JOURNAUX o where o.Type_Journal=j.Type_Journal order by Ordre_Affichage, Code_Journal";
			PreparedStatement psJournaux = con.prepareStatement(reqJournaux);
			rset = psJournaux.executeQuery();
			while (rset.next()) {
				listeJournaux.add(rset.getString("Code_Journal"));
			}
			rset.close();
			psJournaux.close();

			String reqNbOpPeriodes = "select * from "+ baseExo +".NB_OP_JOURNAUX";
			reqNbOpPeriodes += " where Code_Journal=? and Periode=?";
			PreparedStatement psNbOpPeriodes = con.prepareStatement(reqNbOpPeriodes);
			
			ArrayList<String> listePeriodes = new ArrayList<String>(10);
			
			String reqPeriodes = "select Periode, Cloture from "+ baseExo +".PERIODE_EXERCICE where Periode>="+ debutEx +" and Periode<="+ finEx +" order by Periode";
			rset = stt.executeQuery(reqPeriodes);
			while (rset.next()) {
				int totalPeriode = 0;
				long periode = rset.getLong("Periode");
				psNbOpPeriodes.setLong(2, periode);
				String lblPeriode = DateTime.formatTime(periode, "MM/yy");
				if (rset.getBoolean("Cloture")) { lblPeriode += " (c)"; }
				listePeriodes.add(lblPeriode);
				int nbJournaux = listeJournaux.size();
				for (int j=0; j<nbJournaux; j++) {
					psNbOpPeriodes.setString(1, listeJournaux.get(j));
					ResultSet rset2 = psNbOpPeriodes.executeQuery();
					if (rset2.next()) {
						int nbOpPeriodes = rset2.getInt("Nb_Op");
						totalPeriode += nbOpPeriodes;
						listeNbOpPeriodes.add(nbOpPeriodes);
						while (rset2.next()) {
							nbOpPeriodes = rset2.getInt("Nb_Op");
							totalPeriode += nbOpPeriodes;
							listeNbOpPeriodes.add(nbOpPeriodes);
						}
					} else {
						listeNbOpPeriodes.add(0);
					}
					rset2.close();
				}
				listeTotauxPeriodes.add(totalPeriode);
			}
			rset.close();
			psNbOpPeriodes.close();

			String reqNbOp = "select Code_Journal, sum(Nb_Op) as nbop from "+ baseExo +".NB_OP_JOURNAUX";
			reqNbOp += " where Code_Journal=? group by Code_Journal";
			PreparedStatement psNbOp = con.prepareStatement(reqNbOp);
			int nbJournaux = listeJournaux.size();
			for (int i=0; i<nbJournaux; i++) {
				psNbOp.setString(1, listeJournaux.get(i));
				rset = psNbOp.executeQuery();
				if (rset.next()) {
					int nbOp = rset.getInt("nbop");
					totalGeneral += nbOp;
					listeNbOp.add(nbOp);
				} else {
					listeNbOp.add(0);
				}
				rset.close();
			}
			psNbOp.close();
			
			ArrayList<String> ligneEnTete = new ArrayList<String>();
			ligneEnTete.add("");
			for (int i=0; i<nbJournaux; i++) {
				ligneEnTete.add(listeJournaux.get(i));
			}
			ligneEnTete.add("Total");
			this.etatAvancement.add(ligneEnTete);
			
			int rank=0;
			int nbPeriodes = listePeriodes.size();
			for (int i=0; i<nbPeriodes; i++) {
				ArrayList<String> ligne = new ArrayList<String>();
				ligne.add(listePeriodes.get(i));
				for (int j=0; j<nbJournaux; j++) {
					ligne.add(""+listeNbOpPeriodes.get(rank));
					rank++;
				}
				ligne.add(""+listeTotauxPeriodes.get(i));
				this.etatAvancement.add(ligne);
			}
			
			ArrayList<String> ligneFin = new ArrayList<String>();
			ligneFin.add("Total");
			int nbOp = listeNbOp.size();
			for (int i=0; i<nbOp; i++) {
				ligneFin.add(""+listeNbOp.get(i));
			}
			ligneFin.add(""+totalGeneral);
			this.etatAvancement.add(ligneFin);

			stt.close();
			s.closeConnection(con, null);
			
		} catch(Exception e) { e.printStackTrace();	}
	
	}


} // fin DataEtatAvancement
