/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un tat d'avancement
 */

package org.opensi.compta.actions.etats;


import java.awt.Color;
import java.util.ArrayList;

import org.opensi.util.pdf.MultiPagesDocument;
import org.opensi.util.pdf.TableBuilder;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;


public class EtatAvancementStd extends MultiPagesDocument {


	private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);
	private static final Font fontLine = new Font(Font.HELVETICA , 7, Font.NORMAL);
	private static final Font fontLineGras = new Font(Font.HELVETICA , 7, Font.BOLD);
	private static final Font fontTitre = new Font(Font.HELVETICA , 16, Font.BOLD);

	private DataEtatAvancement dea;

	
	public EtatAvancementStd(String tempdir, DataEtatAvancement dea) throws Exception {

		super(tempdir);
		this.dea = dea;
	
	}


	
	/* implmentation des fonctions de MultiPagesDocument */
	
	public PdfPTable firstHeader() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeEntete());
		tb.add(makeSpace(10));
		
		return tb.getTable();	
	}
	
	
	public PdfPTable middleHeader(int lastLine) throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(firstHeader());
		
		return tb.getTable();
	}
	
	
	public PdfPTable lastFooter() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		return tb.getTable();
	}	
	
	
	public PdfPTable middleFooter(int nbLinesPage, int lastLine) throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(lastFooter());
		
		return tb.getTable();		
	}
	
	
	public PdfPTable bodyLine(int numLine) throws DocumentException {
		return makeTableauAvancement();
	}
	
	
	public PdfPTable emptyLine(float emptyHeight) throws DocumentException {
		
		PdfPTable pptSpace = new PdfPTable(1);
		pptSpace.setWidthPercentage(100);
		
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(emptyHeight);		
		cell.setPhrase(new Phrase(""));		
	
		pptSpace.addCell(cell);
	
		return pptSpace;
	}
	
	
	public int nbLines() {
	
		return 1;
	}
	
	
	public int nbEx() {
	
		return 1;
	}
	
	
	public Image imageFond() {
		return null;
	}



	/* mthodes internes */

	private PdfPTable makeSpace(int space) {
	
		PdfPTable pptSpace = new PdfPTable(1);
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(space);
		cell.setPhrase(new Phrase(""));
	
		pptSpace.addCell(cell);
	
		return pptSpace;
	}
	
	
	private PdfPTable makeEntete() {
		
		PdfPTable pptGlobal = new PdfPTable(1);
		pptGlobal.setWidthPercentage(100);
		
		PdfPTable pptEntete = new PdfPTable(1);
		pptEntete.setWidthPercentage(100);
		PdfPCell cellEntete = new PdfPCell(pptEntete.getDefaultCell());
		cellEntete.setBorder(PdfPCell.NO_BORDER);

		cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellEntete.setBorderWidth(0);
		cellEntete.setMinimumHeight(10);

		cellEntete.setPhrase(new Phrase("Dossier : " + dea.dossierId, fontGen));
		pptEntete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(dea.raisonSociale, fontGen));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		pptEntete.addCell(cellEntete);
		cellEntete.setColspan(1);

		cellEntete.setPhrase(new Phrase("Date : " + dea.dateCourante, fontGen));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		pptEntete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(dea.adresse, fontGen));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		pptEntete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase("Exercice du " + dea.debutExercice + " au " + dea.finExercice, fontGen));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		pptEntete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(dea.compAdresse, fontGen));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		pptEntete.addCell(cellEntete);
		cellEntete.setColspan(1);

		cellEntete.setPhrase(new Phrase("Page : "+ currentPage, fontGen));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		pptEntete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(dea.codePostal + " " + dea.ville, fontGen));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		pptEntete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase("Etat d'avancement au "+ dea.dateCourante, fontTitre));
		cellEntete.setColspan(3);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		pptEntete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(""));
		cellEntete.setFixedHeight(10);
		pptEntete.addCell(cellEntete);

		cellEntete.setMinimumHeight(0);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		pptEntete.addCell(cellEntete);
	
		PdfPCell cellGlobal = new PdfPCell(pptEntete);
		cellGlobal.setPadding(5);
		pptGlobal.addCell(cellGlobal);
	
		return pptGlobal;
	}
	
	
	private PdfPTable makeTableauAvancement() throws DocumentException {
		
		int nbLignes = dea.etatAvancement.size();
		int nbColonnes = dea.etatAvancement.get(0).size();
		float largeurCol = 100/nbColonnes;
		float[] widths = new float[nbColonnes];
		for (int i=0; i<nbColonnes; i++) {
			widths[i] = largeurCol;
		}
		
		PdfPTable pptLine = new PdfPTable(nbColonnes);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widths);

		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setBorder(PdfPCell.BOX);
		cell.setPaddingLeft(0);
		cell.setMinimumHeight(15);
		
		for (int i=0; i<nbLignes; i++) {
			ArrayList<String> ligne = dea.etatAvancement.get(i);
			if (i==(nbLignes-1)) {
				cell.setBorderWidthTop(1.5f);
				cell.setBorderWidthBottom(1.5f);
			}
			for (int j=0; j<nbColonnes; j++) {
				if (i==0 || j==0) {
					cell.setBackgroundColor(new Color(252,217,175));
					cell.setPhrase(new Phrase(ligne.get(j), fontLineGras));
					cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
					cell.setPaddingRight(0);
				} else {
					cell.setBackgroundColor(new Color(255,255,255));
					cell.setPhrase(new Phrase(ligne.get(j), fontLine));
					cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
					cell.setPaddingRight(5);
				}
				pptLine.addCell(cell);
			}
		}

		return pptLine;	
	}
	


} // fin EtatAvancementStd
