/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Edition de la balance.
 */


package org.opensi.compta.actions.etats;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfBalance extends Action {


	class MyPageEvent implements PdfPageEvent {

	private String dateCourante;

	private String dossierId;
	private String raisonSociale;
	private String adresse;
	private String compAdresse;
	private String codePostal;
	private String ville;
	private String monnaie;

	private String debutExercice;
	private String finExercice;

	private String finPeriodeStr;
	private String debutPeriodeStr;


		public MyPageEvent(String dossierId, String type, String periode, String dateDebut, String dateFin, String debutExercice, String finExercice) throws SQLException {

			this.dossierId = dossierId;

			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ baseDossier +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";

			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery(reqLeDossier);

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse = rset.getString("Adresse_1");
			this.compAdresse = rset.getString("Adresse_2");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.monnaie = rset.getString("Devise");

			rset.close();

			stt.close();

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			this.finExercice = formatDate.format(new Date(Long.parseLong(finExercice)));
			this.debutExercice = formatDate.format(new Date(Long.parseLong(debutExercice)));
			finPeriodeStr = formatDate.format(new Date(finPeriode));
			debutPeriodeStr = formatDate.format(new Date(debutPeriode));
		}


    public void onStartPage(PdfWriter writer, Document document) {

    	try {

				// Entete Gnrale


				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase("Dossier : " + this.dossierId, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.adresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				if (exocomplet) {
					cellEntete.setPhrase(new Phrase("", fontGen));
				}
				else {
					cellEntete.setPhrase(new Phrase("Exercice du " + this.debutExercice + " au " + this.finExercice, fontGen));
				}
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.compAdresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(this.codePostal + " " + this.ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Balance "+ titre +" en " + this.monnaie, new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(10);
				entete.addCell(cellEntete);

				if (exocomplet) {
					cellEntete.setPhrase(new Phrase("Exercice du " + this.debutExercice + " au " + this.finExercice, fontGen));
				}
				else {
					cellEntete.setPhrase(new Phrase("P\u00E9riode du " + this.debutPeriodeStr + " au " + this.finPeriodeStr, fontGen));
				}

				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete Gnrale


				// Titres de colonnes

				PdfPTable titresColonnes = new PdfPTable(5);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widths);
				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(15);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setColspan(5);
				titresColonnes.addCell(cellTitre);
				cellTitre.setColspan(1);

				cellTitre.setFixedHeight(20);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);


				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
				cellTitre.setPhrase(new Phrase("COMPTE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
				cellTitre.setPhrase(new Phrase("INTITULE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

				cellTitre.setPhrase(new Phrase("DEBIT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("CREDIT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("SOLDE", fontLine));
				titresColonnes.addCell(cellTitre);

				document.add(titresColonnes);

				// fin Titres de colonnes

			}
			catch(DocumentException de) {	de.printStackTrace(); }

		}

		public void onOpenDocument(PdfWriter writer, Document document) {}
    public void onEndPage(PdfWriter writer, Document document) {}
    public void onCloseDocument(PdfWriter writer, Document document) {}
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
    public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
    public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
    public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

}


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontLine = new Font(Font.HELVETICA , 9, Font.NORMAL);		// font pour lignes de listing
private DecimalFormat numFormat = new DecimalFormat("0.00");

private int widths[] = {12,40,16,16,16}; // largeurs des colonnes du listing
private long debutPeriode;
private	long finPeriode;
private boolean exocomplet;
private String base;
private String edition;
private String cpteDebut;
private String cpteFin;
private String debutExercice;
private String finExercice;
private String edCpte;
private String titre;
private String baseDossier;

Connection con;

  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		con = s.getConnection(null);


		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);


		String dossierId = s.getCookie().get("Dossier_Id");
		this.base = s.getCookie().get("BaseExo");
		baseDossier = s.getCookie().get("BaseDossier");

		this.debutExercice = r.getParameter("Debut_Exercice");
		this.finExercice = r.getParameter("Fin_Exercice");
		String type = r.getParameter("Type");
		String periode = r.getParameter("Periode");
		String dateDebut = r.getParameter("Date_Debut");
		String dateFin = r.getParameter("Date_Fin");
		this.edition = r.getParameter("Edition");
		this.cpteDebut = r.getParameter("Cpte_Debut");
		this.cpteFin = r.getParameter("Cpte_Fin");
		this.edCpte = r.getParameter("Ed_Cpte");


		if (periode.equals("dd")) {
			debutPeriode = DateTime.parseDate(dateDebut, "dd/MM/yy");
			finPeriode = DateTime.parseDate(dateFin, "dd/MM/yy");
			exocomplet = false;
		}
		else {
			debutPeriode = Long.parseLong(debutExercice);
			finPeriode = Long.parseLong(finExercice);
			exocomplet = true;
		}


		Document document = new Document(PageSize.A4, 25, 25, 25, 25);

    String chemin = s.getAppConfiguration().get("opensi.absdir") + "/pdf/";

		String fichierPdf = r.getParameter("FichierPDF");

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

		MyPageEvent event = new MyPageEvent(dossierId, type, periode, dateDebut, dateFin, debutExercice, finExercice);

		writer.setPageEvent(event);

		switch (type.charAt(0)) {
			case 'G': this.titre="G\u00E9n\u00E9rale";	break;
			case 'F': this.titre="Fournisseurs";	break;
			case 'C': this.titre="Clients";				break;
			case 'A': this.titre="Auxiliaires";		break;
			case 'T': this.titre="Clients";				break;
			default:	this.titre="G\u00E9n\u00E9rale";
		}

		document.open();


		PdfPTable listing = new PdfPTable(5);
		listing.setWidthPercentage(100);
		listing.setWidths(widths);

		if (type.equalsIgnoreCase("T")) {
			putBalance(listing, "C");
			document.add(listing);
			listing = new PdfPTable(5);
			listing.setWidthPercentage(100);
			listing.setWidths(widths);
			this.titre="Fournisseurs";
			document.newPage();
			putBalance(listing, "F");
			document.add(listing);
			listing = new PdfPTable(5);
			listing.setWidthPercentage(100);
			listing.setWidths(widths);
			this.titre="Auxiliaires";
			document.newPage();
			putBalance(listing, "A");
			document.add(listing);
			listing = new PdfPTable(5);
			listing.setWidthPercentage(100);
			listing.setWidths(widths);
			this.titre="G\u00E9n\u00E9rale";
			document.newPage();
			putBalance(listing, "G");
			document.add(listing);
		}
		else {
			putBalance(listing, type);
			document.add(listing);
		}


    document.close();

		s.closeConnection(con, null);


		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier  supprimer");
			se.printStackTrace();
		}


		return true;


	} // fin service


	private void putBalance(PdfPTable listing, String typeBalance) throws SQLException, Exception {

		boolean resultat = false;
		boolean bilan = false;
		boolean afficheCompte;

		String Numero;
		String Numero2;
		String Numero1;
		String index2 = "";
		String index1 = "";

		double solde2 = 0;
		double debit2 = 0;
		double credit2 = 0;

		double solde1 = 0;
		double debit1 = 0;
		double credit1 = 0;

		double solde = 0;
		double debit = 0;
		double credit = 0;

		double soldeCpte = 0;
		double debitCpte = 0;
		double creditCpte = 0;

		double creditResultat = 0;
		double debitResultat = 0;
		double creditBilan = 0;
		double debitBilan = 0;


		ResultSet rset; // comptes
		ResultSet rset2; // soldes des comptes

		Statement stt = con.createStatement();


		String reqSoldesGen = "select sum(Montant_D) as Debit, sum(Montant_C) as Credit from "+ base +".OPERATION where Numero_Compte=?";
		String reqSoldesAux = "select sum(Montant_D) as Debit, sum(Montant_C) as Credit from "+ base +".OPERATION o,"+ baseDossier +".COMPTE c where c.Collectif=? and o.Numero_Compte=c.Numero_Compte";

		if (!exocomplet) {
			String suiteReq = (Long.parseLong(debutExercice)==debutPeriode
												?" and Date_Op<="+ finPeriode
												:" and Date_Op<="+ finPeriode +" and Date_Op>="+ debutPeriode);

			reqSoldesGen += suiteReq;
			reqSoldesAux += suiteReq;
		}

		PreparedStatement psSoldesGen = con.prepareStatement(reqSoldesGen);
		PreparedStatement psSoldesAux = con.prepareStatement(reqSoldesAux);


		String reqComptes = "select Numero_Compte, Intitule, Centralisateur from "+ baseDossier +".COMPTE where Type_Compte='"+ typeBalance +"'";

		if (edition.equals("P")) {
			reqComptes += " and Numero_Compte<='"+ cpteFin +"' and Numero_Compte>='"+ cpteDebut +"'";
		}

		reqComptes += " order by Numero_Compte";
    rset = stt.executeQuery(reqComptes);

		while (rset.next()) {

			Numero = rset.getString("Numero_Compte");
			Numero2 = Numero.substring(0,2);
			Numero1 = Numero.substring(0,1);


			if (rset.getInt("Centralisateur")==1)	{
				psSoldesAux.setString(1, Numero);
				rset2 = psSoldesAux.executeQuery();
			}
			else {
				psSoldesGen.setString(1, Numero);
				rset2 = psSoldesGen.executeQuery();
			}


			while (rset2.next()) {

				debitCpte = rset2.getDouble("Debit");
				creditCpte = rset2.getDouble("Credit");
				soldeCpte = debitCpte - creditCpte;
			}
			rset2.close();


			if (!index2.equals("") && Numero2.compareTo(index2)!=0) {

				putLigneClasse(listing, index2, debit2, credit2, solde2);
				debit2 = 0;
				credit2 = 0;
				solde2 = 0;

			}

			if (!index1.equals("") && Numero1.compareTo(index1)!=0) {

				putLigneClasse1(listing, typeBalance, index1, debit1, credit1, solde1);
				debit1 = 0;
				credit1 = 0;
				solde1 = 0;

				if (!bilan && (Numero1.compareTo("5")==1 || Numero1.compareTo("6")==1 || Numero1.compareTo("7")==1)) {
					putTotalBilan(listing, debitBilan, creditBilan, debitBilan-creditBilan);
					bilan = true;
					resultat = true;
				}

			}

			afficheCompte = edCpte.equalsIgnoreCase("T")?true:!(debitCpte-creditCpte<0.01 && debitCpte-creditCpte>-0.01);

			afficheCompte = afficheCompte && !(debitCpte<0.01 && creditCpte<0.01 && debitCpte>-0.01 && creditCpte>-0.01);

			if (!edition.equalsIgnoreCase("T") && afficheCompte) {
				putLigneCompte(listing, rset.getString("Numero_Compte"), rset.getString("Intitule"), debitCpte, creditCpte, soldeCpte);
			}

			if (afficheCompte) {
				solde2 += soldeCpte;
				debit2 += debitCpte;
				credit2 += creditCpte;

				solde1 += soldeCpte;
				debit1 += debitCpte;
				credit1 += creditCpte;

				if (!bilan && !Numero1.equals("0")) {
					debitBilan += debitCpte;
					creditBilan += creditCpte;
					solde += soldeCpte;
					debit += debitCpte;
					credit += creditCpte;
				}

				if (resultat) {
					debitResultat += debitCpte;
					creditResultat += creditCpte;
					solde += soldeCpte;
					debit += debitCpte;
					credit += creditCpte;
				}
			}

			index2 = Numero2;
			index1 = Numero1;
		}

		putLigneClasse(listing, index2, debit2, credit2, solde2);
		putLigneClasse1(listing, typeBalance, index1, debit1, credit1, solde1);

		if (resultat) {
			putTotalResultat(listing, debitResultat, creditResultat, debitResultat-creditResultat);
		}

		if (typeBalance.equalsIgnoreCase("G")) {
			putTotalGeneral(listing, debit, credit, solde);
		}

		rset.close();

		psSoldesAux.close();
		psSoldesGen.close();
		stt.close();
	}


	private void putLigneCompte(PdfPTable listing, String numCompte, String libelle, double debit, double credit, double solde) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setBorder(PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase(numCompte, fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(libelle, fontLine));
		cellListing.setBorder(PdfPCell.RIGHT);
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(debit==0?"":numFormat.format(debit), fontLine));
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.LEFT + PdfPCell.RIGHT);
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(credit==0?"":numFormat.format(credit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(solde==0?"":numFormat.format(solde), fontLine));
		listing.addCell(cellListing);

	}


	private void putTotalGeneral(PdfPTable listing, double debit, double credit, double solde) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setBackgroundColor(Color.LIGHT_GRAY);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase("TOTAL GENERAL", fontLine));
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPhrase(new Phrase(debit==0?"":numFormat.format(debit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(credit==0?"":numFormat.format(credit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(solde==0?"":numFormat.format(solde), fontLine));
		listing.addCell(cellListing);

	}

	private void putLigneClasse(PdfPTable listing, String index, double debit, double credit, double solde) {

		if (!(debit<0.01 && credit<0.01 && debit>-0.01 && credit>-0.01)) {

			PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

			cellListing.setFixedHeight(20);
			cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
			cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cellListing.setBorder(PdfPCell.LEFT);
			cellListing.setPhrase(new Phrase("", fontLine));
			listing.addCell(cellListing);

			cellListing.setPhrase(new Phrase("Total classe " + index, fontLine));
			cellListing.setBorder(PdfPCell.RIGHT);
			listing.addCell(cellListing);

			cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
			cellListing.setPhrase(new Phrase(debit==0?"":numFormat.format(debit), fontLine));
			listing.addCell(cellListing);
			cellListing.setPhrase(new Phrase(credit==0?"":numFormat.format(credit), fontLine));
			listing.addCell(cellListing);
			cellListing.setPhrase(new Phrase(solde==0?"":numFormat.format(solde), fontLine));
			listing.addCell(cellListing);

			cellListing.setFixedHeight(10);
			cellListing.setBorder(PdfPCell.LEFT);
			cellListing.setPhrase(new Phrase("", fontLine));
			listing.addCell(cellListing);

			cellListing.setBorder(PdfPCell.RIGHT);
			listing.addCell(cellListing);

			cellListing.setBorder(PdfPCell.LEFT + PdfPCell.RIGHT);
			listing.addCell(cellListing);
			listing.addCell(cellListing);
			listing.addCell(cellListing);
		}
	}

	private void putLigneClasse1(PdfPTable listing, String typeBalance, String index, double debit, double credit, double solde) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setBackgroundColor(new Color(210,210,210));
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);

		if (typeBalance.equalsIgnoreCase("C")) {
			cellListing.setPhrase(new Phrase("TOTAL CLIENTS", fontLine));
		}
		else if (typeBalance.equalsIgnoreCase("F")) {
			cellListing.setPhrase(new Phrase("TOTAL FOURNISSEURS", fontLine));
		}
		else if (typeBalance.equalsIgnoreCase("A")) {
			cellListing.setPhrase(new Phrase("TOTAL AUXILIAIRES", fontLine));
		}
		else {
			cellListing.setPhrase(new Phrase("Total classe " + index, fontLine));
		}

		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPhrase(new Phrase(debit==0?"":numFormat.format(debit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(credit==0?"":numFormat.format(credit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(solde==0?"":numFormat.format(solde), fontLine));
		listing.addCell(cellListing);

	}

	private void putTotalResultat(PdfPTable listing, double debit, double credit, double solde) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setBackgroundColor(new Color(200,200,200));
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase("Total Comptes de R\u00E9sultat", fontLine));
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPhrase(new Phrase(debit==0?"":numFormat.format(debit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(credit==0?"":numFormat.format(credit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(solde==0?"":numFormat.format(solde), fontLine));
		listing.addCell(cellListing);

	}

	private void putTotalBilan(PdfPTable listing, double debit, double credit, double solde) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setBackgroundColor(new Color(200,200,200));
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase("Total Comptes de Bilan", fontLine));
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPhrase(new Phrase(debit==0?"":numFormat.format(debit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(credit==0?"":numFormat.format(credit), fontLine));
		listing.addCell(cellListing);
		cellListing.setPhrase(new Phrase(solde==0?"":numFormat.format(solde), fontLine));
		listing.addCell(cellListing);

	}

} // fin GenPdfBalance
