/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Edition des journaux.
 */

package org.opensi.compta.actions.etats;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfJournaux extends Action {


	class MyPageEvent implements PdfPageEvent {

	private String dateCourante;

	private String dossierId;
	private String raisonSociale;
	private String adresse;
	private String compAdresse;
	private String codePostal;
	private String ville;

	private String finExerciceStr;
	private String debutExerciceStr;


		public MyPageEvent(String dossierId, String debutExercice, String finExercice) throws SQLException {

			this.dossierId = dossierId;

			Statement stt = con.createStatement();
			ResultSet rset = stt.executeQuery("select * from "+ baseDossier +".SOCIETE");

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse = rset.getString("Adresse_1");
			this.compAdresse = rset.getString("Adresse_2");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");

			rset.close();

			stt.close();

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			finExerciceStr = formatDate.format(new Date(Long.parseLong(finExercice)));
			debutExerciceStr = formatDate.format(new Date(Long.parseLong(debutExercice)));
		}


    public void onStartPage(PdfWriter writer, Document document) {

    	try {

				// Entete Gnrale


				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);

				cellEntete.setPhrase(new Phrase("Dossier : " + this.dossierId, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Exercice du " + this.debutExerciceStr + " au " + this.finExerciceStr, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(compAdresse, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				cellEntete.setColspan(1);

				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(codePostal + " " + ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Journal '"+ codeJournal +"' " + libelleJournal, new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(""));
				cellEntete.setFixedHeight(10);
				entete.addCell(cellEntete);


				cellEntete.setPhrase(new Phrase("P\u00E9riode : " + periode, fontGen));
				cellEntete.setMinimumHeight(0);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);

				// fin Entete Gnrale


				// Titres de colonnes

				PdfPTable titresColonnes = new PdfPTable(7);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widths);
				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(15);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setColspan(7);
				titresColonnes.addCell(cellTitre);
				cellTitre.setColspan(1);

				cellTitre.setFixedHeight(20);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("N\u00B0", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("DATE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
				cellTitre.setPhrase(new Phrase("COMPTE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
				cellTitre.setPhrase(new Phrase("INTITULE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
				cellTitre.setPhrase(new Phrase("LIBELLE", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setBorder(PdfPCell.BOX);
				cellTitre.setPhrase(new Phrase("DEBIT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("CREDIT", fontLine));
				titresColonnes.addCell(cellTitre);

				document.add(titresColonnes);

				// fin Titres de colonnes

			}
			catch(DocumentException de) {	de.printStackTrace(); }

		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
    public void onCloseDocument(PdfWriter writer, Document document) {}
    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
    public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
    public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
    public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);		// font pour lignes d'entete
private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);		// font pour lignes de listing
private DecimalFormat numFormat = new DecimalFormat("0.00");

private int widths[] = {5,9,10,21,25,15,15}; // largeurs des colonnes du listing

// parametres dynamiques pour l'entete
private String periode;
private String codeJournal;
private String libelleJournal;
private String baseDossier;

private Connection con;


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	  try {

		con = s.getConnection(null);


		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("-");
		numFormat.setNegativePrefix("");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);


		String dossierId = s.getCookie().get("Dossier_Id");
		String base = s.getCookie().get("BaseExo");
		baseDossier = s.getCookie().get("BaseDossier");

		String debutExercice = r.getParameter("Debut_Exercice");
		String finExercice = r.getParameter("Fin_Exercice");
		String dateDebut = r.getParameter("Date_Debut");
		String dateFin = r.getParameter("Date_Fin");
		String journal = r.getParameter("Code_Journal");


		ResultSet rset;  // operations
		ResultSet rset2; // journaux
		ResultSet rset3; // ecritures

		PdfPTable listing;
		PdfPTable ecriture;
		PdfPCell cellEcriture;

		double creditPeriode = 0;
		double debitPeriode = 0;
		double creditJournal;
		double debitJournal;
		double creditGeneraux = 0;
		double debitGeneraux = 0;
		double creditClients = 0;
		double debitClients = 0;
		double creditFournisseurs = 0;
		double debitFournisseurs = 0;
		double debitOp;
		double creditOp;

		boolean newJournal;
		boolean journalVide;

		String intitule;
		String typeCompte;

		Calendar calendar = Calendar.getInstance();
		calendar.clear();

		long debutPeriode;
		long finPeriode;

		int moisEcriture;
		int i;
		int fyy;
		int fmm;
		int dyy;
		int dmm;

		SimpleDateFormat dfPeriode = new SimpleDateFormat("MM.yy");


		if (dateFin.length() == 0 && dateDebut.length() == 0) {
			debutPeriode = Long.parseLong(debutExercice);
			finPeriode = Long.parseLong(finExercice) + 216000000;  // on ajoute un jour
		}
		else {
			dyy = 2000 + Integer.parseInt(dateDebut.substring(2,4));
			dmm = Integer.parseInt(dateDebut.substring(0,2))-1;

			if(dateFin.length() == 0) {
				calendar.set(dyy,dmm,1,0,0,0);
				debutPeriode = calendar.getTimeInMillis();
				calendar.set(dyy,dmm+1,1,0,0,0);
				finPeriode = calendar.getTimeInMillis();
			}
			else {
				fyy = 2000 + Integer.parseInt(dateFin.substring(2,4));
				fmm = Integer.parseInt(dateFin.substring(0,2));
				calendar.set(dyy,dmm,1,0,0,0);
				debutPeriode = calendar.getTimeInMillis();
				calendar.set(fyy,fmm,1,0,0,0);
				finPeriode = calendar.getTimeInMillis();
			}
		}


		Document document = new Document(PageSize.A4, 25, 25, 25, 25);

		String chemin = s.getAppConfiguration().get("opensi.absdir") + "/pdf/";

		String fichierPdf = r.getParameter("FichierPDF");

		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

		MyPageEvent event = new MyPageEvent(dossierId,debutExercice,finExercice);

		writer.setPageEvent(event);


		String reqLesJournaux = "select Code_Journal, Intitule from "+ baseDossier +".JOURNAL";


		if (!journal.equalsIgnoreCase("tous")) {
			reqLesJournaux += " where Code_Journal='"+ journal +"'";
		}

		Statement stt2 = con.createStatement();


		String reqLesEcritures = "select e.Date_Ecriture, e.Ecriture_Id, min(o.Date_Op) as mindate ";
    reqLesEcritures += " from " + base + ".ECRITURE e, " + base + ".OPERATION o ";
    reqLesEcritures += " where ";
    reqLesEcritures += " o.Ecriture_Id = e.Ecriture_Id ";
    reqLesEcritures += " and Code_Journal=? ";
    reqLesEcritures += " and Date_Ecriture<? and Date_Ecriture>=? ";
    reqLesEcritures += " group by e.Ecriture_Id, e.Date_Ecriture ";
    reqLesEcritures += " order by mindate, e.Date_Ecriture, e.Ecriture_Id ";


    PreparedStatement psEcr = con.prepareStatement(reqLesEcritures);

		String reqLesOperations = "select c.Type_Compte, ";
    reqLesOperations += " c.Intitule, ";
    reqLesOperations += " o.Lettre, ";
    reqLesOperations += " o.Numero_Compte, ";
    reqLesOperations += " o.Montant_D, ";
    reqLesOperations += " o.Montant_C, ";
    reqLesOperations += " o.Date_Op, ";
    reqLesOperations += " o.Num_Ligne, ";
    reqLesOperations += " o.Libelle ";
    reqLesOperations += " from "+ base +".OPERATION o, "+ baseDossier +".COMPTE c ";
    reqLesOperations += " where o.Numero_Compte=c.Numero_Compte ";
    reqLesOperations += " and o.Ecriture_Id=? ";
    reqLesOperations += " order by o.Date_Op, o.Num_Ligne";

		PreparedStatement psOp = con.prepareStatement(reqLesOperations);


		rset2 = stt2.executeQuery(reqLesJournaux);

		while (rset2.next()) {

			this.codeJournal = rset2.getString("Code_Journal");
			this.libelleJournal = rset2.getString("Intitule");

			creditJournal = 0;
			debitJournal = 0;

			creditFournisseurs = 0;
			debitFournisseurs = 0;
			creditClients = 0;
			debitClients = 0;
			creditGeneraux = 0;
			debitGeneraux = 0;

			creditPeriode = 0;
			debitPeriode = 0;

			newJournal = true;
			journalVide = true;


			long numEcriture = 0;
			long dateEcriture = 0;
			moisEcriture = 0;

			i = 1;

			psEcr.setString(1, codeJournal);
			psEcr.setLong(2, finPeriode);
			psEcr.setLong(3, debutPeriode);
			rset3 = psEcr.executeQuery();

			while (rset3.next()) {

				numEcriture = rset3.getLong("Ecriture_Id");
				dateEcriture = rset3.getLong("Date_Ecriture");

				this.periode = dfPeriode.format(new Date(dateEcriture));

				if (!document.isOpen()) {
					document.open();
					newJournal = false;
				}
				else if (newJournal) {
					document.newPage();
					newJournal = false;
				}

				journalVide = false;

				calendar.setTimeInMillis(dateEcriture);


				// on change de periode
				if (moisEcriture != (calendar.get(Calendar.MONTH)+1) && moisEcriture != 0) {
			
					listing = new PdfPTable(7);
					listing.setWidthPercentage(100);
					listing.setWidths(widths);

					putTotalCpte(listing, "Fournisseurs", debitFournisseurs, creditFournisseurs);
					putTotalCpte(listing, "Clients", debitClients, creditClients);
					putTotalCpte(listing, "G\u00E9n\u00E9raux", debitGeneraux, creditGeneraux);

					putTotalPeriode(listing, debitPeriode, creditPeriode);

					creditFournisseurs = 0;
					debitFournisseurs = 0;
					creditClients = 0;
					debitClients = 0;
					creditGeneraux = 0;
					debitGeneraux = 0;

					creditPeriode = 0;
					debitPeriode = 0;

					i = 1;

					document.add(listing);

					document.resetPageCount();

					document.newPage();
				}

				moisEcriture = calendar.get(Calendar.MONTH)+1;

				listing = new PdfPTable(7);
				listing.setWidthPercentage(100);
				listing.setWidths(widths);


				psOp.setLong(1, numEcriture);
				rset = psOp.executeQuery();


				while (rset.next()) {
				    
					intitule = rset.getString("Intitule");
					intitule = intitule.substring(0,intitule.length()<20?intitule.length():20);

					creditOp = rset.getDouble("Montant_C");
					debitOp = rset.getDouble("Montant_D");

					typeCompte = rset.getString("Type_Compte");

					if (typeCompte.equalsIgnoreCase("G")) {
						debitGeneraux += debitOp;
						creditGeneraux += creditOp;
					}
					else if (typeCompte.equalsIgnoreCase("F")) {
						debitFournisseurs += debitOp;
						creditFournisseurs += creditOp;
					}
					else if (typeCompte.equalsIgnoreCase("C")) {
						debitClients += debitOp;
						creditClients += creditOp;
					}

					creditJournal += creditOp;
					debitJournal += debitOp;

					creditPeriode += creditOp;
					debitPeriode += debitOp;

					putLigneJournal(listing, rset.getString("Lettre"), i++, rset.getLong("Date_Op"), rset.getString("Numero_Compte"), intitule, rset.getString("Libelle"), debitOp, creditOp);
				}
				rset.close();


				putFinEcriture(listing);


				if (listing.size() < 35) {
					ecriture = new PdfPTable(1);
					ecriture.setWidthPercentage(100);
					cellEcriture = new PdfPCell(listing);
					ecriture.addCell(cellEcriture);
					document.add(ecriture);
				}
				else {
					document.add(listing);
				}
			}
			
			rset3.close();

			if (!journalVide) {

				listing = new PdfPTable(7);
				listing.setWidthPercentage(100);
				listing.setWidths(widths);

				putTotalCpte(listing, "Fournisseurs", debitFournisseurs, creditFournisseurs);
				putTotalCpte(listing, "Clients", debitClients, creditClients);
				putTotalCpte(listing, "G\u00E9n\u00E9raux", debitGeneraux, creditGeneraux);

				putTotalPeriode(listing, debitPeriode, creditPeriode);

				putTotalJournal(listing, this.codeJournal, debitJournal, creditJournal);

				document.add(listing);

				document.resetPageCount();
			}
		}

		stt2.close();
		psEcr.close();
		psOp.close();

		s.closeConnection(con, null);


		if (document.isOpen()) {
    	document.close();
		}

		try {
			File filePdf = new File(chemin, fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier  supprimer");
			se.printStackTrace();
		}


		return true;

	  } catch(Exception e) {
			s.trace("erreur");
			e.printStackTrace();
			return false;
		}

	} // fin service



	/** Ajoute une ligne d'operation au listing */

	private void putLigneJournal(PdfPTable listing, String Lettre, int ligne, long dateOp, String numCompte, String intitule, String libelle, double debit, double credit) {

		SimpleDateFormat formatDatePoint = new SimpleDateFormat("dd.MM.yy");

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);

		cellListing.setPaddingRight(5);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(""+ligne, fontLine));
		listing.addCell(cellListing);

		cellListing.setPaddingRight(0);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cellListing.setPhrase(new Phrase(formatDatePoint.format(new Date(dateOp)), fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase(numCompte, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.RIGHT);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase(intitule, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.RIGHT);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPhrase(new Phrase(libelle, fontLine));
		listing.addCell(cellListing);

		cellListing.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cellListing.setHorizontalAlignment(debit==0?PdfPCell.ALIGN_LEFT:PdfPCell.ALIGN_RIGHT);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(debit==0?Lettre:numFormat.format(debit), fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(credit==0?PdfPCell.ALIGN_LEFT:PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(credit==0?Lettre:numFormat.format(credit), fontLine));
		listing.addCell(cellListing);

	}


	/** fin ecriture */

	private void putFinEcriture(PdfPTable listing) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(5);
		cellListing.setPhrase(new Phrase("", fontGen));
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.TOP);
		listing.addCell(cellListing);
		listing.addCell(cellListing);
		cellListing.setColspan(2);
		listing.addCell(cellListing);
		cellListing.setColspan(1);
		listing.addCell(cellListing);
		listing.addCell(cellListing);
	}

	/** Ajoute une ligne de total pour un journal au listing */

	private void putTotalJournal(PdfPTable listing, String codeJ, double debit, double credit) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(Color.LIGHT_GRAY);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setColspan(4);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);

		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase("Total du journal " + codeJ, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(debit), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(numFormat.format(credit), fontLine));
		listing.addCell(cellListing);

	}


	/** Ajoute une ligne de total pour un compte centralis (gnraux, clients, fournisseurs) d'un journal au listing */

	private void putTotalCpte(PdfPTable listing, String entete, double debit, double credit) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setColspan(4);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);

		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase(entete, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(debit), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(numFormat.format(credit), fontLine));
		listing.addCell(cellListing);
	}


	/** Ajoute une ligne de total de la periode d'edition du journal au listing */

	private void putTotalPeriode(PdfPTable listing, double debit, double credit) {

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());

		cellListing.setFixedHeight(20);
		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setBackgroundColor(new Color(210,210,210));
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setColspan(4);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);

		cellListing.setPhrase(new Phrase("", fontLine));
		listing.addCell(cellListing);

		cellListing.setColspan(1);
		cellListing.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		cellListing.setPhrase(new Phrase("Total p\u00E9riode", fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setBorder(PdfPCell.BOX);
		cellListing.setPaddingRight(5);
		cellListing.setPhrase(new Phrase(numFormat.format(debit), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(numFormat.format(credit), fontLine));
		listing.addCell(cellListing);
	}

} // fin GenPdfJournaux




