/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
	*	  Gnration du graphique d'volution du chiffre d'affaire
 	*/

package org.opensi.compta.actions.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.axis.SymbolicTickUnit;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;


public class ChiffreAffaire extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session session, ServletRequest r, Object info) throws Exception {


		// Rcupration des paramtres

		String listeN[] = r.getParameter("ListeN").split(",");
		String listeN1[] = r.getParameter("ListeN1").split(",");
		String periodes[] = r.getParameter("Periodes").split(",");

		boolean petit = r.getParameter("TailleGraph")!=null;
		String nomFichier = r.getParameter("fichierPng");

		// Cration de la srie pour l'anne N
		
		XYSeries dataSeries = new XYSeries("Exercice N");
		
		for (int i=0;i<listeN.length;i++) {

			dataSeries.add(i,Integer.parseInt(listeN[i]));
		}

		// Cration de la srie pour l'anne N-1
		
		XYSeries dataSeriesN1 = new XYSeries("Exercice N-1");
		
		for (int i=0;i<listeN1.length;i++) {

			dataSeriesN1.add(i,Integer.parseInt(listeN1[i]));
		}

		// Cration de la collection des sries
		
		XYSeriesCollection xyDataset = new XYSeriesCollection(dataSeries);
		xyDataset.addSeries(dataSeriesN1);


		// Cration des axes

		SymbolicAxis timeAxis = new SymbolicAxis("Priode", periodes);
		NumberAxis valueAxis = new NumberAxis("CA en euros");
		timeAxis.setAutoRangeIncludesZero(false);
		valueAxis.setAutoRangeIncludesZero(false);


		// Cration des symboles pour l'axe horizontal
		
		if (petit) {
		
			//graduation 1 sur 2
			for (int g=0; g<periodes.length; g++) {
				if (!(g%2==0)) { //impair
					periodes[g] = "";
				}
			}
		}

		SymbolicTickUnit tickUnit = new SymbolicTickUnit(1, periodes);
	
		timeAxis.setTickUnit(tickUnit);
		timeAxis.setRange(0, periodes.length-1);
	
		XYPlot plot = new XYPlot(xyDataset, timeAxis, valueAxis, new StandardXYItemRenderer());


		// Caractristiques du graphique

		Paint couleur_fond;
		int hauteur;
		int largeur;
		String titre;

		if (petit) {
			//couleur_fond=new Color(255,255,255,0);//transparent
			hauteur = 300;
			largeur = 420;
			titre = "";
		}
		else {
			//couleur_fond=	JFreeChart.DEFAULT_BACKGROUND_PAINT;
			hauteur = 315;
			largeur = 500;
			titre = "Evolution du Chiffre d'Affaires";
		}


		JFreeChart chart = new JFreeChart(titre, JFreeChart.DEFAULT_TITLE_FONT, plot, true);

		couleur_fond = new Color(255,255,255,0);
		chart.setBackgroundPaint(couleur_fond);
		LegendTitle legende = chart.getLegend();
		chart.clearSubtitles() ;
		Font old_police = legende.getItemFont();
		legende.setItemFont(new Font(old_police.getFontName(), old_police.getStyle(), 10));
		chart.addSubtitle(legende);

		//pour changer la disposition de la lgende
		/*if (petit)
			{
				LegendTitle legende=chart.getLegend();
				chart.clearSubtitles() ;
				legende.setPosition(RectangleEdge.TOP);
				chart.addSubtitle(legende);
			}*/



		try {
		
			String chemin = session.getAppConfiguration().get("opensi.absdir") + "/graph/";
			File file = new File(chemin + nomFichier);

			ChartUtilities.saveChartAsPNG(file, chart,largeur,hauteur, null, true, 9);

			file.deleteOnExit();		
		}
		catch(SecurityException se) {
    	session.trace("Impossible d'enregistrer le fichier  supprimer");
    	se.printStackTrace();
    }		
		catch (Exception e) {
			e.printStackTrace();
		}
		
		
		return true;		
	}	

} // fin ChiffreAffaire











