/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.compta.actions.suiviActivite;



/**
* Contient les conditions sur les comptes, utilises  travers tout le tableau de bord
**/
public class conditionsComptes
{
	public conditionsComptes()
	{}
	
	/**
	* Le prfixe c'est le mnmonique de la table, cd dans o.Numero_Compte, c'est "o."
	**/
	
	
	public String chargesExternes(String prefixe)
	{
		String result="";
		result+=" ( "+prefixe+"Numero_Compte LIKE '61%' OR "+prefixe+"Numero_Compte LIKE '60%' ";
		result+=" OR "+prefixe+"Numero_Compte LIKE '62%' ";
		result+=" ) AND NOT ("+prefixe+"Numero_Compte LIKE '600%' OR "+prefixe+"Numero_Compte LIKE '601%' OR "+prefixe+"Numero_Compte LIKE '602%' ";
		result+=" OR "+prefixe+"Numero_Compte LIKE '603%' OR "+prefixe+"Numero_Compte LIKE '607%' OR "+prefixe+"Numero_Compte LIKE '6080%' ";
		result+=" OR "+prefixe+"Numero_Compte LIKE '6081%' OR "+prefixe+"Numero_Compte LIKE '6082%' OR "+prefixe+"Numero_Compte LIKE '6087%' ";
		result+=" OR "+prefixe+"Numero_Compte LIKE '6090%' OR "+prefixe+"Numero_Compte LIKE '6091%' OR "+prefixe+"Numero_Compte LIKE '6092%' ";
		result+=" OR "+prefixe+"Numero_Compte LIKE '6097%' ) ";
		return result;
	}
	
	public String chargesDePersonnel(String prefixe)
	{
		String result="";
		result+=prefixe+"Numero_Compte LIKE '64%'";
		return result;
	}
	
	public String chargesFinancieres(String prefixe)
	{
		String result="";
		result+=" "+prefixe+"Numero_Compte LIKE '66%'";
		return result;
	}
	
	public String amortissements(String prefixe)
	{
		String result="";
		result+=prefixe+"Numero_Compte LIKE '68%' ";
		result+=" AND NOT ("+prefixe+"Numero_Compte LIKE '6815%' OR "+prefixe+"Numero_Compte LIKE '6816%' OR "+prefixe+"Numero_Compte LIKE '6817%' ";
		result+=" OR "+prefixe+"Numero_Compte LIKE '686%' OR "+prefixe+"Numero_Compte LIKE '687%' )"; 
		return result;
	}
	
	public String impotsEtTaxes(String prefixe)
	{
		String result="";
		result+=prefixe+"Numero_Compte LIKE '63%'";
		return result;
	}

	public String venteDeMarch(String prefixe)
	{
		String result="";
		result+=prefixe+"Numero_Compte LIKE '707%' OR "+prefixe+"Numero_Compte LIKE '7097%'";
		return result;
	}
	
	public String coutAchatMarchVendues(String prefixe)
	{
		String result="";
		result+=prefixe+"Numero_Compte LIKE '607%' OR "+prefixe+"Numero_Compte LIKE '6087%' OR "+prefixe+"Numero_Compte LIKE '6097%' OR "+prefixe+"Numero_Compte LIKE '6037%'";
		return result;
	}
	
	public String productionVendue(String prefixe)
	{
		String result="";
		result+=" ( "+prefixe+"Numero_Compte LIKE '70%' OR "+prefixe+"Numero_Compte LIKE '73%'";
		result+=" ) AND NOT ("+prefixe+"Numero_Compte LIKE '707%' OR "+prefixe+"Numero_Compte LIKE '7097%' )"; 
		return result;
	}
	
	public String prodStockeeOuDestock(String prefixe)
	{
		String result="";
		result+=prefixe+"Numero_Compte LIKE '71%'";
		return result;
	}
	
	public String productionImmo(String prefixe)
	{
		String result="";
		result+=prefixe+"Numero_Compte LIKE '72%'";
		return result;
	}
	
	
	public String matPremiereApproConso(String prefixe)
	{
		String result="";
		result+=" ( "+prefixe+"Numero_Compte LIKE '600%' OR "+prefixe+"Numero_Compte LIKE '601%'";
		result+=" OR "+prefixe+"Numero_Compte LIKE '602%' OR "+prefixe+"Numero_Compte LIKE '603%'";
		result+=" OR "+prefixe+"Numero_Compte LIKE '6080%' OR "+prefixe+"Numero_Compte LIKE '6081%'";
		result+=" OR "+prefixe+"Numero_Compte LIKE '6082%'";
		result+=" ) AND NOT ( "+prefixe+"Numero_Compte LIKE '6037%' OR "+prefixe+"Numero_Compte LIKE '6090%'";
		result+=" OR "+prefixe+"Numero_Compte LIKE '6091%' OR "+prefixe+"Numero_Compte LIKE '6092%' )";
		return result;
	}
	
	public String sousTraitDirecte(String prefixe)
	{
		String result="";
		result+=" ( "+prefixe+"Numero_Compte LIKE '604%' OR "+prefixe+"Numero_Compte LIKE '605%'";
		result+=" OR "+prefixe+"Numero_Compte LIKE '6084%' OR "+prefixe+"Numero_Compte LIKE '6085%'";
		result+=" ) AND NOT ( "+prefixe+"Numero_Compte LIKE '6094%' OR "+prefixe+"Numero_Compte LIKE '6095%' ) ";

		return result;
	}
	
	
	public String chiffreDAffaires(String prefixe)
	{
		String result="";
		result+=venteDeMarch(prefixe)+" OR "+ coutAchatMarchVendues(prefixe)+" OR "+	productionVendue(prefixe);
		result+=" OR "+prodStockeeOuDestock(prefixe)+" OR "+productionImmo(prefixe)+" OR "+matPremiereApproConso(prefixe)+" OR "+sousTraitDirecte(prefixe) ;
		return result;
	}
	

}
