/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/
  
/**
 *  Sauvegarde dans la BD des modifs
 */

package org.opensi.compta.actions.suiviActivite;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;



public class sauvegarde extends Action {

	
	/* liste */
	String listeParam;
	String[] touteLaListe;
	String[] listeCompte;
	String[] listeValeur;
	String[] listeMois;
	String[] listeAnnee;
	
	int nbLignes;
	
	
  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		
		Connection con = s.getConnection(null);

		String baseDossier = s.getCookie().get("BaseDossier");

		listeParam=r.getParameter("Liste");
		String choix=r.getParameter("Choix");
		String moisDebut=r.getParameter("MDeb");
		String anneeDebut=r.getParameter("ADeb");
		String moisFin=r.getParameter("MFin");
		String anneeFin=r.getParameter("AFin");

		String budget_id = r.getParameter("Id_Budget");


		if (!listeParam.equals("")) {
			separerLaListe();
		}


		//suppression de l'existant
		String requeteDel="delete from "+ baseDossier +".SAUVE_SAISIES "+ whereDeleteDapresChoix(choix.charAt(0));
		requeteDel+=" and Mois>="+moisDebut+" and Mois<="+moisFin+" and Annee>="+anneeDebut+" and Annee<="+anneeFin ;
		requeteDel+=" and Id_Budget="+budget_id;

		Statement stt1 = con.createStatement();
		stt1.execute(requeteDel);

		if (!listeParam.equals("")) {
			//Les insertions (numcompte, mois annee, montant)
			String requetInsert ="insert into "+ baseDossier +".SAUVE_SAISIES values (?,?,?,?,?)";
			PreparedStatement stt2 = con.prepareStatement(requetInsert);

			for (int g=0; g<nbLignes;g++)
			{
				stt2.setInt(1,Integer.parseInt(budget_id));
				stt2.setString(2,listeCompte[g]);
				stt2.setInt(3,Integer.parseInt(listeMois[g]));
				stt2.setInt(4,Integer.parseInt(listeAnnee[g]));
				stt2.setLong(5,Long.parseLong(listeValeur[g]));
				stt2.executeUpdate();
			}
		}	
		
		s.closeConnection(con, null);
		
		return true;	
	}
	
		
	public void separerLaListe() {
				
		//on enlve la premire ','
		listeParam=listeParam.substring(1);

		touteLaListe=listeParam.split(",",0);

		nbLignes=touteLaListe.length/4;

		listeCompte=new String[nbLignes];
		listeValeur=new String[nbLignes];
		listeMois=new String[nbLignes];
		listeAnnee=new String[nbLignes];

		for (int i=0; i<nbLignes; i++) {

			listeCompte[i]=touteLaListe[i*4];
			listeMois[i]=touteLaListe[i*4+1];
			listeAnnee[i]=touteLaListe[i*4+2];
			listeValeur[i]=touteLaListe[i*4+3];
		}	
	}
		
	
	public String whereDeleteDapresChoix(char lettreChoix) {
		
		String resultat = "";
		conditionsComptes condition = new conditionsComptes();
		
		switch (lettreChoix) {
			case 'P':	resultat += " where "+ condition.chargesDePersonnel("");		break;		
			case 'E':	resultat += " where "+ condition.chargesExternes("");				break;		
			case 'F':	resultat += " where "+ condition.chargesFinancieres("");		break;
			case 'A':	resultat += " where "+ condition.amortissements("");				break;
			case 'I':	resultat += " where "+ condition.impotsEtTaxes("");					break;			
			case 'C':	resultat += " where "+ condition.chiffreDAffaires("");			break;		
		}
		
		return resultat;
	}

	
}

		
			
			










