/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/
  
/**
 *  Cre le tableau en Ooo
 */

package org.opensi.compta.actions.tableauDeBord;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.openoffice.CreateurOpenOffice;
import org.opensi.util.openoffice.OooCellule;
import org.opensi.util.openoffice.OooLigne;
import org.opensi.util.openoffice.OooStyleCellule;
import org.opensi.util.openoffice.OooStyleLigne;


public class exportCAVersOoo extends Action {

	
	Connection con;
	String chemin;
	String nomFichier;
	String base;
	String choix;
	int nbMois, moisDebut, anneeDebut, dureeExo;
	
	long totalVM, totalCMV, totalPV, totalPS, totalPIM, totalMA;
	
	
	CreateurOpenOffice renoir;
	OooStyleCellule titreStyle, petitePolice, chiffreTitreStyle, rienStyle, caseStyle;
	OooStyleLigne ligneStyle;
	
  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		
		chemin = s.getAppConfiguration().get("opensi.absdir") ;
		con = s.getConnection(null);
		
		nomFichier=r.getParameter("fichierSxc");
		 base=r.getParameter("baseBD");
		 nbMois=Integer.parseInt(r.getParameter("nbMois"));
		 moisDebut=Integer.parseInt(r.getParameter("moisDebut"));
		 anneeDebut=Integer.parseInt(r.getParameter("anneeDebut"));
		 dureeExo=Integer.parseInt(r.getParameter("dureeExo"));
		 choix=r.getParameter("choix");
	 
		 lisTotaux();
		 initOoo();
		 ecrireEntetes();
		 creerLignes();
		 
		 File truc=renoir.genererDocument(nomFichier);
		truc.deleteOnExit();
		
		return true;	
	}
	
	
	
	
	
	
	public void initOoo()
	{
		renoir=new CreateurOpenOffice(chemin+"/openoffice");
		
		titreStyle=renoir.creerNewStyleCellule();
		titreStyle.setGras(true); 
		titreStyle.setCouleurFond("#FCD9AF");
		titreStyle.setBordure(true);
		titreStyle.setAlignement(OooStyleCellule.H_CENTRE,OooStyleCellule.V_MILIEU);
		titreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		chiffreTitreStyle=renoir.creerNewStyleCellule();
		chiffreTitreStyle.setGras(true); 
		chiffreTitreStyle.setCouleurFond("#FCD9AF");
		chiffreTitreStyle.setBordure(true);
		chiffreTitreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		caseStyle=renoir.creerNewStyleCellule();
		caseStyle.setBordure(true);
		caseStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		petitePolice=renoir.creerNewStyleCellule();
		petitePolice.setTaillePolice(10);
		
		rienStyle=renoir.getStyleCelluleParDefaut();
		ligneStyle=renoir.getStyleLigneParDefaut();
	}
	
	
	
	
	
	public void ecrireEntetes()
	{
		OooCellule celVide=new OooCellule("",rienStyle);
		OooLigne ligne =new OooLigne(ligneStyle);
		
		OooCellule celMois;
		
		//Ligne des mois
		ligne.ajouterCellule(celVide);
		ligne.ajouterCellule(celVide);
		int vraiMois;
		String mois;
		
		for (int u=1; u<=nbMois;u++)
		{
			ligne.ajouterCellule(celVide);
			vraiMois=u+moisDebut-1;	
			mois=leMois(vraiMois);
			
			celMois=new OooCellule(mois,titreStyle);
			celMois.setFusion(1,3);
			ligne.ajouterCellule(celMois);
		}
		
		renoir.ajouterLigne(ligne);
		
		
		//Ligne des prev actu realis
		ligne=new OooLigne(ligneStyle);
		
		OooCellule exoClosCel=new OooCellule("Exercice clos le 14/07/2005", titreStyle);
		exoClosCel.setFusion(1,2);
		
		ligne.ajouterCellule(exoClosCel);
		
		//les mois
		for (int k=1; k<=nbMois; k++)
		{
			ligne.ajouterCellule(celVide);
			ligne.ajouterCellule(new OooCellule("Prev",titreStyle));
			ligne.ajouterCellule(new OooCellule("Actu",titreStyle ));
			ligne.ajouterCellule(new OooCellule("Realise",titreStyle ));
		}
		
		renoir.ajouterLigne(ligne);
	
	}
	
	
	
	public void creerLignes()
	{
		OooCellule cel;
		OooCellule celVide=new OooCellule("",rienStyle);
		OooLigne ligne;
		long parMois;

		// CA
			cel=new OooCellule("Ventes de marchandises + production", titreStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalPV+totalVM, chiffreTitreStyle);
			ligne.ajouterCellule(cel);
			
			parMois=(totalPV/dureeExo)+(totalVM/dureeExo);
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule("", chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule(parMois, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
			
			// VM
			cel=new OooCellule("Ventes de marchandises", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalVM, caseStyle);
			ligne.ajouterCellule(cel);
			
			parMois=totalVM/dureeExo;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule("", caseStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
		
		// CMV
			cel=new OooCellule("Cout d'achat des marchandises vendues", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalCMV, caseStyle);
			ligne.ajouterCellule(cel);
			
			parMois=totalCMV/dureeExo;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule("", caseStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
			
			// MC
			cel=new OooCellule("Marge commerciale", titreStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			long totalMC=totalCMV-totalVM;
			cel=new OooCellule(totalMC, chiffreTitreStyle);
			ligne.ajouterCellule(cel);
			
			parMois=(totalCMV/dureeExo)-(totalVM/dureeExo);
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule("", chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule(parMois, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
			
			// PV
			cel=new OooCellule("Production vendue", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalPV, caseStyle);
			ligne.ajouterCellule(cel);
			
			parMois=totalPV/dureeExo;
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule("", caseStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
			
			// PS
			cel=new OooCellule("Production stocke ou dstockage", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalPS, caseStyle);
			ligne.ajouterCellule(cel);
			
			parMois=(totalPS/dureeExo);
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule("", caseStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
			
			// PIM
			cel=new OooCellule("Production immobilise", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalPIM, caseStyle);
			ligne.ajouterCellule(cel);
			
			parMois=(totalPIM/dureeExo);
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule("", caseStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
			
			// PE
			cel=new OooCellule("Production de l'exercice", titreStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			long totalPE=totalPV+totalPS+totalPIM;
			cel=new OooCellule(totalPE, chiffreTitreStyle);
			ligne.ajouterCellule(cel);
			
			parMois=(totalPIM/dureeExo)+(totalPV/dureeExo)+(totalPS/dureeExo);
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule("", chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule(parMois, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
			
			
			
			// MA
			cel=new OooCellule("Matires premires, appro consomms + sous traitance directe", caseStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalMA, caseStyle);
			ligne.ajouterCellule(cel);
			
			parMois=(totalMA/dureeExo);
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule("", caseStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule(parMois, caseStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
			
			// MBP
			cel=new OooCellule("Marge brute de production", titreStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			long totalMBP=totalPE+totalMA;
			cel=new OooCellule(totalMBP, chiffreTitreStyle);
			ligne.ajouterCellule(cel);
			
			parMois=(totalPE/dureeExo)-(totalMA/dureeExo);
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule("", chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule(parMois, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
			
			
			// MBG
			cel=new OooCellule("Marge commerciale", titreStyle);
			ligne=new OooLigne(ligneStyle);
			ligne.ajouterCellule(cel);
			cel=new OooCellule(totalMC+totalMBP, chiffreTitreStyle);
			ligne.ajouterCellule(cel);
			
			parMois=(totalMC/dureeExo)-(totalMBP/dureeExo);
			for (int n=1; n<=nbMois;n++)
			{
				ligne.ajouterCellule(celVide);
				cel=new OooCellule(parMois, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule("", chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				cel=new OooCellule(parMois, chiffreTitreStyle);
				ligne.ajouterCellule(cel);
				
			}
	
			renoir.ajouterLigne(ligne);
	}
	
	
	
	
	
	
	
	
	
	public void lisTotaux() throws SQLException	{

		String requete="";
		conditionsComptes cond=new conditionsComptes();
		double debit, credit;
		Statement stt1 = con.createStatement();
		ResultSet resultatReq;
		
		//Vente de marchandises
		requete= "SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit FROM "+base+".SOLDE_COMPTE c, "+base+".OPERATION o ";
		requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND ( "+cond.productionVendue("c.")+" ) GROUP BY c.Numero_Compte";
		
		resultatReq=stt1.executeQuery(requete);
		debit=0;
		credit=0;
		while (resultatReq.next()) {
			debit+=resultatReq.getDouble("debit");
			credit+=resultatReq.getDouble("credit");
		}
		totalVM=(long)(debit-credit);
		
		
		//Cout d'achat des marchandises vendues
		requete= "SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit FROM "+base+".SOLDE_COMPTE c, "+base+".OPERATION o ";
		requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND ( "+cond.coutAchatMarchVendues("c.")+" ) GROUP BY c.Numero_Compte";
		
		resultatReq=stt1.executeQuery(requete);
		debit=0;
		credit=0;
		while (resultatReq.next()) {
			debit+=resultatReq.getDouble("debit");
			credit+=resultatReq.getDouble("credit");
		}
		totalCMV=(long)(debit-credit);

		
		//Production vendue
		requete= "SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit FROM "+base+".SOLDE_COMPTE c, "+base+".OPERATION o ";
		requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND ( "+cond.productionVendue("c.")+" ) GROUP BY c.Numero_Compte";
		
		resultatReq=stt1.executeQuery(requete);
		debit=0;
		credit=0;
		while (resultatReq.next()) {
			debit+=resultatReq.getDouble("debit");
			credit+=resultatReq.getDouble("credit");
		}
		totalPV=(long)(debit-credit);
	
	
		
		//Production stocke
		requete= "SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit FROM "+base+".SOLDE_COMPTE c, "+base+".OPERATION o ";
		requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND ( "+cond.prodStockeeOuDestock("c.")+" ) GROUP BY c.Numero_Compte";
		
		resultatReq=stt1.executeQuery(requete);
		debit=0;
		credit=0;
		while (resultatReq.next()) {
			debit+=resultatReq.getDouble("debit");
			credit+=resultatReq.getDouble("credit");
		}
		totalPS=(long)(debit-credit);
	
	
		//Production immobilise
		requete= "SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit FROM "+base+".SOLDE_COMPTE c, "+base+".OPERATION o ";
		requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND ( "+cond.productionImmo("c.")+" ) GROUP BY c.Numero_Compte";
		
		resultatReq=stt1.executeQuery(requete);
		debit=0;
		credit=0;
		while (resultatReq.next()) {
			debit+=resultatReq.getDouble("debit");
			credit+=resultatReq.getDouble("credit");
		}
		totalPIM=(long)(debit-credit);
	
		
		//Matieres premires appro consomms
		requete= "SELECT SUM(o.Montant_D) as debit, SUM(o.Montant_C) as credit FROM "+base+".SOLDE_COMPTE c, "+base+".OPERATION o ";
		requete+=" WHERE c.Numero_Compte=o.Numero_Compte AND ( "+cond.matPremiereApproConso("c.")+" ) GROUP BY c.Numero_Compte";
		
		resultatReq=stt1.executeQuery(requete);
		debit=0;
		credit=0;
		while (resultatReq.next()) {
			debit+=resultatReq.getDouble("debit");
			credit+=resultatReq.getDouble("credit");
		}
		totalMA=(long)(debit-credit);

	}
	
	
	public String leMois(int lemois) {
		String resultat="";
		
		switch (lemois)	{
			case 1: resultat="Janvier";break;
			case 2: resultat="Fvrier";break;
			case 3: resultat="Mars";break;
			case 4: resultat="Avril";break;
			case 5: resultat="Mai";break;
			case 6: resultat="Juin";break;
			case 7: resultat="Juillet";break;
			case 8: resultat="Aout";break;
			case 9: resultat="Septembre";break;
			case 10: resultat="Octobre";break;
			case 11: resultat="Novembre";break;
			case 12: resultat="Dcembre";break;
			default: resultat="";		
		}
		
		return resultat;
	}	
	
	
} // exportCAVersOoo



		
			
			










