package org.opensi.compta.actions.transferts;


import java.util.ArrayList;


public class ErrorLog {


	private int nbError = 0;
	private int nbWarn = 0;
	private int nbInfo = 0;
	
	private ArrayList<Log> loglist = new ArrayList<Log>();

	public ErrorLog() {}
	
	
	public void addError(int line, String error) {
	
		loglist.add(new Log(Log.ERROR, error, line));
	
		nbError++;
	}
	
	public void addError(String error) {
	
		loglist.add(new Log(Log.ERROR, error, 0));
	
		nbError++;
	}
	
	public void addWarn(int line, String warn) {
	
		loglist.add(new Log(Log.WARN, warn, line));
		
		nbWarn++;
	}
	
	public void addWarn(String warn) {
	
		loglist.add(new Log(Log.WARN, warn, 0));
		
		nbWarn++;
	}
	
	public void addInfo(int line, String info) {
	
		loglist.add(new Log(Log.INFO, info, line));
		
		nbInfo++;
	}
	
	public void addInfo(String info) {
	
		loglist.add(new Log(Log.INFO, info, 0));
		
		nbInfo++;
	}
	
	public Log getLog(int index) {
		try {
			return loglist.get(index);
		
		}	catch (IndexOutOfBoundsException iobe) {
			return null;
		}
	}	
	
	
	public int getNbError() {
		return nbError;
	}
	
	public int getNbWarn() {
		return nbWarn;
	}
	
	public int getNbInfo() {
		return nbInfo;
	}
	
	public int size() {
		return loglist.size();
	}

} // fin ErrorLog
