/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.dossier;

import java.util.HashMap;
import java.sql.Connection;

import org.opensi.dbm.general.DBM_Civilite;
import org.opensi.dbm.general.DBM_CodePays;


public class Adresse implements org.opensi.api.DataOSI {


	private String denomination;
	private String adresse1;
	private String adresse2;
	private String adresse3;
	private String codePostal;
	private String ville;
	private String codePays;


	public Adresse(String denomination,
								 String adresse1,
								 String adresse2,
								 String adresse3,
								 String codePostal,
								 String ville,
								 String codePays) {
		
		this.denomination = denomination;
		this.adresse1 = adresse1;
		this.adresse2 = adresse2;
		this.adresse3 = adresse3;
		this.codePostal = codePostal;
		this.ville = ville;
		this.codePays = codePays;
	}
	
	
	public boolean isValid() {
	
		return true;
	}

	public HashMap<String, String> diff(Adresse adresse,String prefixe, Connection con) {
		HashMap<String, String> diff = new HashMap<String, String>();

		try {
			
			DBM_CodePays dbm_codePays = new DBM_CodePays(con);
	
			if (this.equals(adresse)) {
				return diff;
			}
			if (!getDenomination().equals(adresse.getDenomination())) {
				String valeur = prefixe+"Dnomination modifi de "+adresse.getDenomination()+"  "+getDenomination();
				diff.put("Denomination",valeur); 
			}
			if (!getAdresse1().equals(adresse.getAdresse1())) {
				String valeur = prefixe+"Adresse 1 modifi de "+adresse.getAdresse1()+"  "+getAdresse1();
				diff.put("Adresse1",valeur); 
			}	
			if (!getAdresse2().equals(adresse.getAdresse2())) {
				String valeur = prefixe+"Adresse 2 modifi de "+adresse.getAdresse2()+"  "+getAdresse2();
				diff.put("Adresse2",valeur); 
			}			
			if (!getAdresse3().equals(adresse.getAdresse3())) {
				String valeur = prefixe+"Adresse 3 modifi de "+adresse.getAdresse3()+"  "+getAdresse3();
				diff.put("Adresse3",valeur); 
			}			
			if (!getCodePostal().equals(adresse.getCodePostal())) {
				String valeur = prefixe+"Code postal modifi de "+adresse.getCodePostal()+"  "+getCodePostal();
				diff.put("CodePostal",valeur); 
			}
			if (!getVille().equals(adresse.getVille())) {
				String valeur = prefixe+"Ville modifi de "+adresse.getVille()+"  "+getVille();
				diff.put("Ville",valeur); 
			}
			if (!getCodePays().equals(adresse.getCodePays())) {
				String valeur = prefixe+"Pays modifi de "+dbm_codePays.getPays(adresse.getCodePays())+"  "+dbm_codePays.getPays(getCodePays());
				diff.put("CodePays",valeur); 
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}

		return diff;
	}
	
	public String getDenomination() { return denomination; }
	public String getAdresse1() { return adresse1; }
	public String getAdresse2() { return adresse2; }
	public String getAdresse3() { return adresse3; }
	public String getCodePostal() { return codePostal; }
	public String getVille() { return ville; }
	public String getCodePays() { return codePays; }
	

} // fin Adresse
