/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.dossier;

import java.util.HashMap;


public class BonReception implements org.opensi.api.DataOSI {

	private int brId;
	private long dateBR;
	private String commentairesFin;
	private String commentairesInt;
	private long dateC;
	private long dateM;
	private int utilC;
	private int utilM;
	private int numero;
	private String numEntier;
	private String numFacture;
	private String numBL;
	private String etat;
	private boolean transfere;
	private int prepId;
	private String mentions;
	private long dateDEB;
	private double totalHT;
	private double totalTTC;
	private HashMap<Integer, LigneBonReception> lignesBonReception;

	
	public BonReception(int brId,
						long dateBR,
						String commentairesFin,
						String commentairesInt,
						long dateC,
						long dateM,
						int utilC,
						int utilM,
						int numero,
						String numEntier,
						String numFacture,
						String numBL,
						String etat,
						boolean transfere,
						int prepId,
						String mentions,
						long dateDEB,
						double totalHT,
						double totalTTC) {
		
		this.brId = brId;
		this.dateBR = dateBR;
		this.commentairesFin = commentairesFin;
		this.commentairesInt = commentairesInt;
		this.dateC = dateC;
		this.dateM = dateM;
		this.utilC = utilC;
		this.utilM = utilM;
		this.numero = numero;
		this.numEntier = numEntier;
		this.numFacture = numFacture;
		this.numBL = numBL;
		this.etat = etat;
		this.transfere = transfere;
		this.prepId = prepId;
		this.mentions = mentions;
		this.dateDEB = dateDEB;
		this.totalHT = totalHT;
		this.totalTTC = totalTTC;
		
	}


	public boolean isValid() {
	
		return true;
	}
	
	
	public void addLigne(int ligneId, LigneBonReception ligneBonReception) { this.lignesBonReception.put(ligneId, ligneBonReception); }
	
	public int getBRId() { return brId; }
	public long getDateBR() { return dateBR; }
	public String getCommentairesFin() { return commentairesFin; }
	public String getCommentairesInt() { return commentairesInt; }
	public long getDateC() { return dateC; }
	public long getDateM() { return dateM; }
	public int getUtilC() { return utilC; }
	public int getUtilM() { return utilM; }
	public int getNumero() { return numero; }
	public String getNumEntier() { return numEntier; }
	public String getNumFacture() { return numFacture; }
	public String getNumBL() { return numBL; }
	public String getEtat() { return etat; }
	public boolean getTransfere() { return transfere; }
	public int getPrepId() { return prepId; }
	public String getMentions() { return mentions; }
	public long getDateDEB() { return dateDEB; }
	public double getTotalHT() { return totalHT; }
	public double getTotalTTC() { return totalTTC; }
	public HashMap<Integer, LigneBonReception> getLignesBonReception() { return lignesBonReception; }
	

} // fin BonReception
