/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.dbm.dossier;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.opensi.api.DBM_Object;
import org.opensi.api.SessionOSI;
import org.opensi.data.dossier.CommandeClientWeb;

public class DBM_CommandeClientWeb implements DBM_Object {

	private Connection con;
	private String baseDossier;
	private int user;
	private SessionOSI sosi;


	public DBM_CommandeClientWeb(Connection con, String baseDossier) {
		
		this.con = con;
		this.baseDossier = baseDossier;
	}


	public void save(CommandeClientWeb commandeClientWeb) throws SQLException {
		
	}

	public void delete(int commandeClientId) throws SQLException {
		
	}

	public CommandeClientWeb load(int commandeClientId) throws SQLException {

		CommandeClientWeb commandeClientWeb = null;

		PreparedStatement psComWeb = con.prepareStatement("select * from "+ baseDossier +".COMMANDE_CLIENT_WEB where Commande_Id=?");

		psComWeb.setInt(1, commandeClientId);
		ResultSet rsCW = psComWeb.executeQuery();
		if (rsCW.next()) {
			commandeClientWeb = new CommandeClientWeb(rsCW.getInt("Site_Web_Id"),rsCW.getString("Ref_Com_Web"),rsCW.getString("Num_Transaction"), rsCW.getString("Origine"), rsCW.getInt("Client_Web_Id"),rsCW.getBoolean("Statut_Modifie"), rsCW.getString("Mail_Manager"), rsCW.getString("Code_Porte"), rsCW.getString("Infos_Commande"), rsCW.getBoolean("Envoi_Multiple"));
		}
		rsCW.close();

		return commandeClientWeb;
	}

} // fin DBM_CommandeClient
