/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.dossier;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.data.dossier.Compte;


public class DBM_Compte implements DBM_Object {

	private Connection con;
	private String baseDossier;

	
	public DBM_Compte(Connection con, String baseDossier) {
		
		this.baseDossier = baseDossier;
		this.con = con;
	}
	
	
	public boolean exist(String numeroCompte) throws SQLException {
		
		PreparedStatement psExiste = con.prepareStatement("select 1 from "+ baseDossier +".COMPTE where Numero_Compte=?");
			
		psExiste.setString(1, numeroCompte);
		ResultSet rset = psExiste.executeQuery();
		
		boolean existe = rset.next();
		
		rset.close();
		psExiste.close();
		
		return existe;
	}
	
	
	public boolean exist(String numeroCompte, boolean centralisateur) throws SQLException {
		
		PreparedStatement psExiste = con.prepareStatement("select 1 from "+ baseDossier +".COMPTE where Numero_Compte=? and Centralisateur=?");
			
		psExiste.setString(1, numeroCompte);
		psExiste.setBoolean(2, centralisateur);
		ResultSet rset = psExiste.executeQuery();
		
		boolean existe = rset.next();
		
		rset.close();
		psExiste.close();
		
		return existe;
	}
	
	
	public Compte load(String numeroCompte) throws SQLException {
	
		Compte compte = null;
	
		PreparedStatement psLoad = con.prepareStatement("select * from "+ baseDossier +".COMPTE where Numero_Compte=?");
		
		psLoad.setString(1, numeroCompte);
		ResultSet rset = psLoad.executeQuery();
		
		if (rset.next()) {
			compte = new Compte();
			
			compte.setNumeroCompte(numeroCompte);
			compte.setIntitule(rset.getString("Intitule"));
			compte.setTypeCompte(rset.getString("Type_Compte"));
			compte.setCollectif(rset.getString("Collectif"));
			compte.setContrepartie(rset.getString("Contrepartie"));
			compte.setCodeTVA(rset.getInt("Code_TVA"));
			compte.setCumulJournal(rset.getBoolean("Cumul_Journal"));
			compte.setDetailCloture(rset.getBoolean("Detail_Cloture"));
			compte.setTvaEncaissement(rset.getBoolean("Tva_Encaissement"));
			compte.setCentralisateur(rset.getBoolean("Centralisateur"));
			compte.setDateC(rset.getLong("Date_C"));
		}
		
		return compte;
	}


	public void insert(Compte compte) throws SQLException {
	
		PreparedStatement psNewCompte = con.prepareStatement("insert into "+ baseDossier +".COMPTE (Numero_Compte, Intitule, Type_Compte, Collectif, Contrepartie, Code_TVA, Cumul_Journal, Detail_Cloture, Tva_Encaissement, Centralisateur, Date_C) values (?,?,?,?,?,?,?,?,?,?,?)");

		psNewCompte.setString(1, compte.getNumeroCompte());
		psNewCompte.setString(2, compte.getIntitule());
		psNewCompte.setString(3, compte.getTypeCompte());
		psNewCompte.setString(4, compte.getCollectif());
		psNewCompte.setString(5, compte.getContrepartie());
		psNewCompte.setInt(6, compte.getCodeTVA());
		psNewCompte.setBoolean(7, compte.getCumulJournal());
		psNewCompte.setBoolean(8, compte.getDetailCloture());
		psNewCompte.setBoolean(9, compte.getTvaEncaissement());
		psNewCompte.setBoolean(10, compte.getCentralisateur());
		psNewCompte.setLong(11, System.currentTimeMillis());
		psNewCompte.executeUpdate();
	} 


	public void update(Compte compte) throws SQLException {
	
		PreparedStatement psUpCompte = con.prepareStatement("update "+ baseDossier +".COMPTE set Intitule=?, Type_Compte=?, Collectif=?, Contrepartie=?, Code_TVA=?, Cumul_Journal=?, Detail_Cloture=?, Tva_Encaissement=?, Centralisateur=? where Numero_Compte=?");
				
		psUpCompte.setString(1, compte.getIntitule());
		psUpCompte.setString(2, compte.getTypeCompte());
		psUpCompte.setString(3, compte.getCollectif());
		psUpCompte.setString(4, compte.getContrepartie());
		psUpCompte.setInt(5, compte.getCodeTVA());
		psUpCompte.setBoolean(6, compte.getCumulJournal());
		psUpCompte.setBoolean(7, compte.getDetailCloture());
		psUpCompte.setBoolean(8, compte.getTvaEncaissement());
		psUpCompte.setBoolean(9, compte.getCentralisateur());
		psUpCompte.setString(10, compte.getNumeroCompte());
		psUpCompte.executeUpdate();
	}
	
	
	public void delete(String numeroCompte) throws SQLException {
	
		PreparedStatement psSupCompte = con.prepareStatement("delete from "+ baseDossier +".COMPTE where Numero_Compte=?");

		psSupCompte.setString(1, numeroCompte);		
		psSupCompte.executeUpdate();
	}
		

} // fin DBM_Compte
