/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.dossier;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.data.dossier.ParamDossier;


public class DBM_ParamDossier implements DBM_Object {


	private Connection con;
	private String baseDossier;
	
	
	public DBM_ParamDossier(Connection con, String baseDossier) {
		
		this.con = con;
		this.baseDossier = baseDossier;
	}
	

	public void save(ParamDossier paramDossier) throws SQLException {
				
		if (paramDossier.isValid()) {
			PreparedStatement psNewParamDossier = con.prepareStatement("insert into "+ baseDossier +".PARAM_DOSSIER ("
																					+ "Date_Factu,Com_Fact,Com_BL,Com_Devis,Modele_Etiquette,Modele_Pdf_FC,Modele_Pdf_AC,Modele_Pdf_CC,Modele_Pdf_FF,"
																					+ "Modele_Pdf_AF,Modele_Pdf_CF,Modele_Pdf_BL,Modele_Pdf_BP,Modele_Pdf_BR,Modele_Pdf_DC,Modele_Pdf_RC,Modele_Pdf_FAC,"
																					+ "Code_Journal_Achat,Code_Journal_Vente,Code_Journal_AN,Numero_Compte_Clients,Numero_Compte_Fournisseurs,Numero_Compte_Achat_UE,Numero_Compte_Achat_I,"
																					+ "Numero_Compte_Port_AC,Numero_Compte_Port_VE,Numero_Compte_Escompte_AC,Numero_Compte_Escompte_VE,Numero_Compte_Acompte_VE,Numero_Compte_Regul_AC,"
																					+ "Numero_Compte_Regul_VE,Numero_Compte_Tva_Due_IC,Numero_Compte_Tva_Ded_IC,Numero_Compte_Especes) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");  
			
			psNewParamDossier.setLong(1, paramDossier.getDateFactu());
			psNewParamDossier.setString(2, paramDossier.getComFact());
			psNewParamDossier.setString(3, paramDossier.getComBL());
			psNewParamDossier.setString(4, paramDossier.getComDevis());
			psNewParamDossier.setString(5, paramDossier.getModeleEtiquette());
			psNewParamDossier.setString(6, paramDossier.getModelePdfFC());
			psNewParamDossier.setString(7, paramDossier.getModelePdfAC());
			psNewParamDossier.setString(8, paramDossier.getModelePdfCC());
			psNewParamDossier.setString(9, paramDossier.getModelePdfFF());
			psNewParamDossier.setString(10, paramDossier.getModelePdfAF());
			psNewParamDossier.setString(11, paramDossier.getModelePdfCF());
			psNewParamDossier.setString(12, paramDossier.getModelePdfBL());
			psNewParamDossier.setString(13, paramDossier.getModelePdfBP());
			psNewParamDossier.setString(14, paramDossier.getModelePdfBR());
			psNewParamDossier.setString(15, paramDossier.getModelePdfDC());
			psNewParamDossier.setString(16, paramDossier.getModelePdfRC());
			psNewParamDossier.setString(17, paramDossier.getModelePdfFAC());
			psNewParamDossier.setString(18, paramDossier.getCodeJournalAchat());
			psNewParamDossier.setString(19, paramDossier.getCodeJournalVente());
			psNewParamDossier.setString(20, paramDossier.getCodeJournalAN());
			psNewParamDossier.setString(21, paramDossier.getNumeroCompteClients());
			psNewParamDossier.setString(22, paramDossier.getNumeroCompteFournisseurs());
			psNewParamDossier.setString(23, paramDossier.getNumeroCompteAchatUE());
			psNewParamDossier.setString(24, paramDossier.getNumeroCompteAchatI());
			psNewParamDossier.setString(25, paramDossier.getNumeroComptePortAC());
			psNewParamDossier.setString(26, paramDossier.getNumeroComptePortVE());
			psNewParamDossier.setString(27, paramDossier.getNumeroCompteEscompteAC());
			psNewParamDossier.setString(28, paramDossier.getNumeroCompteEscompteVE());
			psNewParamDossier.setString(29, paramDossier.getNumeroCompteAcompteVE());
			psNewParamDossier.setString(30, paramDossier.getNumeroCompteRegulAC());
			psNewParamDossier.setString(31, paramDossier.getNumeroCompteRegulVE());
			psNewParamDossier.setString(32, paramDossier.getNumeroCompteTvaDueIC());
			psNewParamDossier.setString(33, paramDossier.getNumeroCompteTvaDedIC());
			psNewParamDossier.setString(34, paramDossier.getNumeroCompteEspeces());		
			
			psNewParamDossier.executeUpdate();
		}
	}

	
	public String getCodeJournalAN() throws SQLException {
		
		PreparedStatement psJournalAN = con.prepareStatement("select Code_Journal_AN from "+ baseDossier +".PARAM_DOSSIER");
		ResultSet rset = psJournalAN.executeQuery();		
		rset.next();
					
		String codeJournalAN = rset.getString("Code_Journal_AN");
		
		psJournalAN.close();
		
		return codeJournalAN;
	}
		
	
} // fin DBM_ParamDossier
