/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.reglements.clients.MajStatutCommandes;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.tools.Arrondi;
import org.opensi.util.tools.DateTime;

public class AffaireFacture {

	private Connection con;
	private String base;
	private Session s;
	private Long dateFactu;
	private String clientId = null;
	private int responsableId = 0;
	private String nomResp = "";
	private String prenomResp = "";
	private int modeReg;
	private long echeance;
	private double escompte = 0;
	private double remise = 0;
	private double montantRemise = 0;
	private double fraisPort = 0;
	private double acompte = 0;
	private boolean assujettiTVA = false;
	private String numTVAIntra = "";
	private boolean editionTTC = false;
	private String regimeTVA = "G";
	private String typeFact;
	private String modeFacturation;
	private String codePaysLiv;
	private boolean taxeArrivee;
	private double tauxTVA;
	private int codeTVA;
	private long dateEditionAuto = 0;
	private int civInter;
	private String nomInter;
	private String prenomInter;
	private String telInter;
	private String faxInter;
	private String emailInter;
	private String adresse1Fact;
	private String adresse2Fact;
	private String adresse3Fact;
	private String cpFact;
	private String villeFact;
	private String codePaysFact;
	private String denomination;
	private int civInterLiv;
	private String nomInterLiv;
	private String prenomInterLiv;
	private String faxInterLiv;
	private String telInterLiv;
	private String emailInterLiv;
	private String denominationLiv;
	private String adresse1Liv;
	private String adresse2Liv;
	private String adresse3Liv;
	private String cpLiv;
	private String villeLiv;
	private int user;
	private long now;
	private String s_session;
	private double ecoTaxe;
	private String numEntier;
	private int numUnique;
	private int numero;
	private String denominationEnvoi;
	private String adresse1Envoi;
	private String adresse2Envoi;
	private String adresse3Envoi;
	private String cpEnvoi;
	private String villeEnvoi;
	private String codePaysEnvoi;
	private int civInterEnvoi;
	private String nomInterEnvoi;
	private String prenomInterEnvoi;
	private String telInterEnvoi;
	private String emailInterEnvoi;
	private String faxInterEnvoi;
	private double pRemise_FP;
	private double mRemise_FP;
	private double totalTTC;
	private double mEscompte;
	private String modeEnvoi;
	private int moduleEnvoi = 0;
	private int ligneFacture;
	private DateTime debmois;
	private long millidebmois;
	private String affaires;
	private ResultSet rset3;
	private ResultSet rset4;
	private ResultSet rset5;
	private double quantiteLivree;
	private double quantiteFacturee;
	private String decoche = "";
	private double montantAcompte;
	private String secteurActivite;
	private ResultSet rset;

	protected Arrondi r3 = new Arrondi(3);


	public AffaireFacture(String s_) {
		try {

			this.s_session = s_;
			s = Session.findClient(s_);
			con = s.getConnection(null);
			base = s.getCookie().get("BaseDossier");
			user = Integer.parseInt(s.getCookie().get("User"));

			now = (new DateTime()).getTimeInMillis();
			debmois = new DateTime();
			debmois.setDay(1);
			millidebmois = debmois.getDateInMillis();

			dateFactu = (new DateTime()).getTimeInMillis();
			dateEditionAuto = dateFactu;

			Statement stt = con.createStatement();
			rset = stt.executeQuery("select Date_Factu,Module_Envoi from "+ base +".PARAM_DOSSIER");

			if (rset.next()) {
				if (rset.getLong("Date_Factu") < dateFactu) {
					dateFactu = rset.getLong("Date_Factu");
				}
				moduleEnvoi  = rset.getInt("Module_Envoi");
			}
			
			stt.close();
			
			DateTime normDate = new DateTime(dateFactu);
			dateFactu = normDate.getDateInMillis();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}


	public AffaireFacture(String s_, long date) {
		try {

			this.s_session = s_;
			s = Session.findClient(s_);
			con = s.getConnection(null);
			base = s.getCookie().get("BaseDossier");
			user = Integer.parseInt(s.getCookie().get("User"));

			now = date;
			debmois = new DateTime(date);
			debmois.setDay(1);
			millidebmois = debmois.getDateInMillis();

			dateFactu = date;
			dateEditionAuto = date;

			Statement stt = con.createStatement();
			rset = stt.executeQuery("select Date_Factu,Module_Envoi from "+ base +".PARAM_DOSSIER");

			if (rset.next()) {
				if (rset.getLong("Date_Factu") < dateFactu) {
					dateFactu = rset.getLong("Date_Factu");
				}
				moduleEnvoi  = rset.getInt("Module_Envoi");
			}
			
			stt.close();
			
			DateTime normDate = new DateTime(dateFactu);
			dateFactu = normDate.getDateInMillis();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public long getDateFacture() {
		return this.dateFactu;
	}

	public long creerFacturesAuto(String listeAffaires, String produitsDecoche) {
		try {
			if (produitsDecoche.length()>0) {
				decoche = " and cp.Produit_Id not in ("+produitsDecoche+") ";
			}
			affaires = listeAffaires;
			if (affaires.charAt(affaires.length()-1)==',') {
				affaires = affaires.substring(0, affaires.length()-1);
			}
			String affairesId="";
			PreparedStatement psGetAffaires = con.prepareStatement("select Type_Fact,Mode_Facturation,group_concat(distinct Affaire_Id) as Affaires_Id from "+ base + ".AFFAIRE where Affaire_Id in ("+affaires+") group by Type_Fact,Mode_Facturation, Client_Id");

			ResultSet rsetaff = psGetAffaires.executeQuery();

			while (rsetaff.next()) {
				affairesId=rsetaff.getString("Affaires_Id");
				typeFact = rsetaff.getString("Type_Fact");
				modeFacturation = rsetaff.getString("Mode_Facturation");

				/*psSepFP = con.prepareStatement("select group_concat(distinct a.Affaire_Id) as Affaires_Id, group_concat(distinct cc.Commande_Id) as Commandes_Id from "+ base + ".AFFAIRE a join "+ base + ".COMMANDE_CLIENT cc on cc.Affaire_Id=a.Affaire_Id  where a.Affaire_Id in ("+affairesId+") group by a.Fact_Sep_FP");
				ResultSet rsetSepFP = psSepFP.executeQuery();
				while (rsetSepFP.next()) {
	    			//int factureId = creerFactureFP(rsetSepFP.getString("Affaires_Id"), rsetSepFP.getString("Commandes_Id"));
	    			//validerFacture(factureId);
				}
				 */
				if (!typeFact.equals("GA")) {
					String[] aff = affairesId.split(",");
					for (int z=0;z<aff.length;z++) {
						creerFacturesAutoSuite(aff[z]);
					}
				}
				else {
					creerFacturesAutoSuite(affairesId);
				}
			}
			
			psGetAffaires.close();

			return dateEditionAuto;
			
		} catch (Exception e) {
			e.printStackTrace();
			return 0;
		}
	}


	public void lierBonLivraisonFacture(int Bon_Id) {
		try {
		
			PreparedStatement psSelLigneBonLivraison = con.prepareStatement("select Ligne_Id, Ref_Ligne, Quantite from "+ base + ".LIGNE_BON_LIVRAISON where Bon_Id=? and Statut='V' order by Rank");

			PreparedStatement psSelLigneBonLivraisonFacture = con.prepareStatement("select f.Facture_Id,Ligne_Id, Quantite from "+ base + ".LIGNE_FACTURE lf join "+ base + ".FACTURE f on lf.Facture_Id=f.Facture_Id where Ref_Ligne=? and Numero>0 order by Date_Facture");

			PreparedStatement psSelLigneImputBonLivraisonFacture = con.prepareStatement("select sum(Quantite) as Quantite from "+ base + ".IMPUTATION_LIGNE_BL_FC ilbf where Ref_Ligne_FC=?");

			PreparedStatement psInsImputeLigneBLFacture = con.prepareStatement("insert into "+ base + ".IMPUTATION_LIGNE_BL_FC (Ref_Ligne_BL, Ref_Ligne_FC, Quantite) values (?, ?, ?)");
			
			PreparedStatement psInsLierBonLivraisonFacture = con.prepareStatement("insert into " + base+ ".BON_LIVRAISON_FACTURE (Bon_Id, Facture_Id) values (?,?)");


			//Insere IMPUTATION_LIGNE_BL_FC
			psSelLigneBonLivraison.setInt(1,Bon_Id);
			rset3 = psSelLigneBonLivraison.executeQuery();
			while(rset3.next()) {
				quantiteLivree=rset3.getDouble("Quantite");
				psSelLigneBonLivraisonFacture.setInt(1, rset3.getInt("Ref_Ligne"));
				rset4 = psSelLigneBonLivraisonFacture.executeQuery();
				while(rset4.next() && quantiteFacturee>0) {
					quantiteFacturee=rset4.getDouble("Quantite");
					psSelLigneImputBonLivraisonFacture.setInt(1, rset4.getInt("Ligne_Id"));
					rset5 = psSelLigneImputBonLivraisonFacture.executeQuery();
					while(rset5.next()) {
						quantiteFacturee-=rset5.getDouble("Quantite");
					}
					if (quantiteFacturee>0) {
						psInsImputeLigneBLFacture.setInt(1, rset4.getInt("Ligne_Id"));
						psInsImputeLigneBLFacture.setInt(2, rset3.getInt("Ligne_Id"));
						psInsImputeLigneBLFacture.setDouble(3, quantiteFacturee);
						psInsImputeLigneBLFacture.executeUpdate();
						psInsLierBonLivraisonFacture.setInt(1, Bon_Id);
						psInsLierBonLivraisonFacture.setInt(2,rset4.getInt("Facture_Id"));
						psInsLierBonLivraisonFacture.executeUpdate();
						quantiteLivree-=quantiteFacturee;
					}
				}
			}
			
			psSelLigneBonLivraison.close();
			psSelLigneBonLivraisonFacture.close();
			psSelLigneImputBonLivraisonFacture.close();
			psInsImputeLigneBLFacture.close();
			psInsLierBonLivraisonFacture.close();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}


	public void delierBonLivraisonFacture(int Bon_Id) {
		try {
		
			PreparedStatement psdelImputBonLivraisonFacture = con.prepareStatement("delete from "+ base + ".IMPUTATION_LIGNE_BL_FC where Ref_Ligne_BL in (select Ligne_Id from "+ base + ".LIGNE_BON_LIVRAISON where Bon_Id=? and Statut='V')");
			PreparedStatement psdelBonLivraisonFacture = con.prepareStatement("delete from "+ base + ".BON_LIVRAISON_FACTURE where Bon_Id=?");

			psdelImputBonLivraisonFacture.setInt(1,Bon_Id);
			psdelImputBonLivraisonFacture.executeUpdate();

			psdelBonLivraisonFacture.setInt(1,Bon_Id);
			psdelBonLivraisonFacture.executeUpdate();
			
			psdelImputBonLivraisonFacture.close();
			psdelBonLivraisonFacture.close();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	
	public void calculerAcompteFacture(int factureId) {
		try {
		
			Calcul calc = new Calcul (s_session,factureId,"Facture");

			PreparedStatement psDelImpAcFcClient = con.prepareStatement("delete from " + base+ ".IMPUTATION_ACOMPTE_FACTURE_CLIENT where Facture_Id=?");
			psDelImpAcFcClient.setInt(1, factureId);
			psDelImpAcFcClient.executeUpdate();
			PreparedStatement psInsImpAcFcClient = con.prepareStatement("insert into " + base+ ".IMPUTATION_ACOMPTE_FACTURE_CLIENT (Acompte_Id,Facture_Id, Montant) values (?,?,?)");
			psInsImpAcFcClient.setInt(2, factureId);

			totalTTC = calc.getTotalTTC();

			PreparedStatement psSelAcomptes = con.prepareStatement("select ac.Acompte_Id, Total_TTC-(sum(coalesce(iafc.Montant,0))) as Acompte from " + base+ ".COMMANDE_CLIENT_FACTURE ccf join " + base+ ".ACOMPTE_CLIENT ac on ccf.Commande_Id=ac.Commande_Id left join " + base+ ".IMPUTATION_ACOMPTE_FACTURE_CLIENT iafc on ac.Acompte_Id = iafc.Acompte_Id where Statut='V' and ccf.Facture_Id="+factureId+"" +
					" group by ac.Acompte_Id");
			rset = psSelAcomptes.executeQuery();
			while (rset.next() && totalTTC>0) {
				montantAcompte =  rset.getDouble("Acompte");
				if (montantAcompte>0) {
					psInsImpAcFcClient.setInt(1, rset.getInt("Acompte_Id"));
					psInsImpAcFcClient.setDouble(3,(totalTTC>montantAcompte)?montantAcompte:totalTTC);
					psInsImpAcFcClient.executeUpdate();
					totalTTC -= acompte;
				}
			}
			
			psDelImpAcFcClient.close();
			psInsImpAcFcClient.close();
			psSelAcomptes.close();
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}


	public void creerFacturesAutoSuite(String affairesId) {
		try {

			String commandesId = "";
			if (modeFacturation.equals("E")) {

				PreparedStatement psGetCommandesE =  con.prepareStatement(" select group_concat(distinct com.Commande_Id) as Commandes_Id from (" +
						" select cc.*" +
						" from " + base+ ".COMMANDE_CLIENT cc join "+ base+ ".LIGNE_COMMANDE_CLIENT lcc on cc.Commande_Id=lcc.Commande_Id" +
						" join " + base+ ".TAUX_TVA t on t.Code_TVA=lcc.Code_TVA join " + base+ ".LIGNE_BON_LIVRAISON ab on ab.Ref_Ligne=lcc.Ligne_Id and ab.Statut='V' join " + base+ ".BON_LIVRAISON bl on ab.Bon_Id=bl.Bon_Id  " +
						" left join  " + base+ ".LIGNE_FACTURE lf on ab.Ref_Ligne=lf.Ref_Ligne where" +
						" ab.Ligne_Id not in (select Ligne_Id from "+ base+ ".CODE_PRODUIT_LIGNE_BL) and bl.Etat='V' and bl.Facture=0 and cc.Etat='T' and lcc.Statut='V' and cc.Affaire_Id in  ("+affairesId+")" +
						" group by lcc.Ligne_Id having sum(lcc.Quantite) - sum(coalesce(lf.Quantite,0))>0" +
						" union " +
						"  select cc.*" +
						" from " + base+ ".COMMANDE_CLIENT cc join "+ base+ ".LIGNE_COMMANDE_CLIENT lcc on cc.Commande_Id=lcc.Commande_Id" +
						" join " + base+ ".TAUX_TVA t on t.Code_TVA=lcc.Code_TVA join " + base+ ".LIGNE_BON_LIVRAISON ab on ab.Ref_Ligne=lcc.Ligne_Id and ab.Statut='V' join " + base+ ".BON_LIVRAISON bl on ab.Bon_Id=bl.Bon_Id " +
						" join " + base+ ".CODE_PRODUIT_LIGNE_BL cplb on ab.Ligne_Id=cplb.Ligne_Id" +
						" join " + base+ ".CODE_PRODUIT cp on cplb.Produit_Id=cp.Produit_Id" +
						" where bl.Etat='V' and cp.Facture=0 and Active=1 and bl.Facture=0 and cc.Etat='T' and lcc.Statut='V' and cc.Affaire_Id in  ("+affairesId+")"+ decoche +
						" group by lcc.Ligne_Id having count(cp.Numero)>0" +
						" union " +
						" select cc.*" +
						" from " + base+ ".AFFAIRE a join " + base+ ".COMMANDE_CLIENT cc on a.Affaire_Id=cc.Affaire_Id" +
						" left join "+ base+ ".COMMANDE_CLIENT_FACTURE ccf on cc.Commande_Id=ccf.Commande_Id" +
						" where a.Fact_Sep_FP=1 and cc.Facturee=0 and cc.Etat='T' and cc.Affaire_Id in  ("+affairesId+")" +
						" and cc.Commande_Id in (select distinct Commande_Id from "+ base+ ".BON_LIVRAISON where Etat='V')" +
						" group by cc.Commande_Id having sum(cc.Frais_Port)-sum(coalesce(ccf.Frais_Port,0))>0" +
						" ) as com  join " + base+ ".AFFAIRE a on a.Affaire_Id=com.Affaire_Id" +
						" where a.Periode_Facturation='I' or (a.Periode_Facturation='M' and com.Date_Commande<"+millidebmois+")" +
				" group by trim(com.Denomination),trim(com.Adresse_1),trim(com.Adresse_2),trim(com.Adresse_3),trim(com.Code_Postal),trim(com.Ville),trim(com.Code_Pays),trim(com.Regime_TVA),trim(com.Assujetti_TVA),trim(com.Edition_TTC)");

				//psGetCommandesE = con.prepareStatement("select group_concat(distinct cc.Commande_Id) as Commandes_Id from "+ base + ".COMMANDE_CLIENT cc join "+ base + ".BON_LIVRAISON bl on cc.Commande_Id=bl.Commande_Id  left join "+ base + ".BON_LIVRAISON_FACTURE blf on bl.Bon_Id=blf.Bon_Id left join (select f.Facture_Id from "+ base + ".FACTURE f join "+ base + ".LIGNE_FACTURE lf on f.Facture_Id=lf.Facture_Id where f.Numero>0) as f on blf.Facture_Id=f.Facture_Id where f.Facture_Id is null and cc.Etat='T' and bl.Facture=0 and bl.Etat='V' and cc.Affaire_Id in  ("+affairesId+") group by trim(cc.Denomination),trim(cc.Adresse_1),trim(cc.Adresse_2),trim(cc.Adresse_3),trim(cc.Code_Postal),trim(cc.Ville),trim(cc.Code_Pays),trim(cc.Regime_TVA),trim(cc.Assujetti_TVA),trim(cc.Edition_TTC) union select group_concat(distinct cc.Commande_Id) as Commandes_Id from "+ base + ".COMMANDE_CLIENT cc join "+ base + ".BON_LIVRAISON bl on cc.Commande_Id=bl.Commande_Id join "+ base + ".LIGNE_BON_LIVRAISON lbl on bl.Bon_Id=lbl.Bon_Id join "+ base + ".CODE_PRODUIT_LIGNE_BL cplb on lbl.Ref_Ligne=cplb.Ligne_Id join "+ base + ".CODE_PRODUIT cp on cplb.Produit_Id=cp.Produit_Id and Active=1 and cp.Facture=0 where   cc.Etat='T' and bl.Facture=0 and bl.Etat='V' and cc.Affaire_Id in  ("+affairesId+") group by trim(cc.Denomination),trim(cc.Adresse_1),trim(cc.Adresse_2),trim(cc.Adresse_3),trim(cc.Code_Postal),trim(cc.Ville),trim(cc.Code_Pays),trim(cc.Regime_TVA),trim(cc.Assujetti_TVA),trim(cc.Edition_TTC)");
				ResultSet rsetcom = psGetCommandesE.executeQuery();
				while (rsetcom.next()) {
					commandesId=rsetcom.getString("Commandes_Id");
					if (commandesId!="") {
						if (typeFact.equals("CC") || typeFact.equals("BL")) {
							String[] com = commandesId.split(",");
							for (int y=0;y<com.length;y++) {
								creerFacturesAutoSuite2(affairesId,com[y]);
							}
						}
						else {
							creerFacturesAutoSuite2(affairesId,commandesId);		    						
						}
					}
				}
				
				psGetCommandesE.close();
			}
			else {
				PreparedStatement psGetCommandesC = con.prepareStatement("select group_concat(distinct com.Commande_Id) as Commandes_Id from (select cc.*" +
						" from "+ base + ".COMMANDE_CLIENT cc where cc.Facturee=0 and cc.Etat='T' and cc.Affaire_Id in ("+affairesId+")" +
						" union" +
						" select cc.*" +
						" from " + base+ ".AFFAIRE a join " + base+ ".COMMANDE_CLIENT cc on a.Affaire_Id=cc.Affaire_Id" +
						" left join "+ base+ ".COMMANDE_CLIENT_FACTURE ccf on cc.Commande_Id=ccf.Commande_Id" +
						" where a.Fact_Sep_FP=1 and cc.Facturee=0 and cc.Etat='T' and cc.Affaire_Id in  ("+affairesId+")" +
						" group by cc.Commande_Id having sum(cc.Frais_Port)-sum(coalesce(ccf.Frais_Port,0))>0" +
						" ) as com" +
						" join " + base+ ".AFFAIRE a on a.Affaire_Id=com.Affaire_Id" +
						" where a.Periode_Facturation='I' or (a.Periode_Facturation='M' and com.Date_Commande<"+millidebmois+")" +
				" group by trim(com.Denomination),trim(Adresse_1),trim(Adresse_2),trim(Adresse_3),trim(Code_Postal),trim(Ville),trim(Code_Pays),trim(Regime_TVA),trim(Assujetti_TVA),trim(Edition_TTC), trim(Code_Pays_Liv)");	
				ResultSet rsetcom = psGetCommandesC.executeQuery();
				while (rsetcom.next()) {
					commandesId=rsetcom.getString("Commandes_Id");
					if (commandesId!="") {
						if (typeFact.equals("CC")) {
							String[] com = commandesId.split(",");
							for (int y=0;y<com.length;y++) {
								int nouvelleFactureId = creerFacture(affairesId,com[y],"");
								validerFacture(nouvelleFactureId);
							}
						}
						else {
							int nouvelleFactureId = creerFacture(affairesId,commandesId,"");		    						
							validerFacture(nouvelleFactureId);
						}
					}
				}
				
				psGetCommandesC.close();
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}


	public void creerFacturesAutoSuite2(String affairesId,String commandesId) {
		try {
			String bonsId = "";

			PreparedStatement psGetBonsE =  con.prepareStatement(" select group_concat(bon.Bon_Id) as Bons_Id from (" +
					" select bl.Bon_Id, bl.Code_Pays_Liv,bl.Commande_Id, bl.Date_Liv" +
					" from " + base+ ".COMMANDE_CLIENT cc join "+ base+ ".LIGNE_COMMANDE_CLIENT lcc on cc.Commande_Id=lcc.Commande_Id and lcc.Statut='V'" +
					" join " + base+ ".TAUX_TVA t on t.Code_TVA=lcc.Code_TVA join " + base+ ".LIGNE_BON_LIVRAISON ab on ab.Ref_Ligne=lcc.Ligne_Id and ab.Statut='V' join " + base+ ".BON_LIVRAISON bl on ab.Bon_Id=bl.Bon_Id" +
					" left join  " + base+ ".LIGNE_FACTURE lf on ab.Ref_Ligne=lf.Ref_Ligne where" +
					" ab.Ligne_Id not in (select Ligne_Id from " + base+ ".CODE_PRODUIT_LIGNE_BL) and bl.Etat='V' and bl.Facture=0 and cc.Etat='T' and lcc.Commande_Id in  ("+commandesId+")" +
					" group by ab.Bon_Id, lcc.Ligne_Id having sum(lcc.Quantite) - sum(coalesce(lf.Quantite,0))>0" +
					" union " +
					" select bl.Bon_Id, bl.Code_Pays_Liv,bl.Commande_Id, bl.Date_Liv" +
					" from " + base+ ".COMMANDE_CLIENT cc join "+ base+ ".LIGNE_COMMANDE_CLIENT lcc on cc.Commande_Id=lcc.Commande_Id and lcc.Statut='V'" +
					" join " + base+ ".TAUX_TVA t on t.Code_TVA=lcc.Code_TVA join " + base+ ".LIGNE_BON_LIVRAISON ab on ab.Ref_Ligne=lcc.Ligne_Id and ab.Statut='V' join " + base+ ".BON_LIVRAISON bl on ab.Bon_Id=bl.Bon_Id" +
					" join " + base+ ".CODE_PRODUIT_LIGNE_BL cplb on ab.Ligne_Id=cplb.Ligne_Id" +
					" join " + base+ ".CODE_PRODUIT cp on cplb.Produit_Id=cp.Produit_Id" +
					" where bl.Etat='V' and bl.Facture=0 and cp.Facture=0 and Active=1 and cc.Etat='T' and lcc.Commande_Id in  ("+commandesId+")"+ decoche +
					" group by ab.Bon_Id, lcc.Ligne_Id having count(cp.Numero)>0" +					
					" ) as bon" +
					" join " + base+ ".COMMANDE_CLIENT cc on cc.Commande_Id=bon.Commande_Id" +
					" join " + base+ ".AFFAIRE a on a.Affaire_Id=cc.Affaire_Id" +
					" where a.Periode_Facturation='I' or (a.Periode_Facturation='M' and bon.Date_Liv<"+millidebmois+")" +
			" group by bon.Code_Pays_Liv");

			//psGetBonsE = con.prepareStatement("select group_concat(Bon_Id) as Bons_Id from "+ base + ".BON_LIVRAISON bl left join PAYS p on bl.Code_Pays_Liv=p.Code_Pays where Commande_Id in ("+commandesId+") and Etat='V' and Facture=0 group by bl.Code_Pays_Liv order by Date_Liv");
			ResultSet rsetbl = psGetBonsE.executeQuery();
			while (rsetbl.next()) {
				bonsId=rsetbl.getString("Bons_Id");
				if (typeFact.equals("BL")) {
					String[] bl = bonsId.split(",");
					for (int x=0;x<bl.length;x++) {
						int nouvelleFactureId = creerFacture(affairesId,commandesId,bl[x]);
						validerFacture(nouvelleFactureId);
					}
				}
				else {
					int nouvelleFactureId = creerFacture(affairesId,commandesId,bonsId);		    						
					validerFacture(nouvelleFactureId);
				}
			}
			
			psGetBonsE.close();
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}


	public int creerFacture(String affairesId, String commandesId, String bonsId) {
		try {
			montantRemise = 0;
			int factureId = 0;
			PreparedStatement psRespAffaires = con.prepareStatement("select distinct coalesce(Util_R,0) as Util_R from "+ base + ".AFFAIRE where Affaire_Id in ("+affairesId+")");
			PreparedStatement psSecRespClient = con.prepareStatement("select coalesce(Util_R,0) as Util_R, Secteur_Activite from "+ base + ".FICHE_CLIENT where Client_Id=?");

			PreparedStatement psAffaire = con.prepareStatement("select * from " + base+ ".AFFAIRE where Affaire_Id in ("+affairesId+") order by Date_C desc");
			PreparedStatement psBonCommande = con.prepareStatement("select cc.*, bl.Code_Pays_Liv as Pays from "	+ base + ".BON_LIVRAISON bl join "+ base+ ".COMMANDE_CLIENT cc on cc.Commande_Id=bl.Commande_Id where Bon_Id in ("+bonsId+")");
			PreparedStatement psUtilisateur = con.prepareStatement("select Nom, Prenom from UTILISATEUR where Utilisateur_Id=?");
			PreparedStatement psFicheClient = con.prepareStatement("select Delai_Reg, coalesce(Mode_Reg_Id,0) as Mode_Reg, Type_Reg, Jour_Fact from "+ base + ".FICHE_CLIENT where Client_Id=?");
			PreparedStatement psBonsLivraison = con.prepareStatement("select group_concat(Bon_Id) as bons, cc.Code_Pays_Liv as Code_Pays_Liv_Commande from " + base+ ".BON_LIVRAISON bl join " + base+ ".COMMANDE_CLIENT cc on cc.Commande_Id=bl.Commande_Id where bl.Etat='V' and Facturee=0 and Bon_Id in ("+bonsId+") group by cc.Commande_Id order by Date_Liv desc");

			PreparedStatement psInsFacture = con.prepareStatement(" insert into " + base+ ".FACTURE (" +
					"Date_Facture, Transferee, Numero, Num_Entier, Commentaires_Fin, Commentaires_Int, Commentaires_Hid, Nom_Resp, Prenom_Resp, Civ_Inter,Nom_Inter," +
					"Prenom_Inter,Tel_Inter,Fax_Inter,Email_Inter, Client_Id, Denomination,Adresse_1, Adresse_2, Adresse_3, Code_Postal," +
					" Ville, Code_Pays, Denomination_Liv,Adresse_1_Liv,Adresse_2_Liv,Adresse_3_Liv,Code_Postal_Liv,Ville_Liv,Code_Pays_Liv, Civ_Inter_Liv," +
					" Nom_Inter_Liv,Prenom_Inter_Liv,Tel_Inter_Liv,Fax_Inter_Liv,Email_Inter_Liv,Denomination_Envoi,Adresse_1_Envoi,Adresse_2_Envoi,Adresse_3_Envoi,Code_Postal_Envoi," +
					" Ville_Envoi,Code_Pays_Envoi,Civ_Inter_Envoi,Nom_Inter_Envoi,Prenom_Inter_Envoi,Tel_Inter_Envoi,Fax_Inter_Envoi,Email_Inter_Envoi, Util_M, Util_C," +
					" Date_C, Date_M, Escompte, Remise, Montant_Remise, Mentions,Frais_Port,PRemise_FP,MRemise_FP, Total_HT," +
					" Total_TTC, Directe, Util_R, Assujetti_TVA, Num_TVA_Intra, Taux_TVA_Port, Edition_TTC, Regime_TVA, Mode_Envoi_Facture, Date_Envoi," +
					" Code_TVA_Port, Secteur_Activite ) values ( " +
					" ?,?,?,?,?,?,?,?,?,?" +
					",?,?,?,?,?,?,?,?,?,?" +
					",?,?,?,?,?,?,?,?,?,?" +
					",?,?,?,?,?,?,?,?,?,?" +
					",?,?,?,?,?,?,?,?,?,?" +
					",?,?,?,?,?,?,?,?,?,?" +
					",?,?,?,?,?,?,?,?,?,?" +
			",?,?,?)"); //73 ?

			PreparedStatement psInsEcheanceFacture = con.prepareStatement(" insert into " + base+ ".ECHEANCE_FACTURE_CLIENT (Facture_Id,Mode_Reg_Id,Date_Echeance,Montant) values (?,?,?,?)");

			PreparedStatement psUpFactureTotaux = con.prepareStatement("update "  + base+ ".FACTURE set Frais_Port=?, PRemise_FP=?, MRemise_FP=?, Remise=?, Montant_Remise=?, Escompte=? where Facture_Id=?");
			PreparedStatement psUpFactureTotauxRemise = con.prepareStatement("update "  + base+ ".FACTURE set PRemise_FP=?, MRemise_FP=?, Remise=?, Montant_Remise=? where Facture_Id=?");
			PreparedStatement psUpFactureTotauxEscompte = con.prepareStatement("update "  + base+ ".FACTURE set Escompte=? where Facture_Id=?");

			PreparedStatement psInsArticleFacture =  con.prepareStatement("insert into "+ base+ ".LIGNE_FACTURE (Facture_Id, Rank, Ref_Ligne, Quantite, Reference, Designation, Type_Ligne, Prix, Ristourne, Taux_TVA, Code_TVA, Commentaire, Commentaire_Avant, Libelle, Code_Stats, Unite, Nb_Pieces, Num_Lot, Date_Peremption,Commission)" +
			"values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			PreparedStatement psInsBonLivraisonFacture = con.prepareStatement("insert into " + base+ ".BON_LIVRAISON_FACTURE (Bon_Id, Facture_Id) select Bon_Id,? from "+ base + ".BON_LIVRAISON where Bon_Id in ("+bonsId+")");


			PreparedStatement psCommande = con.prepareStatement("select *, Code_Pays_Liv as Pays from "+ base + ".COMMANDE_CLIENT where Commande_Id in ("+commandesId+") order by Date_Commande desc");


			pRemise_FP = 0;
			remise = 0;
			fraisPort = 0;
			acompte = 0;
			ResultSet rset2;

			rset = psAffaire.executeQuery();
			if (rset.next()) {
				typeFact = rset.getString("Type_Fact");
				modeFacturation = rset.getString("Mode_Facturation");
				modeEnvoi = rset.getString("Mode_Envoi_Facture");
				clientId = rset.getString("Client_Id");
				responsableId = rset.getInt("Util_R");
			}
			if (modeFacturation.equals("C")) {
				rset2 = psCommande.executeQuery();
			}
			else {
				rset2 = psBonCommande.executeQuery();
			}
			if (rset2.next()) {
				civInter = rset2.getInt("Civ_Inter");
				nomInter = rset2.getString("Nom_Inter");
				prenomInter = rset2.getString("Prenom_Inter");
				telInter = rset2.getString("Tel_Inter");
				faxInter = rset2.getString("Fax_Inter");
				emailInter = rset2.getString("Email_Inter");
				denomination = rset2.getString("Denomination");
				adresse1Fact = rset2.getString("Adresse_1");
				adresse2Fact = rset2.getString("Adresse_2");
				adresse3Fact = rset2.getString("Adresse_3");
				cpFact = rset2.getString("Code_Postal");
				villeFact = rset2.getString("Ville");
				codePaysFact = rset2.getString("Code_Pays");

				denominationEnvoi = rset2.getString("Denomination_Envoi");
				adresse1Envoi = rset2.getString("Adresse_1_Envoi");
				adresse2Envoi = rset2.getString("Adresse_2_Envoi");
				adresse3Envoi = rset2.getString("Adresse_3_Envoi");
				cpEnvoi = rset2.getString("Code_Postal_Envoi");
				villeEnvoi = rset2.getString("Ville_Envoi");
				codePaysEnvoi = rset2.getString("Code_Pays_Envoi");
				civInterEnvoi = rset2.getInt("Civ_Inter_Envoi");
				nomInterEnvoi = rset2.getString("Nom_Inter_Envoi");
				prenomInterEnvoi = rset2.getString("Prenom_Inter_Envoi");
				telInterEnvoi = rset2.getString("Tel_Inter_Envoi");
				faxInterEnvoi = rset2.getString("Fax_Inter_Envoi");
				emailInterEnvoi = rset2.getString("Email_Inter_Envoi");

				civInterLiv = rset2.getInt("Civ_Inter_Liv");
				nomInterLiv = rset2.getString("Nom_Inter_Liv");
				prenomInterLiv = rset2.getString("Prenom_Inter_Liv");
				telInterLiv = rset2.getString("Tel_Inter_Liv");
				faxInterLiv = rset2.getString("Fax_Inter_Liv");
				emailInterLiv = rset2.getString("Email_Inter_Liv");
				denominationLiv = rset2.getString("Denomination_Liv");
				adresse1Liv = rset2.getString("Adresse_1_Liv");
				adresse2Liv = rset2.getString("Adresse_2_Liv");
				adresse3Liv = rset2.getString("Adresse_3_Liv");
				cpLiv = rset2.getString("Code_Postal_Liv");
				villeLiv = rset2.getString("Ville_Liv");
				codePaysLiv = rset2.getString("Code_Pays_Liv");

				assujettiTVA = rset2.getInt("Assujetti_TVA") == 1;
				editionTTC = rset2.getInt("Edition_TTC") == 1;
				regimeTVA = rset2.getString("Regime_TVA");

				numTVAIntra = rset2.getString("Num_TVA_Intra");

				if (typeFact.equals("CC") || typeFact.equals("BL")) {
					responsableId = rset2.getInt("Util_R");
				}
				if (typeFact.equals("BL")) {
					commandesId = rset2.getString("Commande_Id");
				}
			}

			PreparedStatement psCommentairesFin = con.prepareStatement("select distinct Commentaires_Fin from "+ base + ".COMMANDE_CLIENT where Commande_Id in ("+commandesId+") order by Date_Commande");
			PreparedStatement psCommentairesInt = con.prepareStatement("select distinct Commentaires_Int from "+ base + ".COMMANDE_CLIENT where Commande_Id in ("+commandesId+") order by Date_Commande");
			PreparedStatement psMentions = con.prepareStatement("select distinct lm.Libelle from "+ base + ".LISTE_MENTIONS lm, "+ base + ".MENTION_COMMANDE_CLIENT mcc where lm.Mention_Id=mcc.Mention_Id and mcc.Commande_Id in ("+commandesId+")");
			PreparedStatement psmodeReg = con.prepareStatement("select distinct Mode_Reg_Id from "+ base + ".COMMANDE_CLIENT where Commande_Id in ("+commandesId+")");

			PreparedStatement psRemiseCommande = con.prepareStatement("select distinct Remise as Remise from "+ base + ".COMMANDE_CLIENT where Commande_Id in ("+commandesId+")");
			PreparedStatement psRemiseFPCommande = con.prepareStatement("select distinct PRemise_FP as PRemise_FP from "+ base + ".COMMANDE_CLIENT where Commande_Id in ("+commandesId+")");

			PreparedStatement psInsMentions = con.prepareStatement("insert into  " + base+ ".MENTION_FACTURE (Mention_Id, Facture_Id) select Mention_Id,? from "+ base + ".MENTION_COMMANDE_CLIENT where Commande_Id in ("+commandesId+")");
			PreparedStatement psInsCommandeFacture = con.prepareStatement("insert into " + base+ ".COMMANDE_CLIENT_FACTURE (Commande_Id, Facture_Id) select Commande_Id,? from " + base+ ".COMMANDE_CLIENT where Commande_Id in ("+commandesId+")");
			PreparedStatement psUpCommandeFacture = con.prepareStatement("update " + base+ ".COMMANDE_CLIENT_FACTURE set Frais_Port=? where Commande_Id=? and Facture_Id=?");

			if (typeFact.equals("GC")) {
				//si tous les responsables pareils -> responsable commande
				PreparedStatement psRespCommandes = con.prepareStatement("select distinct coalesce(Util_R,0) as Util_R from "+ base + ".COMMANDE_CLIENT where Commande_Id in ("+commandesId+")");
				rset2 = psRespCommandes.executeQuery();
				rset2.last();
				if (rset2.getRow()==1) {
					rset2.first();
					responsableId = rset2.getInt("Util_R");					
				}

				PreparedStatement psSecCommandes = con.prepareStatement("select distinct Secteur_Activite from "+ base + ".COMMANDE_CLIENT where Commande_Id in ("+commandesId+")");
				rset2 = psSecCommandes.executeQuery();
				rset2.last();
				if (rset2.getRow()==1) {
					rset2.first();
					secteurActivite = rset2.getString("Secteur_Activite");					
				}
				else if (clientId!=null) {
					psSecRespClient.setString(1,clientId);
					rset2 = psSecRespClient.executeQuery();
					if (rset2.next()) {
						responsableId = rset2.getInt("Util_R");					
					}
				}
			}
			else if (typeFact.equals("GA")) {
				//si tous les responsables affaires pareils -> responsable affaire sinon responsable client
				rset2 = psRespAffaires.executeQuery();
				rset2.last();
				if (rset2.getRow()==1) {
					rset2.first();
					responsableId = rset2.getInt("Util_R");					
				}
				else if (clientId!=null) {
					psSecRespClient.setString(1,clientId);
					rset2 = psSecRespClient.executeQuery();
					if (rset2.next()) {
						responsableId = rset2.getInt("Util_R");					
					}
				}

				PreparedStatement psSecCommandes = con.prepareStatement("select distinct Secteur_Activite from "+ base + ".COMMANDE_CLIENT where Commande_Id in ("+commandesId+")");
				rset2 = psSecCommandes.executeQuery();
				rset2.last();
				if (rset2.getRow()==1) {
					rset2.first();
					secteurActivite = rset2.getString("Secteur_Activite");					
				}
				else if (clientId!=null) {
					psSecRespClient.setString(1,clientId);
					rset2 = psSecRespClient.executeQuery();
					if (rset2.next()) {
						responsableId = rset2.getInt("Util_R");					
					}
				}
				
				psSecCommandes.close();
			}

			rset2 = psCommentairesInt.executeQuery();
			String commentairesInt ="";
			while (rset2.next()) {
				commentairesInt += rset2.getString("Commentaires_Int")+"\n";
			}

			rset2 = psCommentairesFin.executeQuery();
			String commentairesFin ="";
			while (rset2.next()) {
				commentairesFin += rset2.getString("Commentaires_Fin")+"\n";
			}			

			psUtilisateur.setInt(1,responsableId);
			rset2 = psUtilisateur.executeQuery();
			if (rset2.next()) {
				nomResp = rset2.getString("Nom");
				prenomResp = rset2.getString("Prenom");
			} else {
				nomResp = "";
				prenomResp = "";
			}

			echeance = dateFactu;
			if (clientId != null) {
				psFicheClient.setString(1,clientId);
				rset2 = psFicheClient.executeQuery();
				if (rset2.next()) {
					CalcDateEcheance calcEcheance = new CalcDateEcheance(rset2.getString("Type_Reg"), rset2.getInt("Delai_Reg"),rset2.getInt("Jour_Fact"));
					echeance = calcEcheance.getEcheance(dateFactu);
					if (rset2.getInt("Mode_Reg")==0) {
						modeReg = rset2.getInt("Mode_Reg");
					}
				}
			}
			rset2 = psmodeReg.executeQuery();
			rset2.last();
			if (rset2.getRow()==1) {
				rset2.first();
				modeReg = rset2.getInt("Mode_Reg_Id");					
			}

			setTva();

			String listeMentions ="";

			rset2 = psMentions.executeQuery();
			while (rset2.next()) {
				listeMentions += rset2.getString("Libelle")+"\n";
			}
			int posparam = 1;
			psInsFacture.setInt(posparam++, 0);
			psInsFacture.setInt(posparam++, 0);
			psInsFacture.setInt(posparam++, 0);
			psInsFacture.setString(posparam++, "non gnr");
			psInsFacture.setString(posparam++, commentairesFin);
			psInsFacture.setString(posparam++, commentairesInt);
			psInsFacture.setString(posparam++, "");
			psInsFacture.setString(posparam++, nomResp);
			psInsFacture.setString(posparam++, prenomResp);
			psInsFacture.setInt(posparam++, civInter); // 10?
			psInsFacture.setString(posparam++, nomInter);
			psInsFacture.setString(posparam++, prenomInter);
			psInsFacture.setString(posparam++, telInter);
			psInsFacture.setString(posparam++, faxInter);
			psInsFacture.setString(posparam++, emailInter);
			if (clientId!=null) {
				psInsFacture.setString(posparam++, clientId);
			}
			else {
				psInsFacture.setNull(posparam++, java.sql.Types.VARCHAR);
			}
			psInsFacture.setString(posparam++, denomination);
			psInsFacture.setString(posparam++, adresse1Fact);
			psInsFacture.setString(posparam++, adresse2Fact);
			psInsFacture.setString(posparam++, adresse3Fact); //20
			psInsFacture.setString(posparam++, cpFact);
			psInsFacture.setString(posparam++, villeFact);
			psInsFacture.setString(posparam++, codePaysFact);
			psInsFacture.setString(posparam++, denominationLiv);
			psInsFacture.setString(posparam++, adresse1Liv);
			psInsFacture.setString(posparam++, adresse2Liv);
			psInsFacture.setString(posparam++, adresse3Liv);
			psInsFacture.setString(posparam++, cpLiv);
			psInsFacture.setString(posparam++, villeLiv);
			psInsFacture.setString(posparam++, codePaysLiv); //30
			psInsFacture.setInt(posparam++, civInterLiv);
			psInsFacture.setString(posparam++, nomInterLiv);
			psInsFacture.setString(posparam++, prenomInterLiv);
			psInsFacture.setString(posparam++, telInterLiv);
			psInsFacture.setString(posparam++, faxInterLiv);
			psInsFacture.setString(posparam++, emailInterLiv);
			psInsFacture.setString(posparam++, denominationEnvoi);
			psInsFacture.setString(posparam++, adresse1Envoi);
			psInsFacture.setString(posparam++, adresse2Envoi);
			psInsFacture.setString(posparam++, adresse3Envoi); //40
			psInsFacture.setString(posparam++, cpEnvoi);
			psInsFacture.setString(posparam++, villeEnvoi);
			psInsFacture.setString(posparam++, codePaysEnvoi);
			psInsFacture.setInt(posparam++, civInterEnvoi);
			psInsFacture.setString(posparam++, nomInterEnvoi);
			psInsFacture.setString(posparam++, prenomInterEnvoi);
			psInsFacture.setString(posparam++, telInterEnvoi);
			psInsFacture.setString(posparam++, faxInterEnvoi);
			psInsFacture.setString(posparam++, emailInterEnvoi);
			psInsFacture.setInt(posparam++, user); //50
			psInsFacture.setInt(posparam++, user);
			psInsFacture.setLong(posparam++, now);
			psInsFacture.setLong(posparam++, now);
			psInsFacture.setDouble(posparam++, escompte);
			psInsFacture.setDouble(posparam++, 0);
			psInsFacture.setDouble(posparam++, 0);
			psInsFacture.setString(posparam++, listeMentions);
			psInsFacture.setDouble(posparam++, fraisPort);
			psInsFacture.setDouble(posparam++, 0);
			psInsFacture.setDouble(posparam++, 0); //60
			psInsFacture.setDouble(posparam++, 0);
			psInsFacture.setDouble(posparam++, 0);
			psInsFacture.setDouble(posparam++, 0);
			if (responsableId!=0) {
				psInsFacture.setInt(posparam++, responsableId);
			}
			else {
				psInsFacture.setNull(posparam++, java.sql.Types.INTEGER);
			}
			psInsFacture.setInt(posparam++, assujettiTVA?1:0);
			psInsFacture.setString(posparam++, numTVAIntra);
			psInsFacture.setDouble(posparam++, tauxTVA);
			psInsFacture.setInt(posparam++, editionTTC?1:0);
			psInsFacture.setString(posparam++, regimeTVA);
			psInsFacture.setString(posparam++, modeEnvoi); //70
			psInsFacture.setLong(posparam++, (modeEnvoi=="M" || moduleEnvoi==1)?0: now);
			psInsFacture.setInt(posparam++, codeTVA);
			psInsFacture.setString(posparam++, secteurActivite);
			psInsFacture.executeUpdate();
			ResultSet rsnum = psInsFacture.getGeneratedKeys();

			if (rsnum.next()) {
				factureId = rsnum.getInt(1);
			}			

			psInsCommandeFacture.setInt(1, factureId);
			psInsCommandeFacture.executeUpdate();

			PreparedStatement psSelCommandes = con.prepareStatement("select Commande_Id, Soldee, Frais_Port_Prem, Frais_Port, PRemise_FP  from "  + base+ ".COMMANDE_CLIENT cc join " + base+ ".AFFAIRE a on cc.Affaire_Id=a.Affaire_Id where Commande_Id in ("+commandesId+")");
			rset = psSelCommandes.executeQuery();
			mRemise_FP=0;
			while (rset.next()) {
				double fraisPortCom=0;
				if ((rset.getInt("Frais_Port_Prem")==1) || (modeFacturation.equals("C"))) {
					PreparedStatement psSelCommandefacture = con.prepareStatement("select coalesce(sum(Frais_Port),0) as Frais from " + base+ ".COMMANDE_CLIENT_FACTURE ccf where Commande_Id="+rset.getInt("Commande_Id"));
					rset2 = psSelCommandefacture.executeQuery();
					if (rset2.next()) {
						fraisPortCom += rset.getDouble("Frais_Port") - rset2.getDouble("Frais");
						mRemise_FP += fraisPortCom * rset.getDouble("PRemise_FP")/100;
					}
				}
				else if (rset.getInt("Soldee")==1) {
					fraisPortCom += rset.getDouble("Frais_Port");
					mRemise_FP += fraisPortCom * rset.getDouble("PRemise_FP")/100;
				}

				fraisPort += fraisPortCom;
				psUpCommandeFacture.setDouble(1,fraisPortCom);
				psUpCommandeFacture.setInt(2, rset.getInt("Commande_Id"));
				psUpCommandeFacture.setInt(3, factureId);
				psUpCommandeFacture.executeUpdate();
			}

			psInsMentions.setInt(1, factureId);
			psInsMentions.executeUpdate();

			PreparedStatement psInsAffaireFacture = con.prepareStatement("insert into " + base+ ".AFFAIRE_FACTURE (Affaire_Id, Facture_Id) select Affaire_Id,? from "+ base+ ".COMMANDE_CLIENT where Commande_Id in ("+commandesId+")");
			psInsAffaireFacture.setInt(1, factureId);
			psInsAffaireFacture.executeUpdate();

			if (modeFacturation.equals("E")) {
				psInsBonLivraisonFacture.setInt(1, factureId);
				psInsBonLivraisonFacture.executeUpdate();
				rset = psBonsLivraison.executeQuery();
				int i=0;
				while (rset.next()) {
					PreparedStatement psselBonArticleFacture =  con.prepareStatement(" select ab.Ligne_Id as Ligne_BL,lcc.Ligne_Id, sum(ab.Quantite) - sum(coalesce(lf.Quantite,0)) as Quantite, lcc.Reference, lcc.Designation, lcc.Type_Ligne,lcc.Prix_Unitaire, lcc.Ristourne, t.Taux_TVA, t.Code_TVA," +
							" lcc.Commentaire_Apres, lcc.Commentaire_Avant, lcc.Libelle, lcc.Code_Stats, lcc.Unite, ab.Nb_Pieces, ab.Num_Lot, ab.Date_Peremption, lcc.Commission" +
							" from " + base+ ".LIGNE_COMMANDE_CLIENT lcc, " + base+ ".TAUX_TVA t, " + base+ ".LIGNE_BON_LIVRAISON ab" +
							" left join (select Ref_Ligne, lf.Quantite from " + base+ ".BON_LIVRAISON_FACTURE blf join " + base+ ".LIGNE_FACTURE lf on blf.Facture_Id=lf.Facture_Id and Bon_Id in ("+rset.getString("bons")+")) as lf on ab.Ref_Ligne=lf.Ref_Ligne where" +
							" ab.Statut='V' and ab.Ligne_Id not in (select Ligne_Id from " + base+ ".CODE_PRODUIT_LIGNE_BL) and t.Code_TVA=lcc.Code_TVA and ab.Ref_Ligne=lcc.Ligne_Id and lcc.Statut='V' and ab.Bon_Id in ("+rset.getString("bons")+")" +
							" group by lcc.Ligne_Id having sum(ab.Quantite) - sum(coalesce(lf.Quantite,0))>0" +
							" union " +
							"  select ab.Ligne_Id as Ligne_BL,lcc.Ligne_Id, count(cp.Numero) as Quantite, lcc.Reference, lcc.Designation, lcc.Type_Ligne,lcc.Prix_Unitaire, lcc.Ristourne, t.Taux_TVA, t.Code_TVA," +
							" lcc.Commentaire_Apres, lcc.Commentaire_Avant, lcc.Libelle, lcc.Code_Stats, lcc.Unite, ab.Nb_Pieces, ab.Num_Lot, ab.Date_Peremption, lcc.Commission" +
							" from " + base+ ".LIGNE_COMMANDE_CLIENT lcc, " + base+ ".TAUX_TVA t, " + base+ ".LIGNE_BON_LIVRAISON ab join " + base+ ".CODE_PRODUIT_LIGNE_BL cplb on ab.Ligne_Id=cplb.Ligne_Id" +
							" join " + base+ ".CODE_PRODUIT cp on cplb.Produit_Id=cp.Produit_Id, " + base+ ".BON_LIVRAISON b" +
							" where cp.Facture=0 and Active=1 and t.Code_TVA=lcc.Code_TVA and ab.Ref_Ligne=lcc.Ligne_Id and ab.Bon_Id=b.Bon_Id and lcc.Statut='V' and ab.Statut='V' and b.Bon_Id in ("+rset.getString("bons")+")"+ decoche +
					" group by lcc.Ligne_Id having count(cp.Numero)>0");

					rset2 = psselBonArticleFacture.executeQuery();
					while (rset2.next()) {
						i++;
						psInsArticleFacture.setInt(1, factureId);
						psInsArticleFacture.setInt(2, i);
						psInsArticleFacture.setInt(3, rset2.getInt("Ligne_Id"));
						psInsArticleFacture.setDouble(4, rset2.getDouble("Quantite"));
						psInsArticleFacture.setString(5, rset2.getString("Reference"));
						psInsArticleFacture.setString(6, rset2.getString("Designation"));
						psInsArticleFacture.setString(7, rset2.getString("Type_Ligne"));
						psInsArticleFacture.setDouble(8, rset2.getDouble("Prix_Unitaire"));
						psInsArticleFacture.setDouble(9, rset2.getDouble("Ristourne"));
						if (assujettiTVA && !codePaysLiv.equals(rset.getString("Code_Pays_Liv_Commande"))) {
							psInsArticleFacture.setDouble(10, tauxTVA);
							psInsArticleFacture.setInt(11, codeTVA);
						}
						else {
							psInsArticleFacture.setDouble(10, rset2.getDouble("Taux_TVA"));
							psInsArticleFacture.setInt(11, rset2.getInt("Code_TVA"));
						}

						psInsArticleFacture.setString(12, rset2.getString("Commentaire_Apres"));
						psInsArticleFacture.setString(13, rset2.getString("Commentaire_Avant"));
						psInsArticleFacture.setString(14, rset2.getString("Libelle"));
						psInsArticleFacture.setString(15, rset2.getString("Code_Stats"));
						psInsArticleFacture.setString(16, rset2.getString("Unite"));
						psInsArticleFacture.setString(17, rset2.getString("Nb_Pieces"));
						psInsArticleFacture.setString(18, rset2.getString("Num_Lot"));
						psInsArticleFacture.setLong(19, rset2.getLong("Date_Peremption"));
						psInsArticleFacture.setDouble(20, rset2.getDouble("Commission"));
						psInsArticleFacture.executeUpdate();

						ResultSet rsnumaf = psInsArticleFacture.getGeneratedKeys();

						if (rsnumaf.next()) {
							ligneFacture = rsnumaf.getInt(1);
						}


						PreparedStatement psinsCodeProduitFC =  con.prepareStatement("insert into " + base+ ".CODE_PRODUIT_LIGNE_FC (Ligne_Id,Produit_Id)" +
								" select "+ligneFacture+", cplb.Produit_Id from " + base+ ".LIGNE_BON_LIVRAISON lbl join " + base+ ".CODE_PRODUIT_LIGNE_BL cplb on lbl.Ligne_Id=cplb.Ligne_Id join " + base+ ".CODE_PRODUIT cp on cplb.Produit_Id=cp.Produit_Id" +
								" where cp.Facture=0 and Active=1 and lbl.Statut='V' and lbl.Ligne_Id in ("+rset2.getInt("Ligne_BL")+")"+ decoche);
						psinsCodeProduitFC.executeUpdate();
						
						psinsCodeProduitFC.close();
					}
					
					psselBonArticleFacture.close();
				}

				PreparedStatement psSelCommandeBonRemise = con.prepareStatement("select Escompte, if (Edition_TTC=1,(Frais_Port*(1+ PRemise_FP/100)), (Frais_Port*(1+ PRemise_FP/100))* (1+ Taux_TVA_Port/100)) as frais, if (Edition_TTC=1,sum(abl.Quantite * (Prix_Unitaire - (Prix_Unitaire * (Ristourne/100)))),sum((1+ Taux_TVA/100)*(abl.Quantite * (Prix_Unitaire - (Prix_Unitaire * (Ristourne/100)))))*(1+Remise/100)) as sum_articles, sum(abl.Quantite * (Prix_Unitaire - (Prix_Unitaire * (Ristourne/100))))*Remise/100 as Montant_Remise from " + base+ ".COMMANDE_CLIENT cc join " + base+ ".BON_LIVRAISON bl on cc.Commande_Id=bl.Commande_Id join " + base+ ".LIGNE_BON_LIVRAISON abl on bl.Bon_Id=abl.Bon_Id and abl.Statut='V' join " + base+ ".LIGNE_COMMANDE_CLIENT acc on abl.Ref_Ligne=acc.Ligne_Id where bl.Commande_Id in ("+commandesId+") group by bl.Commande_Id");
				rset2 = psSelCommandeBonRemise.executeQuery();
				while (rset2.next()) {
					montantRemise += rset2.getDouble("Montant_Remise");
					totalTTC += rset2.getDouble("sum_articles")-rset2.getDouble("frais");
					mEscompte += totalTTC*rset2.getDouble("Escompte")/100;
				}
				
				psSelCommandeBonRemise.close();
			}
			else {
				//A FAIRE PROBLEME QUANTITE
				PreparedStatement psselBonArticleFacture =  con.prepareStatement(" select a.Ligne_Id, sum(a.Quantite) as Quantite, a.Reference, a.Designation, a.Type_Ligne,a.Prix_Unitaire, a.Ristourne, t.Taux_TVA, t.Code_TVA," +
						" a.Commentaire_Apres, a.Commentaire_Avant, a.Libelle, a.Code_Stats, a.Unite, a.Nb_Pieces, a.Num_Lot, a.Date_Peremption, a.Commission" +
						" from " + base+ ".LIGNE_COMMANDE_CLIENT a, " + base+ ".TAUX_TVA t" +
						" where t.Code_TVA=a.Code_TVA and a.Statut='V' and a.Commande_Id in ("+commandesId+") group by a.Ligne_Id");
				rset2 = psselBonArticleFacture.executeQuery();
				int i=0;
				while (rset2.next()) {
					i++;
					psInsArticleFacture.setInt(1, factureId);
					psInsArticleFacture.setInt(2, i);
					psInsArticleFacture.setInt(3, rset2.getInt("Ligne_Id"));
					psInsArticleFacture.setDouble(4, rset2.getDouble("Quantite"));
					psInsArticleFacture.setString(5, rset2.getString("Reference"));
					psInsArticleFacture.setString(6, rset2.getString("Designation"));
					psInsArticleFacture.setString(7, rset2.getString("Type_Ligne"));
					psInsArticleFacture.setDouble(8, rset2.getDouble("Prix_Unitaire"));
					psInsArticleFacture.setDouble(9, rset2.getDouble("Ristourne"));
					psInsArticleFacture.setDouble(10, rset2.getDouble("Taux_TVA"));
					psInsArticleFacture.setInt(11, rset2.getInt("Code_TVA"));
					psInsArticleFacture.setString(12, rset2.getString("Commentaire_Apres"));
					psInsArticleFacture.setString(13, rset2.getString("Commentaire_Avant"));
					psInsArticleFacture.setString(14, rset2.getString("Libelle"));
					psInsArticleFacture.setString(15, rset2.getString("Code_Stats"));
					psInsArticleFacture.setString(16, rset2.getString("Unite"));
					psInsArticleFacture.setString(17, rset2.getString("Nb_Pieces"));
					psInsArticleFacture.setString(18, rset2.getString("Num_Lot"));
					psInsArticleFacture.setLong(19, rset2.getLong("Date_Peremption"));
					psInsArticleFacture.setDouble(20, rset2.getDouble("Commission"));
					psInsArticleFacture.executeUpdate();
				}
				
				psselBonArticleFacture.close();

				PreparedStatement psSelCommandeRemise = con.prepareStatement("select Escompte, if (Edition_TTC=1,(Frais_Port*(1+ PRemise_FP/100)), (Frais_Port*(1+ PRemise_FP/100))* (1+ Taux_TVA_Port/100)) as frais, if (Edition_TTC=1,sum(Quantite * (Prix_Unitaire - (Prix_Unitaire * (Ristourne/100)))),sum((1+ Taux_TVA/100)*(Quantite * (Prix_Unitaire * (1+ (Ristourne/100)))))*(1+Remise/100)) as sum_articles, sum(Quantite * (Prix_Unitaire * (1+(Ristourne/100))))*Remise/100 as Montant_Remise from " + base+ ".COMMANDE_CLIENT cc join " + base+ ".LIGNE_COMMANDE_CLIENT acc on acc.Commande_Id=cc.Commande_Id and acc.Statut='V' where cc.Commande_Id in ("+commandesId+") group by cc.Commande_Id");
				rset2 = psSelCommandeRemise.executeQuery();
				while (rset2.next()) {
					montantRemise += rset2.getDouble("Montant_Remise");
					totalTTC += rset2.getDouble("sum_articles")-rset2.getDouble("frais");
					mEscompte += totalTTC*rset2.getDouble("Escompte")/100;
				}
				
				psSelCommandeRemise.close();
			}

			rset2 = psRemiseCommande.executeQuery();
			rset2.last();
			if (rset2.getRow()==1) {
				rset2.first();
				remise = rset2.getDouble("Remise");					
			}
			rset2 = psRemiseFPCommande.executeQuery();
			rset2.last();
			if (rset2.getRow()==1) {
				rset2.first();
				pRemise_FP = rset2.getDouble("PRemise_FP");					
			}

			psUpFactureTotaux.setDouble(1, fraisPort);
			psUpFactureTotaux.setDouble(2, 0);
			psUpFactureTotaux.setDouble(3, mRemise_FP);
			psUpFactureTotaux.setDouble(4, 0);
			psUpFactureTotaux.setDouble(5, montantRemise);
			psUpFactureTotaux.setDouble(6, 0);
			psUpFactureTotaux.setInt(7, factureId);
			psUpFactureTotaux.executeUpdate();

			Calcul calc = new Calcul (s_session,factureId,"Facture");
			calc.majTotaux();

			psUpFactureTotauxRemise.setDouble(1, (pRemise_FP>0)?pRemise_FP:calc.getPRemise_FPCalcul());
			psUpFactureTotauxRemise.setDouble(2, 0);
			psUpFactureTotauxRemise.setDouble(3, (remise>0)?remise:calc.getRemisePCalcul());
			psUpFactureTotauxRemise.setDouble(4, 0);
			psUpFactureTotauxRemise.setInt(5, factureId);
			psUpFactureTotauxRemise.executeUpdate();

			Calcul calc2 = new Calcul (s_session,factureId,"Facture");
			calc2.majTotaux();

			psUpFactureTotauxEscompte.setDouble(1, (calc2.getMontantTTC()>0)?r3.round((mEscompte*100)/calc2.getMontantTTC()):0);
			psUpFactureTotauxEscompte.setInt(2, factureId);
			psUpFactureTotauxEscompte.executeUpdate();
			
			calculerAcompteFacture(factureId);

			Calcul calc3 = new Calcul (s_session,factureId,"Facture");
			calc3.majTotaux();
			
			psInsEcheanceFacture.setInt(1, factureId);
			psInsEcheanceFacture.setInt(2, modeReg);
			psInsEcheanceFacture.setLong(3, echeance);
			psInsEcheanceFacture.setDouble(4,calc3.getMontantNet()>0?calc3.getMontantNet():0);
			psInsEcheanceFacture.executeUpdate();
			
			psCommentairesFin.close();
			psCommentairesInt.close();
			psMentions.close();
			psmodeReg.close();
			psRemiseCommande.close();
			psRemiseFPCommande.close();
			psInsMentions.close();
			psInsCommandeFacture.close();
			psUpCommandeFacture.close(); 
			
			psRespAffaires.close();
			psSecRespClient.close();
			psAffaire.close();
			psBonCommande.close();
			psUtilisateur.close();
			psFicheClient.close();
			psInsAffaireFacture.close();
			psBonsLivraison.close();
			
			psInsEcheanceFacture.close();
			psUpFactureTotaux.close();
			psUpFactureTotauxRemise.close();
			psUpFactureTotauxEscompte.close();
			psInsArticleFacture.close();
			psInsBonLivraisonFacture.close(); 
			psCommande.close();
			psInsFacture.close();

			return factureId;
			
		} catch (Exception e) {
			e.printStackTrace();
			return 0;
		}
	}


	public void validerFacture(int factureId) {
		try {

			ResultSet rset;
			ResultSet rset2;

			PreparedStatement psFacture = con.prepareStatement("select f.*,coalesce(Taxe_Arrivee,0) as Taxe_Arrivee from "+ base + ".FACTURE f left join "+ base + ".OPTION_TAXATION ot on f.Code_Pays_Liv=ot.Code_Pays where Facture_Id=? and Numero=0");
			PreparedStatement psEcoTaxe = con.prepareStatement("select coalesce(sum(f.Eco_Taxe * a.Quantite), 0) as Eco_Taxe from "+ base + ".LIGNE_FACTURE a, "+ base + ".FICHE_ARTICLE f where a.Reference=f.Article_Id and a.Type_Ligne='S' and a.Facture_Id=?");
			PreparedStatement psUpFacture = con.prepareStatement("update "+ base + ".FACTURE set Date_Edition_Auto=?,Numero=?, Date_Facture=?, Num_Unique=?, Num_Entier=?, Eco_Taxe=?, TVA_Liv=? where Facture_Id=?");

			PreparedStatement psBonLivraisonFacture = con.prepareStatement("select group_concat(blf.Bon_Id) as Bon_Id from "+ base + ".FACTURE f left join "+ base + ".BON_LIVRAISON_FACTURE blf on f.Facture_Id=blf.Facture_Id where blf.Bon_Id is not null and f.Facture_Id=? group by f.Facture_Id");

			PreparedStatement psDelMentions = con.prepareStatement("delete from "+ base + ".MENTION_FACTURE where Facture_Id=?");
			PreparedStatement psDelComMentions = con.prepareStatement("delete from "+ base + ".MENTION_COMMANDE_CLIENT where Commande_Id=?");

			PreparedStatement psEcheanceFacture = con.prepareStatement("select * from "+ base + ".ECHEANCE_FACTURE_CLIENT where Facture_Id=?");

			PreparedStatement psInsEcheance = con.prepareStatement("insert into "+ base + ".ECHEANCE_CLIENT (Date_Echeance, Echeance_Initiale, Client_Id, Denomination, Montant, Montant_Restant, Mode_Reg_Id, Etat) values (?,?,?,?,?,?,?,?)");
			
			PreparedStatement psMaxEcheance = con.prepareStatement("select max(Echeance_Id) as max from "+ base +".ECHEANCE_CLIENT");
			PreparedStatement psInsFactEcheance = con.prepareStatement("insert into "+ base +".FACTURE_ECHEANCE_CLIENT (Echeance_Id, Facture_Id) values (?,?)");

			PreparedStatement psReglements = con.prepareStatement("select rc.Reglement_Id, rc.Montant_Restant from "+ base +".REGLEMENT_CLIENT rc join "+ base +".COMMANDE_CLIENT_FACTURE ccf on rc.Commande_Id=ccf.Commande_Id"+
			" where ccf.Facture_Id=? and rc.Statut='C' and rc.Etat in ('N','P')");
			PreparedStatement psFactEcheance = con.prepareStatement("select ec.Echeance_Id, ec.Montant_Restant from "+ base +".ECHEANCE_CLIENT ec"
			+ " join "+ base +".FACTURE_ECHEANCE_CLIENT fec on ec.Echeance_Id=fec.Echeance_Id where fec.Facture_Id=? and ec.Etat in ('N','P')");
			PreparedStatement psInsImputationEchFact = con.prepareStatement("insert into "+ base +".IMPUTATION_ECHEANCE_CLIENT (Echeance_Id, Montant, Date_Imputation) values (?,?,?)");
			PreparedStatement psMaxImputationEchFact = con.prepareStatement("select max(Imputation_Id) as max from "+ base +".IMPUTATION_ECHEANCE_CLIENT where Echeance_Id=?");
			PreparedStatement psInsEchReglement = con.prepareStatement("insert into "+ base +".IMPUTATION_ECHEANCE_REGLEMENT_CLIENT (Imputation_Id, Reglement_Id) values (?,?)");
			PreparedStatement psMajEcheance = con.prepareStatement("update "+ base +".ECHEANCE_CLIENT set Montant_Restant=?, Etat=? where Echeance_Id=?");
			PreparedStatement psMajReglement = con.prepareStatement("update "+ base +".REGLEMENT_CLIENT set Montant_Restant=?, Etat=?, Statut=? where Reglement_Id=?");
			
			PreparedStatement psUpFactureeCommandeClient = con.prepareStatement("update "+ base + ".COMMANDE_CLIENT cc join "+ base + ".COMMANDE_CLIENT_FACTURE ccf on cc.Commande_Id=ccf.Commande_Id set Facturee=1 where Facture_Id=?");
			PreparedStatement psUpFactureeCommandeClientBL = con.prepareStatement("update "+ base + ".COMMANDE_CLIENT cc join "+ base + ".COMMANDE_CLIENT_FACTURE ccf on cc.Commande_Id=ccf.Commande_Id left join "+ base + ".BON_LIVRAISON bl on cc.Commande_Id=bl.Commande_Id and bl.Etat='V' and bl.Facture=0 set cc.Facturee=1 where bl.Bon_Id is null and ccf.Facture_Id=? and cc.Soldee=1");
			PreparedStatement psUpClotureCommandeClient = con.prepareStatement("update "+ base + ".COMMANDE_CLIENT cc join "+ base +".AFFAIRE a on cc.Affaire_Id=a.Affaire_Id join "+ base + ".COMMANDE_CLIENT_FACTURE ccf on cc.Commande_Id=ccf.Commande_Id set cc.Etat='C' where ccf.Facture_Id=? and cc.Facturee=1 and (cc.Soldee=1 or a.Sans_Livraison=1)");

			PreparedStatement psInsBonLivraisonFacture = con.prepareStatement("insert into " + base+ ".BON_LIVRAISON_FACTURE (Bon_Id, Facture_Id) select distinct Bon_Id,Facture_Id from "+ base + ".LIGNE_FACTURE lf join "+ base + ".IMPUTATION_LIGNE_BL_FC ilbf on lf.Ligne_Id=ilbf.Ref_Ligne_FC join "+ base + ".LIGNE_BON_LIVRAISON lbl on lbl.Ligne_Id=ilbf.Ref_Ligne_BL where Facture_Id=? and lbl.Statut='V'");

			PreparedStatement psAffaireFacture = con.prepareStatement("select group_concat(af.Affaire_Id) as Affaire_Id from "+ base + ".FACTURE f join "+ base + ".AFFAIRE_FACTURE af on f.Facture_Id=af.Facture_Id where af.Affaire_Id is not null and f.Facture_Id=? group by f.Facture_Id");

			PreparedStatement psinsCodeProduitBL =  con.prepareStatement("update " + base+ ".FACTURE f join " + base + ".LIGNE_FACTURE lf on f.Facture_Id=lf.Facture_Id join " + base+ ".CODE_PRODUIT_LIGNE_BL cplb on lf.Ligne_Id=cplb.Ligne_Id join " + base+ ".CODE_PRODUIT cp on cplb.Produit_Id=cp.Produit_Id" +
			" set cp.Facture=1 where cp.Facture=0 and Active=1 and f.Facture_Id=?");

			psFacture.setInt(1,factureId);
			rset = psFacture.executeQuery();
			if (rset.next()) {

				psEcoTaxe.setInt(1,factureId);
				rset2 = psEcoTaxe.executeQuery();
				if (rset2.next()) {
					ecoTaxe = rset2.getDouble("Eco_Taxe");
				}
				rset2.close();

				GenDocNumber gdn = new GenDocNumber(dateFactu,s_session);
				numEntier = gdn.getNumeroFacture();
				numero = gdn.getNumeroPeriode();
				numUnique = gdn.getNumUnique();

				psUpFacture.setLong(1,dateEditionAuto);
				psUpFacture.setInt(2,numero);
				psUpFacture.setLong(3,dateFactu);
				psUpFacture.setInt(4,numUnique);
				psUpFacture.setString(5,numEntier);
				psUpFacture.setDouble(6,ecoTaxe);
				psUpFacture.setInt(7,rset.getInt("Taxe_Arrivee"));
				psUpFacture.setInt(8,factureId);
				psUpFacture.executeUpdate();

				psDelMentions.setInt(1,factureId);
				psDelMentions.executeUpdate();

				psEcheanceFacture.setInt(1, factureId);
				rset2 = psEcheanceFacture.executeQuery();
				while (rset2.next()) {
					psInsEcheance.setLong(1, rset2.getLong("Date_Echeance"));
					psInsEcheance.setLong(2, rset2.getLong("Date_Echeance"));
					if (rset.getString("Client_Id")!=null && rset.getString("Client_Id").equals("")) {
						psInsEcheance.setNull(3, java.sql.Types.VARCHAR);
					}
					else {
						psInsEcheance.setString(3, rset.getString("Client_Id"));
					}
					psInsEcheance.setString(4, rset.getString("Denomination"));
					psInsEcheance.setDouble(5, rset2.getDouble("Montant"));
					psInsEcheance.setDouble(6, rset2.getDouble("Montant"));
					psInsEcheance.setInt(7, rset2.getInt("Mode_Reg_Id"));
					psInsEcheance.setString(8, rset2.getDouble("Montant")>0?"N":"T");
					psInsEcheance.executeUpdate();
					
					rset3 = psMaxEcheance.executeQuery();
					rset3.next();
					int echeanceId = rset3.getInt("max");
					rset3.close();
					psInsFactEcheance.setInt(1, echeanceId);
					psInsFactEcheance.setInt(2, factureId);
					psInsFactEcheance.executeUpdate();
				}
				rset2.close();
				
				String listeId = "";
				psReglements.setInt(1, factureId);
				psFactEcheance.setInt(1, factureId);
				rset2 = psReglements.executeQuery();
				while (rset2.next()) {
					int reglementId = rset2.getInt("Reglement_Id");
					double montantRegRestant = rset2.getDouble("Montant_Restant");
					
					rset3 = psFactEcheance.executeQuery();
					while (montantRegRestant>0 && rset3.next()) {
						int echeanceId = rset3.getInt("Echeance_Id");
						listeId += echeanceId+",";
						double montantEchRestant = rset3.getDouble("Montant_Restant");
						double imputation = (montantRegRestant>montantEchRestant?montantEchRestant:montantRegRestant);
						montantEchRestant -= imputation;
						montantRegRestant -= imputation;
						String etatEch = (montantEchRestant==0?"T":"P");
						psInsImputationEchFact.setInt(1, echeanceId);
						psInsImputationEchFact.setDouble(2, imputation);
						psInsImputationEchFact.setLong(3, now);
						psInsImputationEchFact.executeUpdate();
						
						psMaxImputationEchFact.setInt(1, echeanceId);
						rset4 = psMaxImputationEchFact.executeQuery();
						rset4.next();
						int imputationId = rset4.getInt("max");
						rset4.close();
						psInsEchReglement.setInt(1, imputationId);
						psInsEchReglement.setInt(2, reglementId);
						psInsEchReglement.executeUpdate();
						
						psMajEcheance.setDouble(1, montantEchRestant);
						psMajEcheance.setString(2, etatEch);
						psMajEcheance.setInt(3, echeanceId);
						psMajEcheance.executeUpdate();
					}
					rset3.close();
					String etatReg = (montantRegRestant==0?"T":"P");
					String statutReg = (montantRegRestant==0?"V":"C");
					
					psMajReglement.setDouble(1, montantRegRestant);
					psMajReglement.setString(2, etatReg);
					psMajReglement.setString(3, statutReg);
					psMajReglement.setInt(4, reglementId);
					psMajReglement.executeUpdate();
				}
				rset2.close();
				
				if (!listeId.equals("")) {
					MajStatutCommandes majStatut = new MajStatutCommandes(this.s_session);
					majStatut.traiterEcheances(listeId);
					majStatut.terminer();
				}
				
				psinsCodeProduitBL.setInt(1,factureId);
				psinsCodeProduitBL.executeUpdate();

				psBonLivraisonFacture.setInt(1,factureId);
				rset2 = psBonLivraisonFacture.executeQuery();
								
				if (rset2.next()) {
					//IMPUTATION_LIGNE_BL_FC Factures dj lies a un BL
					PreparedStatement psSelLigneFacture = con.prepareStatement("select Bon_Id,lf.Facture_Id,lf.Ligne_Id, lf.Ref_Ligne, Quantite from "+ base + ".LIGNE_FACTURE lf join "+ base + ".BON_LIVRAISON_FACTURE blf on lf.Facture_Id=blf.facture_Id where lf.Facture_Id=? order by Rank");

					PreparedStatement psSelLigneBonLivraisonFacture = con.prepareStatement("select Ligne_Id, Quantite from "+ base + ".LIGNE_BON_LIVRAISON lbl join "+ base + ".BON_LIVRAISON bl on bl.Bon_Id=lbl.Bon_Id where Etat='V' and lbl.Statut='V' and bl.Bon_Id=?");

					PreparedStatement psInsImputeLigneBLFacture = con.prepareStatement("insert into "+ base + ".IMPUTATION_LIGNE_BL_FC (Ref_Ligne_BL, Ref_Ligne_FC, Quantite) values (?, ?, ?)");

					psSelLigneFacture.setInt(1, factureId);
					rset3 = psSelLigneFacture.executeQuery();
					while(rset3.next()) {
						psSelLigneBonLivraisonFacture.setInt(1, rset3.getInt("Bon_Id"));
						rset4 = psSelLigneBonLivraisonFacture.executeQuery();
						while(rset4.next()) {
							quantiteLivree=rset4.getDouble("Quantite");
							if (quantiteLivree>0) {
								psInsImputeLigneBLFacture.setInt(1, rset4.getInt("Ligne_Id"));
								psInsImputeLigneBLFacture.setInt(2, rset3.getInt("Ligne_Id"));
								psInsImputeLigneBLFacture.setDouble(3, quantiteLivree);
								psInsImputeLigneBLFacture.executeUpdate();
							}
						}
						rset4.close();
					}
					rset3.close();

					PreparedStatement psUpFactureBonLivraison = con.prepareStatement("update "+ base + ".BON_LIVRAISON set Facture=1 where Bon_Id in ("+rset2.getString("Bon_Id")+") and Bon_Id not in (select Bon_Id from "+ base + ".LIGNE_BON_LIVRAISON lbl join "+ base + ".CODE_PRODUIT_LIGNE_BL cplb on lbl.Ligne_Id=cplb.Ligne_Id join "+ base + ".CODE_PRODUIT cp on cplb.Produit_Id=cp.Produit_Id where cp.Facture=0 and lbl.Statut='V')");
					psUpFactureBonLivraison.executeUpdate();
					
					psUpFactureBonLivraison.close();
					psSelLigneFacture.close(); 
					psSelLigneBonLivraisonFacture.close();
					psInsImputeLigneBLFacture.close();
				}
				else {

					PreparedStatement psSelLigneFacture = con.prepareStatement("select Ligne_Id, Ref_Ligne, Quantite from "+ base + ".LIGNE_FACTURE where Facture_Id=? order by Rank");

					PreparedStatement psSelLigneBonLivraisonFacture = con.prepareStatement("select Ligne_Id, Quantite from "+ base + ".LIGNE_BON_LIVRAISON lbl join "+ base + ".BON_LIVRAISON bl on bl.Bon_Id=lbl.Bon_Id where Ref_Ligne=? and Facture!=1 and Etat='V' and lbl.Statut='V' order by Date_Liv");

					PreparedStatement psSelLigneImputBonLivraisonFacture = con.prepareStatement("select sum(Quantite) as Quantite from "+ base + ".IMPUTATION_LIGNE_BL_FC ilbf where Ref_Ligne_BL=?");

					PreparedStatement psInsImputeLigneBLFacture = con.prepareStatement("insert into "+ base + ".IMPUTATION_LIGNE_BL_FC (Ref_Ligne_BL, Ref_Ligne_FC, Quantite) values (?, ?, ?)");


					//Insere IMPUTATION_LIGNE_BL_FC
					psSelLigneFacture.setInt(1,factureId);
					rset3 = psSelLigneFacture.executeQuery();
					while(rset3.next()) {
						quantiteFacturee=rset3.getDouble("Quantite");
						psSelLigneBonLivraisonFacture.setInt(1, rset3.getInt("Ref_Ligne"));
						rset4 = psSelLigneBonLivraisonFacture.executeQuery();
						while (rset4.next() && quantiteFacturee>0) {
							quantiteLivree=rset4.getDouble("Quantite");
							psSelLigneImputBonLivraisonFacture.setInt(1, rset4.getInt("Ligne_Id"));
							rset5 = psSelLigneImputBonLivraisonFacture.executeQuery();
							while(rset5.next()) {
								quantiteLivree-=rset5.getDouble("Quantite");
							}
							rset5.close();
							if (quantiteLivree>0) {
								psInsImputeLigneBLFacture.setInt(1, rset4.getInt("Ligne_Id"));
								psInsImputeLigneBLFacture.setInt(2, rset3.getInt("Ligne_Id"));
								psInsImputeLigneBLFacture.setDouble(3, quantiteLivree);
								psInsImputeLigneBLFacture.executeUpdate();
								quantiteFacturee-=quantiteLivree;
							}
						}
						rset4.close();
					}
					rset3.close();

					psInsBonLivraisonFacture.setInt(1, factureId);
					psInsBonLivraisonFacture.executeUpdate();

					psUpFactureeCommandeClient.setInt(1, factureId);
					psUpFactureeCommandeClient.executeUpdate();
					
					psSelLigneFacture.close();
					psSelLigneBonLivraisonFacture.close();
					psSelLigneImputBonLivraisonFacture.close();
					psInsImputeLigneBLFacture.close();
				}
				rset2.close();
				
				psUpFactureeCommandeClientBL.setInt(1, factureId);
				psUpFactureeCommandeClientBL.executeUpdate();

				psUpClotureCommandeClient.setInt(1, factureId);
				psUpClotureCommandeClient.executeUpdate();

				psDelComMentions.setInt(1, factureId);
				psDelComMentions.executeUpdate();

				psAffaireFacture.setInt(1,factureId);
				rset2 = psAffaireFacture.executeQuery();
				if (rset2.next()) {
					PreparedStatement psUpAffaire = con.prepareStatement("update "+ base + ".AFFAIRE a left join "+ base + ".COMMANDE_CLIENT cc on a.Affaire_Id=cc.Affaire_Id and cc.Etat not in ('C','A') set a.Etat='C', a.Date_Cloture=? where cc.Commande_Id is null and a.Affaire_Id in ("+rset2.getString("Affaire_Id")+")");
					psUpAffaire.setLong(1, System.currentTimeMillis());
					psUpAffaire.executeUpdate();
					psUpAffaire.close();
				}
				rset2.close();

				Calcul calc = new Calcul (s_session,factureId,"Facture");
				calc.majTotaux();

				calculerAcompteFacture(factureId);
			}
			rset.close();
			
			psFacture.close();
			psEcoTaxe.close();
			psUpFacture.close();
			psBonLivraisonFacture.close();
			psDelMentions.close();
			psDelComMentions.close();
			psEcheanceFacture.close();
			psInsEcheance.close();
			psMaxEcheance.close();
			psInsFactEcheance.close();
			psReglements.close();
			psFactEcheance.close();
			psInsImputationEchFact.close();
			psMaxImputationEchFact.close();
			psInsEchReglement.close();
			psMajEcheance.close();
			psMajReglement.close();
			psUpFactureeCommandeClient.close();
			psUpFactureeCommandeClientBL.close();
			psUpClotureCommandeClient.close();
			psInsBonLivraisonFacture.close();
			psAffaireFacture.close();
			psinsCodeProduitBL.close();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}


	private void setTva() {
		try {
			tauxTVA = 19.6;
			Statement stt2 = con.createStatement();
			Statement stt3 = con.createStatement();
			ResultSet rset2;
			ResultSet rset3;

			String reqTva="";
			if (!regimeTVA.equals("E")) {
				reqTva = "select Code_TVA, Taux_TVA from " + base+ ".TAUX_TVA where Normal=1";
				if (codePaysLiv.equals("FR")) {
					reqTva += " and Code_Pays='FR'";
				} else {
					String reqZoneUE = "select Zone_UE from PAYS where Zone_UE=1 and Code_Pays='"+ codePaysLiv + "'";
					rset2 = stt2.executeQuery(reqZoneUE);
					if (rset2.next()) {
						String reqTaxeArrivee = "select Taxe_Arrivee from "	+ base + ".OPTION_TAXATION where Code_Pays='" + codePaysLiv + "'";
						rset3 = stt3.executeQuery(reqTaxeArrivee);
						if (rset3.next()) {
							taxeArrivee = rset3.getInt("Taxe_Arrivee") == 1;
						}
						rset3.close();
						if ((assujettiTVA && regimeTVA.equals("T")) || !assujettiTVA) {
							reqTva += taxeArrivee ? " and Code_Pays='" + codePaysLiv + "'" : " and Code_Pays='FR'";
						}
						else if (assujettiTVA) {
							tauxTVA = 0.0;
						}

					}
					else if (regimeTVA.equals("T")) {
						reqTva += " and Code_Pays='FR'";
					}
					else {
						tauxTVA = 0.0;
					}
					rset2.close();
				}
				rset2 = stt2.executeQuery(reqTva);
				if (tauxTVA != 0 && rset2.next()) {
					tauxTVA = rset2.getDouble("Taux_TVA");
				}
				rset2.close();
			}
			else { 
				tauxTVA=0.0;
			}
			reqTva = "select Code_TVA from " + base+ ".TAUX_TVA where Taux_TVA=" + tauxTVA + " and Code_Pays='"+codePaysLiv+"'";
			rset2 = stt2.executeQuery(reqTva);
			if (rset2.next()) {
				codeTVA = rset2.getInt("Code_TVA");
			}
			else {
				reqTva = "select Code_TVA from " + base+ ".TAUX_TVA where Taux_TVA=" + tauxTVA + " and Code_Pays='FR'";
				rset2 = stt2.executeQuery(reqTva);
				if (rset2.next()) {
					codeTVA = rset2.getInt("Code_TVA");
				}
			}
			rset2.close();
			
			stt2.close();
			stt3.close();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

} // fin

