/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'une liste des commandes
 */

package org.opensi.facturation.actions.affaires;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;
import org.opensi.util.tools.DateTime;


public class CsvListeCommandes {

	public CsvListeCommandes(String buffer, String fichier, DataListeCommandes dlc) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Date");
		lf.addToLine("N\u00B0 Commande");
		lf.addToLine("R\u00E9f. Commande");
		if (dlc.existeSites) {
			lf.addToLine("Provenance");
			lf.addToLine("Login Web");
		}
		lf.addToLine("N\u00B0 Client");
		lf.addToLine("Client");
		lf.addToLine("Etat");
		lf.addToLine("Logistique");
		if (dlc.calculStock) { lf.addToLine("Stock"); }
		lf.addToLine("Date liv.");
		lf.addToLine("Mode exp\u00E9dition");
		lf.addToLine("Dernier BL");
		lf.addToLine("CA Livr\u00E9");
		lf.addToLine("CA Restant");
		lf.addToLine("Mode r\u00E8glement");
		lf.addToLine("Total HT");
		lf.addToLine("Total TTC");
		lf.addToLine("Commentaires internes");
		lf.addToLine("Statut paiement");
		lf.addToLine("Statut facturation");

		int nbLignes = dlc.getNbLignes();

		for (int i=0; i<nbLignes; i++) {
			LigneListeCommandes llc = dlc.lignes.get(i);

			lf.newLine();
			lf.addToLine(DateTime.formatTime(llc.dateCommande, "dd/MM/yyyy"));
			lf.addToLine("\"" + llc.numCommande + "\"");
			lf.addToLine("\"" + llc.refCommande + "\"");
			if (dlc.existeSites) {
				lf.addToLine("\"" + llc.provenance + "\"");
				lf.addToLine("\"" + llc.loginWeb + "\"");
			}
			lf.addToLine("\"" + llc.numClient + "\"");
			lf.addToLine("\"" + llc.nomClient + "\"");
			lf.addToLine("\"" + llc.etatCommande + "\"");
			lf.addToLine("\"" + llc.etatLogistique + "\"");
			if (dlc.calculStock) { lf.addToLine("\"" + llc.stockXY + "\""); }
			lf.addToLine(llc.dateDelai!=0?DateTime.formatTime(llc.dateDelai, "dd/MM/yyyy"):"");
			lf.addToLine("\"" + llc.modeExpedition + "\"");
			lf.addToLine(llc.dateDernierBL!=0?DateTime.formatTime(llc.dateDernierBL, "dd/MM/yyyy"):"");
			lf.addToLine(("" + llc.caLivre).replaceAll("\\.", ","));
			lf.addToLine(("" + llc.caRestant).replaceAll("\\.", ","));
			lf.addToLine("\"" + llc.modeReglement + "\"");
			lf.addToLine(("" + llc.montantHT).replaceAll("\\.", ","));
			lf.addToLine(("" + llc.montantTTC).replaceAll("\\.", ","));
			lf.addToLine("\"" + llc.commentairesInternes + "\"");
			lf.addToLine("\"" + llc.statutPaiement + "\"");
			lf.addToLine("\"" + llc.statutFacturation + "\"");
		}

		lf.write(buffer, fichier, true);
	}



} // fin CsvListeCommandes
