/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un courrier de suivi de lot
 */

package org.opensi.facturation.actions.documents;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.facturation.actions.documents.modeles.CourrierLotStd;
import org.opensi.facturation.actions.documents.modeles.DataCourrierLot;
import org.opensi.util.pdf.GlobalDocument;


public class GenCourrierLot extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
		String fichierPdf = r.getParameter("Fichier");
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		String base = s.getCookie().get("BaseDossier");
		
		String repPdf = absdir +"/pdf/";
		String repTemp = repPdf;
		
		GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);
		String[] infosClient = new String[12];		
		Connection con = s.getConnection(null);
		Statement stt = con.createStatement();
		
		String reqClient = "select distinct Denomination_Liv, Adresse_1_Liv, Adresse_2_Liv, Adresse_3_Liv, Code_Postal_Liv, Ville_Liv, Code_Pays_Liv, Civ_Inter_Liv, Nom_Inter_Liv, Prenom_Inter_Liv, Tel_Inter_Liv, Fax_Inter_Liv from";
		reqClient += " (select bl.Nom_Liv as Denomination_Liv, bl.Adresse_1_Liv, bl.Adresse_2_Liv, bl.Adresse_3_Liv, bl.Code_Postal_Liv, bl.Ville_Liv, bl.Code_Pays_Liv, bl.Civ_Inter_Liv, bl.Nom_Inter_Liv, bl.Prenom_Inter_Liv, bl.Tel_Inter_Liv, bl.Fax_Inter_Liv";
		reqClient += " from "+ base +".BON_LIVRAISON bl, "+ base +".LIGNE_BON_LIVRAISON abl, "+ base +".NUM_LOT_BLOQUE nlb";
		reqClient += " where bl.Etat='V' and bl.Bon_Id=abl.Bon_Id and abl.Num_Lot=nlb.Num_Lot and abl.Statut='V'";
		reqClient += " union";
		reqClient += " select f.Denomination_Liv, f.Adresse_1_Liv, f.Adresse_2_Liv, f.Adresse_3_Liv, f.Code_Postal_Liv, f.Ville_Liv, f.Code_Pays_Liv, f.Civ_Inter_Liv, f.Nom_Inter_Liv, f.Prenom_Inter_Liv, f.Tel_Inter_Liv, f.Fax_Inter_Liv";
		reqClient += " from "+ base +".FACTURE f, "+ base +".LIGNE_FACTURE af, "+ base +".NUM_LOT_BLOQUE nlb";
		reqClient += " where f.Facture_Id=af.Facture_Id and af.Num_Lot=nlb.Num_Lot and f.Directe=1 and f.Numero>0) t";
		
		ResultSet rset = stt.executeQuery(reqClient);
		while (rset.next()) {
			infosClient[0] = rset.getString("Denomination_Liv");
			infosClient[1] = rset.getString("Adresse_1_Liv");
			infosClient[2] = rset.getString("Adresse_2_Liv");
			infosClient[3] = rset.getString("Adresse_3_Liv");
			infosClient[4] = rset.getString("Code_Postal_Liv");
			infosClient[5] = rset.getString("Ville_Liv");
			infosClient[6] = rset.getString("Code_Pays_Liv");
			infosClient[7] = rset.getString("Civ_Inter_Liv");
			infosClient[8] = rset.getString("Nom_Inter_Liv");
			infosClient[9] = rset.getString("Prenom_Inter_Liv");
			infosClient[10] = rset.getString("Tel_Inter_Liv");
			infosClient[11] = rset.getString("Fax_Inter_Liv");
			
			DataCourrierLot dcl = new DataCourrierLot(s, infosClient);		
			CourrierLotStd courrierLot1 = new CourrierLotStd(repTemp, dcl, 1);
			gd.addInternal(courrierLot1);
			CourrierLotStd courrierLot2 = new CourrierLotStd(repTemp, dcl, 2);
			gd.addInternal(courrierLot2);			
		}		
		rset.close();
		stt.close();
		
		gd.close(GlobalDocument.ON_EXIT);
		
		s.closeConnection(con, null);
	
		return true;
		
	} // fin service


} // fin GenCourrierLot
