/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration des expditions par lot (BL + BP et/ou facture)
 */

package org.opensi.facturation.actions.documents;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.facturation.actions.documents.modeles.BonLivraisonStd;
import org.opensi.facturation.actions.documents.modeles.BonPickingStd;
import org.opensi.facturation.actions.documents.modeles.BonPreparationStd;
import org.opensi.facturation.actions.documents.modeles.DataBonLivraison;
import org.opensi.facturation.actions.documents.modeles.DataBonPicking;
import org.opensi.facturation.actions.documents.modeles.DataBonPreparation;
import org.opensi.facturation.actions.documents.modeles.DataFacture;
import org.opensi.facturation.actions.documents.modeles.FactureStd;
import org.opensi.util.pdf.GlobalDocument;


public class GenExpeditionLot extends Action {


	public boolean serverSide() { return true; }

	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String fichierPdf = r.getParameter("FichierPdf");
		String absdir = s.getAppConfiguration().get("opensi.absdir");

		String repPdf = absdir +"/pdf/";
		String repTemp = repPdf;

		Connection con = s.getConnection(null);
		Statement stt = con.createStatement();
		Statement stt2 = con.createStatement();
		String base = s.getCookie().get("BaseDossier");
		boolean editerPicking = (r.getParameter("Editer_Picking").equals("1"));
		boolean editerFacture = (r.getParameter("NePasEditerFacture")!=null?r.getParameter("NePasEditerFacture").equals("0"):true);
		long date_reedition = (r.getParameter("Date_Reedition")!=null?Long.parseLong(r.getParameter("Date_Reedition")):0);
		String[] editions;

		boolean blChiffre = false;
		String reqBLChiffre = "select BL_Chiffre from "+ base +".PARAM_DOSSIER";
		ResultSet rset = stt.executeQuery(reqBLChiffre);
		if (rset.next()) {
			blChiffre = (rset.getInt("BL_Chiffre")==1);
		}
		rset.close();

		GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);

		String liste_editions = "";
		// on recherche pour chaque bl dit  cette date : si il y a un bp associ, et une facture
		String reqEdition = "select bl.Commande_Id,bl.Bon_Id, bl.Edition_BP from "+ base +".BON_LIVRAISON bl";
		reqEdition += " where bl.Date_Edition_Lot="+ date_reedition;
		ResultSet rsEdition = stt.executeQuery(reqEdition);
		while (rsEdition.next()) {
			liste_editions += rsEdition.getString("Bon_Id") + ",";
			liste_editions += rsEdition.getString("Edition_BP") + ",";

			String reqEditionFacture = "select f.Facture_Id from "+ base +".COMMANDE_CLIENT_FACTURE ccf join "+ base +".FACTURE f on ccf.Facture_Id=f.Facture_Id";
			reqEditionFacture += " join "+ base +".BON_LIVRAISON_FACTURE blf on f.Facture_Id=blf.Facture_Id join "+ base +".BON_LIVRAISON bl on blf.Bon_Id=bl.Bon_Id and bl.Etat='V'";
			reqEditionFacture += " where ccf.Commande_Id ="+rsEdition.getString("Commande_Id")+" and f.Date_Edition_Lot="+ date_reedition+" limit 1";
			ResultSet rsEditionFacture = stt2.executeQuery(reqEditionFacture);
			if (rsEditionFacture.next()) {
				liste_editions += "1,";
			}
			else {
				liste_editions +="0,";
			}
		}
		rsEdition.close();

		editions = liste_editions.split(",");


		int i=0;
		String bonId = "";
		boolean editerBP = false;
		boolean existeFacture = false;
		for (int z=0;z<editions.length;z++) {

			switch (i) {
			case 0:
				bonId = editions[z];
				break;
			case 1:
				editerBP = (editions[z].equals("1"));
				break;
			case 2:
				existeFacture = (editions[z].equals("1"));
				break;
			}
			i++;
			if (i==3) {
				if (editerBP) {
					BonPreparationStd bonPreparation = new BonPreparationStd(repTemp, new DataBonPreparation(s, bonId));
					gd.addInternal(bonPreparation);
				}

				BonLivraisonStd bonLivraison = new BonLivraisonStd(repTemp, new DataBonLivraison(s, bonId));
				bonLivraison.setBonChiffre(blChiffre);
				gd.addInternal(bonLivraison);

				if (existeFacture && editerFacture) {
					String reqNumFacture = "select Facture_Id from "+ base +".BON_LIVRAISON_FACTURE";
					reqNumFacture += " where Bon_Id="+ bonId;
					String numFacture = "";
					ResultSet rsNumFacture = stt.executeQuery(reqNumFacture);
					if (rsNumFacture.next()) {
						numFacture=rsNumFacture.getString("Facture_Id");
					}
					rsNumFacture.close();

					FactureStd facture = new FactureStd(repTemp, new DataFacture(s, numFacture));
					gd.addInternal(facture);
				}

				i=0;
			}
		}

		if (editerPicking && date_reedition!=0) {
			// date_reedition ne devrait jamais tre gal  0, car a voudrait dire
			// qu'aucun BL n'a t slectionn dans l'interface, ce qui est normalement impossible
			String reqMarques = "select coalesce(fa.Marque_Id,0) as Marque_Id, coalesce(ma.Libelle,'') as Marque";
			reqMarques += " from "+ base +".FICHE_ARTICLE fa left join "+ base +".MARQUE_ARTICLE ma on fa.Marque_Id=ma.Marque_Id, "+ base +".BON_LIVRAISON bl, "+ base +".LIGNE_BON_LIVRAISON lbl, "+ base +".LIGNE_COMMANDE_CLIENT lcc";
			reqMarques += " where lcc.Type_Ligne='S' and lcc.Reference=fa.Article_Id and lbl.Ref_Ligne=lcc.Ligne_Id and lbl.Bon_Id=bl.Bon_Id and lbl.Statut='V' and bl.Date_Edition_Lot="+ date_reedition;
			reqMarques += " group by Marque_Id order by Marque";
			rset = stt.executeQuery(reqMarques);
			while (rset.next()) {
				int marqueId = rset.getInt("Marque_Id");
				BonPickingStd bonPreparation = new BonPickingStd(repTemp, new DataBonPicking(s, date_reedition, marqueId));
				gd.addInternal(bonPreparation);
			}
			rset.close();
		}

		stt.close();
		s.closeConnection(con, null);

		gd.close(GlobalDocument.ON_EXIT);

		return true;

	} // fin service


} // fin GenExpeditionLot
