/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un courrier de suivi de lot
 */

package org.opensi.facturation.actions.documents.modeles;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.tools.DateTime;


public class DataCourrierLot {	


	// coordonnes socit mettrice
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;
	
	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;
	protected boolean logoAdr;
	protected String urlLogo = "";
	protected String urlCaseACocher;
	
	// coordonnes client
	protected String societeClient;
	protected String adresse1Client;
	protected String adresse2Client;
	protected String adresse3Client;
	protected String codePostalClient;
	protected String villeClient;
	protected String paysClient;
	protected String interlocuteurClient;
	protected String faxClient;	
	protected String telClient;
	
	protected String dateCourrier;
	
	
	protected ArrayList<LigneCourrierLot> lignes = new ArrayList<LigneCourrierLot>(10);
	
	
	public DataCourrierLot(Session s, String[] infosClient) {	
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossierId +".jpg";
			this.urlCaseACocher = s.getAppConfiguration().get("opensi.absdir") +"/images/case_a_cocher.jpg";
			this.societeClient = infosClient[0];
			this.adresse1Client = infosClient[1];
			this.adresse2Client = infosClient[2];
			this.adresse3Client = infosClient[3];
			this.codePostalClient = infosClient[4];
			this.villeClient = infosClient[5];
			String codePaysClient = infosClient[6];
			int civContactClient = Integer.parseInt(infosClient[7]);
			String nomContactClient = infosClient[8];
			String prenomContactClient = infosClient[9];
			this.interlocuteurClient = "";
			this.telClient = infosClient[10];
			this.faxClient = infosClient[11];
			
			this.dateCourrier = DateTime.formatTime(new DateTime().getDateInMillis(),"dd/MM/yyyy");
			
			
			// Paramtres dossier
		      
			String reqCom = "select Logo_Adr from "+ base +".PARAM_DOSSIER";
			ResultSet rset = stt.executeQuery(reqCom);			
			rset.next();
			
			logoAdr = rset.getInt("Logo_Adr")==1;			
			
			rset.close();			
      
			// coordonnes de l'entreprise facturante
      
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			rset = stt.executeQuery(reqFacturante);			
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");			
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");			
			rset.close();
			
			String reqPays = "select Nom_FR from PAYS where Code_Pays='"+ codePaysClient +"'";
			rset = stt.executeQuery(reqPays);
			rset.next();
			this.paysClient = rset.getString("Nom_FR");
			rset.close();
			
			if (nomContactClient.equals("")) {
				this.interlocuteurClient = "";
			} else {
				String reqCivilite = "select Civ_Courte from CIVILITE where Civ_Id="+civContactClient;
				rset = stt.executeQuery(reqCivilite);
				rset.next();
				this.interlocuteurClient = rset.getString("Civ_Courte") + " " + nomContactClient + " " + prenomContactClient;
				rset.close();
			}
			stt.close();
			
			// Recherche rf article et dsignation pour le num lot			
			String reqRef = "select Reference, Designation from";
			reqRef += " (select ac.Reference, ac.Designation";
			reqRef += " from "+ base +".BON_LIVRAISON bl, "+ base +".LIGNE_BON_LIVRAISON abl, "+ base +".LIGNE_COMMANDE_CLIENT ac";
			reqRef += " where bl.Etat='V' and ac.Statut='V' and abl.Statut='V' and bl.Bon_Id=abl.Bon_Id and abl.Num_Lot=? and abl.Ref_Ligne=ac.Ligne_Id";
			reqRef += " union";
			reqRef += " select af.Reference, af.Designation";
			reqRef += " from "+ base +".FACTURE f, "+ base +".LIGNE_FACTURE af";
			reqRef += " where f.Facture_Id=af.Facture_Id and af.Num_Lot=? and f.Directe=1 and f.Numero>0) t limit 1";
			
			PreparedStatement psRef = con.prepareStatement(reqRef);
			
			// Infos des BL
			String reqBL = "select Reference, Num_Lot, sum(Quantite) as Qte_Livree from";
			reqBL += " (select bl.Num_Entier as Reference, abl.Num_Lot, abl.Quantite";
			reqBL += " from "+ base +".BON_LIVRAISON bl, "+ base +".LIGNE_BON_LIVRAISON abl, "+ base +".NUM_LOT_BLOQUE nlb";
			reqBL += " where bl.Etat='V' and bl.Bon_Id=abl.Bon_Id and abl.Num_Lot=nlb.Num_Lot and abl.Statut='V'";
			reqBL += " and bl.Nom_Liv=? and bl.Adresse_1_Liv=? and bl.Adresse_2_Liv=? and bl.Adresse_3_Liv=? and bl.Code_Postal_Liv=? and bl.Ville_Liv=? and bl.Code_Pays_Liv=? and bl.Civ_Inter_Liv=? and bl.Nom_Inter_Liv=? and bl.Prenom_Inter_Liv=?";
			reqBL += " union all";
			reqBL += " select f.Num_Entier as Reference, af.Num_Lot, af.Quantite";
			reqBL += " from "+ base +".FACTURE f, "+ base +".LIGNE_FACTURE af, "+ base +".NUM_LOT_BLOQUE nlb";
			reqBL += " where f.Facture_Id=af.Facture_Id and af.Num_Lot=nlb.Num_Lot and f.Directe=1 and f.Numero>0";
			reqBL += " and f.Denomination_Liv=? and f.Adresse_1_Liv=? and f.Adresse_2_Liv=? and f.Adresse_3_Liv=? and f.Code_Postal_Liv=? and f.Ville_Liv=? and f.Code_Pays_Liv=? and f.Civ_Inter_Liv=? and f.Nom_Inter_Liv=? and f.Prenom_Inter_Liv=?";
			reqBL += " ) t";
			reqBL += " group by Reference, Num_Lot";			
			
			PreparedStatement psBL = con.prepareStatement(reqBL);
			psBL.setString(1, societeClient);
			psBL.setString(2, adresse1Client);
			psBL.setString(3, adresse2Client);
			psBL.setString(4, adresse3Client);
			psBL.setString(5, codePostalClient);
			psBL.setString(6, villeClient);
			psBL.setString(7, codePaysClient);
			psBL.setInt(8, civContactClient);
			psBL.setString(9, nomContactClient);
			psBL.setString(10, prenomContactClient);
			psBL.setString(11, societeClient);
			psBL.setString(12, adresse1Client);
			psBL.setString(13, adresse2Client);
			psBL.setString(14, adresse3Client);
			psBL.setString(15, codePostalClient);
			psBL.setString(16, villeClient);
			psBL.setString(17, codePaysClient);
			psBL.setInt(18, civContactClient);
			psBL.setString(19, nomContactClient);
			psBL.setString(20, prenomContactClient);
			rset = psBL.executeQuery();			
			while (rset.next()) {
				String numLot = rset.getString("Num_Lot");
				String refArticle = "";
				String designationArticle = "";
				psRef.setString(1, numLot);
				psRef.setString(2, numLot);
				psRef.setString(3, numLot);
				ResultSet rset2 = psRef.executeQuery();
				if (rset2.next()) {
					refArticle = rset2.getString("Reference");
					designationArticle = rset2.getString("Designation");
					if (designationArticle.length()>15) {
						designationArticle = designationArticle.substring(0,15);
					}
				}
				
				LigneCourrierLot ls = new LigneCourrierLot();
				
				ls.setReference(rset.getString("Reference"));
				ls.setNumLot(numLot);
				ls.setRefArticle(refArticle);
				ls.setDesignationArticle(designationArticle);
				ls.setQte(rset.getDouble("Qte_Livree"));
				
				this.lignes.add(ls);
			}
			rset.close();
			psBL.close();
			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	public int getNbLignes() {
		return lignes.size();
	}
	
	public int getNbEx() {
		return 1;
	}
	
	
} // fin DataCourrierLot
