/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'une liste de clients en csv
 */

package org.opensi.facturation.actions.editions;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;

public class CsvListeClients {
	
	public CsvListeClients(String buffer, String fichier, DataListeClients dlc) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Famille");
		lf.addToLine("Num\u00E9ro");
		lf.addToLine("Client");
		lf.addToLine("Adresse");
		lf.addToLine("CP");
		lf.addToLine("Ville");
		lf.addToLine("Pays");
		lf.addToLine("T\u00E9l.");
		lf.addToLine("Fax");
		lf.addToLine("Email");
		if (dlc.useCodeTarif) {
			lf.addToLine("Code Tarif");
		}
		lf.addToLine("Taux Remise");
		lf.addToLine("Responsable");
		lf.addToLine("Contact Principal");
		lf.addToLine("N\u00B0 Compte Comptable");
		lf.addToLine("N\u00B0 TVA Intracommunautaire");
		lf.addToLine("Siret");
		lf.addToLine("Code NAF");
		
		int nbLignes = dlc.getNbLignes();
		
		for (int i=0; i<nbLignes; i++) {
			LigneListeClients llc = dlc.lignes.get(i);
			
			lf.newLine();
			lf.addToLine(llc.famille);
			lf.addToLine(llc.numero);
			lf.addToLine(llc.client);
			lf.addToLine(llc.adresse);
			lf.addToLine(llc.cp);
			lf.addToLine(llc.ville);
			lf.addToLine(llc.pays);
			lf.addToLine(llc.tel);
			lf.addToLine(llc.fax);
			lf.addToLine(llc.email);
			if (dlc.useCodeTarif) {
				lf.addToLine(""+llc.codeTarif);
			}
			lf.addToLine((""+llc.tauxRemise).replaceAll("\\.", ","));
			lf.addToLine(llc.responsable);
			lf.addToLine(llc.contactPrincipal);
			lf.addToLine(llc.numCompteComptable);
			lf.addToLine(llc.numTVA);
			lf.addToLine(llc.siret);
			lf.addToLine(llc.codeNAF);
		}
		
		lf.write(buffer, fichier, true);
	}



} // fin CsvListeClients
