/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un tableau de chiffre d'affaires par code stats
 */

package org.opensi.facturation.actions.editions;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;

public class CsvStatistiquesCA {
	
	public CsvStatistiquesCA(String buffer, String fichier, DataStatistiquesCA dsc) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		if (!dsc.detailArticle) {
			lf.newLine();
			lf.addToLine("Code Stats");
			lf.addToLine("Quantit\u00E9");
			lf.addToLine("Total HT");
			lf.addToLine("Total TTC");
			
			int nbLignes = dsc.getNbLignes();
			for (int i=0; i<nbLignes; i++) {
				LigneStatistiqueCA lsc = dsc.lignes.get(i);
				lf.newLine();
				lf.addToLine(lsc.code_stats);
				lf.addToLine(("" + lsc.qte).replaceAll("\\.", ","));
				lf.addToLine(("" + lsc.total_ht).replaceAll("\\.", ","));
				lf.addToLine(("" + lsc.total_ttc).replaceAll("\\.", ","));
			}
		} else {
			lf.newLine();
			lf.addToLine("Code Stats");
			lf.addToLine("R\u00E9f. Article");
			lf.addToLine("D\u00E9signation");
			lf.addToLine("R\u00E9f. Facture");
			lf.addToLine("R\u00E9f. Affaire");
			lf.addToLine("Quantit\u00E9");
			lf.addToLine("Total HT");
			lf.addToLine("Total TTC");
			
			int nbLignesDetail = dsc.getNbLignesDetail();				
			for (int j=0; j<nbLignesDetail; j++) {
				LigneDetailStatistiqueCA lds = dsc.lignesDetail.get(j);
				
				lf.newLine();
				lf.addToLine(lds.code_stats);
				lf.addToLine(lds.ref_article);
				lf.addToLine(lds.designation);
				lf.addToLine(lds.ref_facture);
				lf.addToLine(lds.ref_affaire);
				lf.addToLine(("" + lds.qte).replaceAll("\\.", ","));
				lf.addToLine(("" + lds.total_ht).replaceAll("\\.", ","));
				lf.addToLine(("" + lds.total_ttc).replaceAll("\\.", ","));						
			}
		}
		
		lf.write(buffer, fichier, true);
	}



} // fin CsvStatistiquesCA
