/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un journal des ventes standard
 */

package org.opensi.facturation.actions.editions;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;

import org.opensi.api.SessionOSI;



public class DataJournalAcomptes {


	// les lignes du journal
	protected ArrayList<LigneJournal> lignes = new ArrayList<LigneJournal>(10);
	
	// les lignes de dtail
	protected ArrayList<LigneDetailCompte> details = new ArrayList<LigneDetailCompte>(10);
	
	// ventilation des tvas
	protected LinkedHashMap<Double, VentilTVA> vtvasA = new LinkedHashMap<Double, VentilTVA>(2); // ventilation des tvas sur acomptes
	
	// ventilation comptable des comptes clients
	protected TreeMap<String, LigneDetailCompte> hmVCC = new TreeMap<String, LigneDetailCompte>(new HashMap<String, LigneDetailCompte>(10));
	
	
	// entte

	protected String dossierId;
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String monnaie;
	
	protected long dateCourante = System.currentTimeMillis();
	protected long dateDebut;
	protected long dateFin;
	
	
	// informations totaux
	protected int nbAcomptes = 0;
	protected double montantATVA = 0;
	protected double montantAHT = 0;
	protected double montantATTC = 0;
	
	
	public DataJournalAcomptes(SessionOSI sosi, long dateDebut, long dateFin, int secteurActivite) {	
		try {
		
			Connection con = sosi.getConnection();
			Statement stt = con.createStatement();
      
			String base = sosi.getBaseDossier();
			dossierId = sosi.getDossierId();
      
			ResultSet rset;
			
			this.dateDebut = dateDebut;
			this.dateFin = dateFin;
			
      
			// coordonnes de l'entreprise facturante
      
			String reqDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ base +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";
			
			rset = stt.executeQuery(reqDossier);
			
			rset.next();
			
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.monnaie = rset.getString("Devise");
			
			rset.close();
		
			
			// ventilation des TVA sur acomptes
			boolean editionTTC = false;
			String reqVTvasA = " select Taux_TVA, sum(Total_HT) as Base_Montant, Acompte_Id from";
			reqVTvasA += " (select ac.Taux_TVA, ac.Total_HT, ac.Acompte_Id from "+ base +".ACOMPTE_CLIENT ac";
			if (secteurActivite!=0) {
				reqVTvasA += " join "+ base +".COMMANDE_CLIENT cc on ac.Commande_Id=cc.Commande_Id and cc.Secteur_Activite="+ secteurActivite;
			}
			reqVTvasA += " where ac.Statut='V' and ac.Date_Acompte>="+ dateDebut +" and ac.Date_Acompte<="+ dateFin +")";
			reqVTvasA += " as P group by Acompte_Id, Taux_TVA order by Taux_TVA";
			
			rset = stt.executeQuery(reqVTvasA);
			
			while (rset.next()) {
			
				double tauxTVA = rset.getDouble("Taux_TVA");
				double baseMontant = rset.getDouble("Base_Montant");
				
				
				VentilTVA vtvaA = vtvasA.get(new Double(tauxTVA));
				
				if (vtvaA==null) {
					vtvasA.put(new Double(tauxTVA), new VentilTVA(tauxTVA, baseMontant, editionTTC));
				}
				else {
					vtvaA.add(baseMontant, editionTTC);
				}
			}
			
			rset.close();
 			
			Iterator<Double> li = vtvasA.keySet().iterator();

			while (li.hasNext()) {
		
				VentilTVA vtva = vtvasA.get(li.next());
				
				this.montantATVA += vtva.montantTVA;
				this.montantAHT += vtva.montantHT;
				this.montantATTC += vtva.montantTTC;
			}
			
			
			// Compte clients divers
			
			String reqClientsDivers = "select Numero_Compte_Clients from "+ base +".PARAM_DOSSIER";
			
			rset = stt.executeQuery(reqClientsDivers);
			
			rset.next();
			
			String clientsDivers = rset.getString("Numero_Compte_Clients");
			
			
			// Calcul des lignes du journal des acomptes
			
			String reqAcomptes = "select ac.Numero, ac.Date_Acompte, coalesce(ac.Client_Id,'') as Client_Id, ac.Denomination, coalesce(fc.Numero_Compte, '"+ clientsDivers +"') as Numero_Compte, ";
			reqAcomptes += " ac.Total_HT, ac.Total_TTC, ac.Total_TVA ";
			reqAcomptes += " from "+ base +".ACOMPTE_CLIENT ac";
			if (secteurActivite!=0) {
				reqAcomptes += " join "+ base +".COMMANDE_CLIENT cc on ac.Commande_Id=cc.Commande_Id and cc.Secteur_Activite="+ secteurActivite;
			}
			reqAcomptes += " left join "+ base +".FICHE_CLIENT fc on fc.Client_Id=ac.Client_Id";
			reqAcomptes += " where ac.Statut='V' and ac.Date_Acompte>="+ dateDebut +" and ac.Date_Acompte<="+ dateFin;
			reqAcomptes += " order by ac.Date_Acompte";
					
			rset = stt.executeQuery(reqAcomptes);
			
			double sousTotal = 0;			
			
			while (rset.next()) {
			
				LigneJournal lj = new LigneJournal();

				lj.setDatePiece(rset.getLong("Date_Acompte"));
				lj.setNumPiece(rset.getString("Numero"));
				lj.setTiers(rset.getString("Denomination"));
				lj.setNumTiers(rset.getString("Client_Id"));
				lj.setNumCompte(rset.getString("Numero_Compte"));
				lj.setMontantHT(rset.getDouble("Total_HT"));
				lj.setMontantTVA(rset.getDouble("Total_TVA"));
				lj.setMontantTTC(rset.getDouble("Total_TTC"));
				
				sousTotal += lj.montantTTC;
				
				lj.setTotalProgressif(sousTotal);
				
				lignes.add(lj);
				
				LigneDetailCompte ldc = hmVCC.get(lj.numCompte);
				
				if (ldc==null) {
					hmVCC.put(lj.numCompte, new LigneDetailCompte(lj.numCompte, lj.tiers, lj.montantHT, lj.montantTTC));
				}
				else {
					ldc.add(lj.montantHT, lj.montantTTC);
				}
				
				nbAcomptes++;
			}
			
			rset.close();	
			
			
			details = new ArrayList<LigneDetailCompte>(hmVCC.values());
			
			
			stt.close();
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}	
	
	
	public int getNbLignes() {
		return lignes.size();
	}	
	
	public int getNbLignesDetails() {
		return details.size();
	}	

} // fin DataJournalAcomptes
