/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un journal des ventes standard
 */

package org.opensi.facturation.actions.editions;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;

import org.experlog.openeas.api.Session;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.calcul.CalculVentilTVA;



public class DataJournalVentes {


	// les lignes du journal
	protected ArrayList<LigneJournal> lignes = new ArrayList<LigneJournal>(10);
	
	// les lignes de dtail
	protected ArrayList<LigneDetailCompte> details = new ArrayList<LigneDetailCompte>(10);
	
	// ventilation des tvas
	protected LinkedHashMap<Double, VentilTVA> vtvasF = new LinkedHashMap<Double, VentilTVA>(2); // ventilation des tvas sur factures
	protected LinkedHashMap<Double, VentilTVA> vtvasA = new LinkedHashMap<Double, VentilTVA>(2); // ventilation des tvas sur avoirs
	protected LinkedHashMap<Double, VentilTVA> vtvasN = new LinkedHashMap<Double, VentilTVA>(2); // ventilation des tvas sur avoirs et factures cumuls

	// ventilation comptable des comptes clients
	protected TreeMap<String, LigneDetailCompte> hmVCC = new TreeMap<String, LigneDetailCompte>(new HashMap<String, LigneDetailCompte>(10));
	
	
	// entte

	protected String dossierId;
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String monnaie;
	
	protected long dateCourante = System.currentTimeMillis();
	protected long dateDebut;
	protected long dateFin;
	
	
	// informations totaux
	
	protected int nbFactures = 0;
	protected int nbAvoirs = 0;
	
	protected double montantATVA = 0;
	protected double montantFTVA = 0;
	protected double montantNTVA = 0;
	
	protected double montantAHT = 0;
	protected double montantFHT = 0;
	protected double montantNHT = 0;
	
	protected double montantATTC = 0;
	protected double montantFTTC = 0;
	protected double montantNTTC = 0;

	private HashMap<Integer, CalculVentilTVA> ventilTVA;

	private Iterator<Integer> li;	
	
	public DataJournalVentes(Session s, long dateDebut, long dateFin, int secteurActivite) {	
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
      
			String base = s.getCookie().get("BaseDossier");
			dossierId = s.getCookie().get("Dossier_Id");
      
			ResultSet rset;
			
			this.dateDebut = dateDebut;
			this.dateFin = dateFin;
			
      
			// coordonnes de l'entreprise facturante
      
			String reqDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ base +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";
			rset = stt.executeQuery(reqDossier);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.monnaie = rset.getString("Devise");
			rset.close();
		
			
			// ventilation des TVA sur factures											
			
			String reqVTvasF = " select f.Facture_Id from "+ base +".FACTURE f where f.Numero<>0 and f.Date_Facture>="+ dateDebut +" and f.Date_Facture<="+ dateFin;
			if (secteurActivite!=0) {
				reqVTvasF += " and f.Secteur_Activite="+ secteurActivite;
			}
			rset = stt.executeQuery(reqVTvasF);
			
			while (rset.next()) {
				Calcul calc = new Calcul(s,rset.getInt("Facture_Id"),"Facture");
				ventilTVA = calc.getLignesTVA();
				
				li = ventilTVA.keySet().iterator();
				
				while (li.hasNext()) {
					CalculVentilTVA vtva = ventilTVA.get(li.next());

					VentilTVA vtvaF = vtvasF.get(new Double(vtva.getTauxTVA()));
					
					if (vtvaF==null) {
						vtvasF.put(new Double(vtva.getTauxTVA()), new VentilTVA(vtva.getTauxTVA(), vtva.getMontantHT(), vtva.getMontantTVA(), vtva.getMontantTTC()));
						vtvasN.put(new Double(vtva.getTauxTVA()), new VentilTVA(vtva.getTauxTVA(), vtva.getMontantHT(), vtva.getMontantTVA(), vtva.getMontantTTC()));
					}
					else {
						VentilTVA vtvaN = vtvasN.get(new Double(vtva.getTauxTVA()));
					
						vtvaF.add(vtva.getMontantHT(), vtva.getMontantTVA(), vtva.getMontantTTC());
						vtvaN.add(vtva.getMontantHT(), vtva.getMontantTVA(), vtva.getMontantTTC());
					}	
				}
			}
			
			rset.close();			
			
			
			// ventilation des TVA sur avoirs
									
			

			// ventilation des TVA sur factures											
			
			String reqVTvasA = " select a.Avoir_Id from "+ base +".AVOIR a where a.Numero<>0 and a.Date_Avoir>="+ dateDebut +" and a.Date_Avoir<="+ dateFin;
			if (secteurActivite!=0) {
				reqVTvasA += " and a.Secteur_Activite="+ secteurActivite;
			}
			
			rset = stt.executeQuery(reqVTvasA);
			
			while (rset.next()) {
				Calcul calc = new Calcul(s,rset.getInt("Avoir_Id"),"Avoir");
				ventilTVA = calc.getLignesTVA();
				
				li = ventilTVA.keySet().iterator();
				
				while (li.hasNext()) {
					CalculVentilTVA vtva = ventilTVA.get(li.next());

					VentilTVA vtvaA = vtvasA.get(new Double(vtva.getTauxTVA()));
					
					if (vtvaA==null) {
						vtvasA.put(new Double(vtva.getTauxTVA()), new VentilTVA(vtva.getTauxTVA(), vtva.getMontantHT(), vtva.getMontantTVA(), vtva.getMontantTTC()));
					}
					else {
						vtvaA.add(vtva.getMontantHT(), vtva.getMontantTVA(), vtva.getMontantTTC());
					}
					
					VentilTVA vtvaN = vtvasN.get(new Double(vtva.getTauxTVA()));
					
					if (vtvaN==null) {
						vtvasN.put(new Double(vtva.getTauxTVA()), new VentilTVA(vtva.getTauxTVA(), -vtva.getMontantHT(), -vtva.getMontantTVA(), -vtva.getMontantTTC()));
					}
					else {
						vtvaN.add(-vtva.getMontantHT(), -vtva.getMontantTVA(), -vtva.getMontantTTC());
					}
				}
			}
			
			rset.close();			
						
			
			// TVA NPR
			
			/*String reqTvaNpr = "select t.Taux_NPR, sum(a.Montant_Ligne) as Base_Montant "
											+ "from "+ base +".LIGNE_FACTURE a, "+ base +".TAUX_TVA t where Devis_Id="+ devisId +" and t.Code_TVA=a.Code_TVA and t.Taux_NPR>0 group by t.Code_TVA order by t.Taux_NPR";
			
			rset = stt.executeQuery(reqTvaNpr);
			
			while (rset.next()) {
				VentilTVA vtva = new VentilTVA(rset.getDouble("Base_Montant") * (1-tRemise/100), rset.getDouble("Taux_NPR"));
				vtva.setNPR(true);
				vtvas.add(vtva);				
			}*/
				
 
 			
			Iterator<Double> li = vtvasN.keySet().iterator();

			while (li.hasNext()) {
		
				VentilTVA vtva = vtvasN.get(li.next());
				
				this.montantNTVA += vtva.montantTVA;
				this.montantNHT += vtva.montantHT;
				this.montantNTTC += vtva.montantTTC;
			}
			li = vtvasF.keySet().iterator();

			while (li.hasNext()) {
		
				VentilTVA vtva = vtvasF.get(li.next());
				
				this.montantFTVA += vtva.montantTVA;
				this.montantFHT += vtva.montantHT;
				this.montantFTTC += vtva.montantTTC;
			}
			
			li = vtvasA.keySet().iterator();

			while (li.hasNext()) {
		
				VentilTVA vtva = vtvasA.get(li.next());
				
				this.montantATVA += vtva.montantTVA;
				this.montantAHT += vtva.montantHT;
				this.montantATTC += vtva.montantTTC;
			}
			
			
			// Compte clients divers
			
			String reqClientsDivers = "select Numero_Compte_Clients from "+ base +".PARAM_DOSSIER";
			
			rset = stt.executeQuery(reqClientsDivers);
			
			rset.next();
			
			String clientsDivers = rset.getString("Numero_Compte_Clients");
			
			
			
			
			// Calcul des lignes du journal des ventes
			
			String reqFactures = "select 'F', f.Num_Entier as Num_Piece, f.Numero, f.Date_Facture as Date_Doc, coalesce(f.Client_Id,'') as Client_Id, f.Denomination, coalesce(fc.Numero_Compte, '"+ clientsDivers +"') as Numero_Compte, ";
			reqFactures += " f.Total_HT as Montant_HT, f.Total_TTC as Montant_TTC, f.Total_TVA as Montant_TVA ";
			reqFactures += " from "+ base +".FACTURE f left join "+ base +".FICHE_CLIENT fc on fc.Client_Id=f.Client_Id";
			reqFactures += " where f.Numero<>0 and Date_Facture>="+ dateDebut +" and Date_Facture<="+ dateFin;
			if (secteurActivite!=0) {
				reqFactures += " and f.Secteur_Activite="+ secteurActivite;
			}
			reqFactures += " union ";
			reqFactures += " select 'A', a.Num_Entier as Num_Piece, a.Numero, a.Date_Avoir as Date_Doc, coalesce(a.Client_Id,'') as Client_Id, a.Denomination, coalesce(fc.Numero_Compte, '"+ clientsDivers +"') as Numero_Compte, ";
			reqFactures += " -a.Total_HT as Montant_HT,-(a.Total_TTC) as Montant_TTC, -(a.Total_TVA) as Montant_TVA ";
			reqFactures += " from "+ base +".AVOIR a left join "+ base +".FICHE_CLIENT fc on fc.Client_Id=a.Client_Id";
			reqFactures += " where a.Numero<>0 and Date_Avoir>="+ dateDebut +" and Date_Avoir<="+ dateFin;
			if (secteurActivite!=0) {
				reqFactures += " and a.Secteur_Activite="+ secteurActivite;
			}
			reqFactures += " order by Date_Doc, Numero";
			rset = stt.executeQuery(reqFactures);
			
			double sousTotal = 0;			
			
			while(rset.next()) {
			
				LigneJournal lj = new LigneJournal();

				String typeDoc = rset.getString(1);

				lj.setDatePiece(rset.getLong("Date_Doc"));
				lj.setNumPiece(rset.getString("Num_Piece"));
				lj.setTiers(rset.getString("Denomination"));
				lj.setNumTiers(rset.getString("Client_Id"));
				lj.setNumCompte(rset.getString("Numero_Compte"));
				lj.setMontantHT(rset.getDouble("Montant_HT"));
				lj.setMontantTVA(rset.getDouble("Montant_TVA"));
				lj.setMontantTTC(rset.getDouble("Montant_TTC"));
				
				if (typeDoc.equals("F")) {
					nbFactures++;
				} 
				else {
					nbAvoirs++;					
				}
				
				sousTotal += lj.montantTTC;
				
				lj.setTotalProgressif(sousTotal);
				
				lignes.add(lj);
				
				LigneDetailCompte ldc = hmVCC.get(lj.numCompte);
				
				if (ldc==null) {
					hmVCC.put(lj.numCompte, new LigneDetailCompte(lj.numCompte, lj.tiers, lj.montantHT, lj.montantTTC));
				}
				else {
					ldc.add(lj.montantHT, lj.montantTTC);
				}
			}
			
			rset.close();	
			
			
			details = new ArrayList<LigneDetailCompte>(hmVCC.values());
			
			
			stt.close();			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}	
	
	
	public int getNbLignes() {
		return lignes.size();
	}	
	
	public int getNbLignesDetails() {
		return details.size();
	}	

} // fin DataJournalVentes
