/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un palmars article
 */

package org.opensi.facturation.actions.editions;


import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;


public class DataPalmaresArticle {
	
	// les lignes du palmars
	protected ArrayList<LignePalmaresArticle> lignes = new ArrayList<LignePalmaresArticle>(10);

	protected String dossierId;
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String monnaie;

	protected String debutPeriodeStr;
	protected String finPeriodeStr;
	protected String dateCourante;
	protected int famille1;
	protected int famille2;
	protected int famille3;
	protected int marque;
	
	protected String criteres = "";
	
	
	public DataPalmaresArticle(Session s, long debutPeriode, long finPeriode, int famille1, int famille2, int famille3, int marque) {
		try {
			
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
	  
			String base = s.getCookie().get("BaseDossier");
			this.dossierId = s.getCookie().get("Dossier_Id");
			
			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			this.finPeriodeStr = formatDate.format(new Date(finPeriode));
			this.debutPeriodeStr = formatDate.format(new Date(debutPeriode));
			
			this.famille1 = famille1;
			this.famille2 = famille2;
			this.famille3 = famille3;
			this.marque = marque;

			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, d.Intitule as Devise from "+ base +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id";

			stt = con.createStatement();
			ResultSet rset = stt.executeQuery(reqLeDossier);

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.monnaie = rset.getString("Devise");

			rset.close();
			
			String reqLibelleFamille = "select Libelle from "+ base +".FAMILLE_ARTICLE where Famille_Id=?";
			PreparedStatement psLibelleFamille = con.prepareStatement(reqLibelleFamille);

			String ajoutReqCritere = "";

			if (famille1 != 0) {
				ajoutReqCritere += " and fa.Famille_1="+ famille1;
				psLibelleFamille.setInt(1, famille1);
				rset = psLibelleFamille.executeQuery();
				rset.next();
				criteres += "Famille 1 : "+ rset.getString("Libelle");
				rset.close();

				if (famille2 != 0) {
					ajoutReqCritere += " and fa.Famille_2="+ famille2;
					if (criteres.length()>0) criteres += " - ";
					psLibelleFamille.setInt(1, famille2);
					rset = psLibelleFamille.executeQuery();
					rset.next();
					criteres += "Famille 2 : "+ rset.getString("Libelle");
					rset.close();
					
					if (famille3 != 0) {
						ajoutReqCritere += " and fa.Famille_3="+ famille3;
						if (criteres.length()>0) criteres += " - ";
						psLibelleFamille.setInt(1, famille3);
						rset = psLibelleFamille.executeQuery();
						rset.next();
						criteres += "Famille 3 : "+ rset.getString("Libelle");
						rset.close();
					}
				}
			}
			psLibelleFamille.close();
			
			String reqLibelleMarque = "select Libelle from "+ base +".MARQUE_ARTICLE where Marque_Id=?";
			PreparedStatement psLibelleMarque = con.prepareStatement(reqLibelleMarque);

			if (marque != 0) {
				ajoutReqCritere += " and fa.Marque_Id="+ marque;
				if (criteres.length()>0) {
					criteres += " - ";
				}
				psLibelleMarque.setInt(1, marque);
				rset = psLibelleMarque.executeQuery();
				rset.next();
				criteres += "Marque : "+ rset.getString("Libelle");
				rset.close();
			}
			psLibelleMarque.close();

			String reqArticleCA = " select TG.Article_Id, TG.Designation, sum(TG.Quantite) as Qte, sum(TG.CA_HT) as CA_HT from"
					+" ((select fa.Article_Id, fa.Designation, coalesce(sum(af.Quantite),0) as Quantite, coalesce(if(f.Edition_TTC=0, sum(af.Montant_Ligne * (1-f.Remise/100)), sum(af.Montant_Ligne * (1-f.Remise/100) / (1+af.Taux_TVA/100))),0) as CA_HT"
					+" from "+ base +".FACTURE f join "+ base +".LIGNE_FACTURE af on f.Facture_Id=af.Facture_Id, "+ base +".FICHE_ARTICLE fa"
					+" where f.Numero<>0 and f.Date_Facture<="+ finPeriode +" and f.Date_Facture>="+ debutPeriode +" and fa.Article_Id=af.Reference "+ ajoutReqCritere +" group by fa.Article_Id, fa.Designation)"
					+" union "
					+" (select fa.Article_Id, fa.Designation, -coalesce(sum(aa.Quantite),0) as Quantite, -coalesce(if(a.Edition_TTC=0, sum(aa.Montant_Ligne * (1-a.Remise/100)), sum(aa.Montant_Ligne * (1-a.Remise/100) / (1+aa.Taux_TVA/100))),0) as CA_HT"
					+" from "+ base +".AVOIR a join "+ base +".LIGNE_AVOIR aa on a.Avoir_Id=aa.Avoir_Id, "+ base +".FICHE_ARTICLE fa"
					+" where a.Numero<>0 and a.Date_Avoir<="+ finPeriode +" and a.Date_Avoir>="+ debutPeriode +" and fa.Article_Id=aa.Reference "+ ajoutReqCritere +" group by fa.Article_Id, fa.Designation)) as TG"
					+" group by TG.Article_Id, TG.Designation order by TG.CA_HT desc";


			rset = stt.executeQuery(reqArticleCA);

			while (rset.next()) {
				
				LignePalmaresArticle lp = new LignePalmaresArticle();

				lp.setNumero(rset.getString("Article_Id"));
				lp.setDesignation(rset.getString("Designation"));
				lp.setCaHT(rset.getDouble("CA_HT"));
				lp.setQte(rset.getDouble("Qte"));

				lignes.add(lp);
			}

			rset.close();
			
			stt.close();
			s.closeConnection(con, null);
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}


	public int getNbLignes() {
		return lignes.size();
	}


} // fin DataPalmaresArticle
