/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un tableau de chiffre d'affaires par code stats
 */

package org.opensi.facturation.actions.editions;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;

public class DataStatistiquesCA {

	// les lignes de la liste des statistiques
	protected ArrayList<LigneStatistiqueCA> lignes = new ArrayList<LigneStatistiqueCA>(10);
	protected ArrayList<LigneDetailStatistiqueCA> lignesDetail = new ArrayList<LigneDetailStatistiqueCA>(10);
	protected String finPeriodeStr;
	protected String debutPeriodeStr;
	protected boolean detailArticle;
	
	
	public DataStatistiquesCA(Session s, long debutPeriode, long finPeriode, boolean detail) {
		try {
			this.detailArticle = detail;
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String base = s.getCookie().get("BaseDossier");
			
			if (!detailArticle) {
				
				String reqCA = "select coalesce(Code_Stats,'') as Code_Stats, sum(Qte) as Qte, sum(Total_HT) as Total_HT, sum(Total_TTC) as Total_TTC from";
				reqCA += " (select coalesce(if(af.Code_Stats<>'' && af.Code_Stats is not null,0,1),0) as Priorite, coalesce(if(af.Code_Stats<>'' && af.Code_Stats is not null,af.Code_Stats,'[Sans Code Stat]'),0) as Code_Stats, coalesce(sum(af.Quantite),0) as Qte, coalesce(sum(if(f.Edition_TTC=0,af.Montant_Ligne * (1-f.Remise/100),af.Montant_Ligne * (1-f.Remise/100) / (1+af.Taux_TVA/100))),0) as Total_HT, coalesce(sum(if(f.Edition_TTC=1,af.Montant_Ligne * (1-f.Remise/100),af.Montant_Ligne * (1-f.Remise/100) * (1+af.Taux_TVA/100))),0) as Total_TTC";
				reqCA += " from "+ base +".FACTURE f join " + base +".LIGNE_FACTURE af on f.Facture_Id = af.Facture_Id where f.Numero <> 0";
				reqCA += " and f.Date_Facture >= "+ debutPeriode + " and f.Date_Facture <= "+ finPeriode + " group by coalesce(Code_Stats,'') asc";
				reqCA += " union all";
				reqCA += " select coalesce(if(aa.Code_Stats<>'' && aa.Code_Stats is not null,0,1),0) as Priorite, coalesce(if(aa.Code_Stats<>'' && aa.Code_Stats is not null,aa.Code_Stats,'[Sans Code Stat]'),0) as Code_Stats, coalesce((-1*sum(aa.Quantite)),0) as Qte, coalesce(-1*(sum(if(a.Edition_TTC=0,aa.Montant_Ligne * (1-a.Remise/100),aa.Montant_Ligne * (1-a.Remise/100) /(1+aa.Taux_TVA/100)))),0) as Total_HT, coalesce(-1*(sum(if(a.Edition_TTC=1,aa.Montant_Ligne * (1-a.Remise/100),aa.Montant_Ligne * (1-a.Remise/100) * (1+aa.Taux_TVA/100)))),0) as Total_TTC";
				reqCA += " from "+ base +".AVOIR a join " + base +".LIGNE_AVOIR aa on a.Avoir_Id = aa.Avoir_Id where a.Numero <> 0";
				reqCA += " and a.Date_Avoir >= "+ debutPeriode + " and a.Date_Avoir <= "+ finPeriode + " group by coalesce(Code_Stats)) as t";
				reqCA += " group by Code_Stats order by Priorite, Code_Stats";
				ResultSet rset = stt.executeQuery(reqCA);
				
				while (rset.next()) {
					LigneStatistiqueCA lsc = new LigneStatistiqueCA();
					lsc.setCodeStats(rset.getString("Code_Stats"));
					lsc.setQte(rset.getDouble("Qte"));
					lsc.setTotal_HT(rset.getDouble("Total_HT"));
					lsc.setTotal_TTC(rset.getDouble("Total_TTC"));
					lignes.add(lsc);
				}
				rset.close();
				
			} else {
				
				String reqDetailCA = "select Code_Stats, Ref_Article, Designation, Ref_Facture, Qte, Total_HT, Total_TTC, Ref_Affaire from";
				reqDetailCA += " (select 0 as Type_Doc, coalesce(if(af.Code_Stats<>'' && af.Code_Stats is not null,0,1),0) as Priorite, coalesce(if(af.Code_Stats<>'' && af.Code_Stats is not null,af.Code_Stats,'[Sans Code Stat]'),0) as Code_Stats, coalesce(af.Reference,'') as Ref_Article, coalesce(af.Designation,'') as Designation, f.Num_Entier as Ref_Facture, coalesce(af.Quantite,0) as Qte, coalesce(if(f.Edition_TTC=0,af.Montant_Ligne*(1-f.Remise/100),af.Montant_Ligne*(1-f.Remise/100)/(1+af.Taux_TVA/100)),0) as Total_HT, coalesce(if(f.Edition_TTC=1,af.Montant_Ligne * (1-f.Remise/100),af.Montant_Ligne * (1-f.Remise/100)* (1+af.Taux_TVA/100)),0) as Total_TTC, '' as Ref_Affaire";
				reqDetailCA += " from "+ base +".FACTURE f join " + base +".LIGNE_FACTURE af on f.Facture_Id = af.Facture_Id";
				reqDetailCA += " where f.Directe=1 and f.Numero <> 0";
				reqDetailCA += " and f.Date_Facture >= "+ debutPeriode + " and f.Date_Facture <= "+ finPeriode;
				reqDetailCA += " union all";
				reqDetailCA += " select 0 as Type_Doc, coalesce(if(af.Code_Stats<>'' && af.Code_Stats is not null,0,1),0) as Priorite, coalesce(if(af.Code_Stats<>'' && af.Code_Stats is not null,af.Code_Stats,'[Sans Code Stat]'),0) as Code_Stats, coalesce(af.Reference,'') as Ref_Article, coalesce(af.Designation,'') as Designation, f.Num_Entier as Ref_Facture, coalesce(af.Quantite,0) as Qte, coalesce(if(f.Edition_TTC=0,af.Montant_Ligne*(1-f.Remise/100),af.Montant_Ligne*(1-f.Remise/100)/(1+af.Taux_TVA/100)),0) as Total_HT, coalesce(if(f.Edition_TTC=1,af.Montant_Ligne * (1-f.Remise/100),af.Montant_Ligne * (1-f.Remise/100) * (1+af.Taux_TVA/100)),0) as Total_TTC, aff.Num_Entier as Ref_Affaire";
				reqDetailCA += " from "+ base +".FACTURE f join " + base +".LIGNE_FACTURE af on f.Facture_Id = af.Facture_Id,"+ base +".LIGNE_COMMANDE_CLIENT acc,"+ base +".COMMANDE_CLIENT cc,"+ base +".AFFAIRE aff";
				reqDetailCA += " where f.Directe=0 and f.Numero<>0 and af.Ref_Ligne=acc.Ligne_Id and acc.Commande_Id=cc.Commande_Id and cc.Affaire_Id=aff.Affaire_Id and acc.Statut='V'";
				reqDetailCA += " and f.Date_Facture >= "+ debutPeriode + " and f.Date_Facture <= "+ finPeriode;
				reqDetailCA += " union all";			
				reqDetailCA += " select 1 as Type_Doc, coalesce(if(aa.Code_Stats<>'' && aa.Code_Stats is not null,0,1),0) as Priorite, coalesce(if(aa.Code_Stats<>'' && aa.Code_Stats is not null,aa.Code_Stats,'[Sans Code Stat]'),0) as Code_Stats, coalesce(aa.Reference,'') as Ref_Article, coalesce(aa.Designation,'') as Designation, a.Num_Entier as Ref_Facture, coalesce(-1*aa.Quantite,0) as Qte, coalesce(-1*(if(a.Edition_TTC=0,aa.Montant_Ligne*(1-a.Remise/100),aa.Montant_Ligne*(1-a.Remise/100)/(1+aa.Taux_TVA/100))),0) as Total_HT, coalesce(-1*(if(a.Edition_TTC=1,aa.Montant_Ligne * (1-a.Remise/100),aa.Montant_Ligne * (1-a.Remise/100) * (1+aa.Taux_TVA/100))),0) as Total_TTC, '' as Ref_Affaire";
				reqDetailCA += " from "+ base +".AVOIR a join " + base +".LIGNE_AVOIR aa on a.Avoir_Id = aa.Avoir_Id where a.Numero<>0";
				reqDetailCA += " and a.Date_Avoir >= "+ debutPeriode + " and a.Date_Avoir <= "+ finPeriode + ") as t";
				reqDetailCA += " order by Priorite, Code_Stats, Ref_Article, Type_Doc, Ref_Facture asc";
				ResultSet rset = stt.executeQuery(reqDetailCA);
			
				while (rset.next()) {
					LigneDetailStatistiqueCA lds = new LigneDetailStatistiqueCA();
					lds.setCodeStats(rset.getString("Code_Stats"));
					lds.setRefArticle(rset.getString("Ref_Article"));
					lds.setDesignation(rset.getString("Designation"));
					lds.setRefFacture(rset.getString("Ref_Facture"));
					lds.setRefAffaire(rset.getString("Ref_Affaire"));
					lds.setQte(rset.getDouble("Qte"));
					lds.setTotal_HT(rset.getDouble("Total_HT"));
					lds.setTotal_TTC(rset.getDouble("Total_TTC"));
					lignesDetail.add(lds);
				}
				rset.close();
				
			}
			stt.close();
			s.closeConnection(con, null);
		}
		catch(Exception e) {
			e.printStackTrace();
		}			
	}
	
	public int getNbLignes() {
		return lignes.size();
	}
	
	public int getNbLignesDetail() {
		return lignesDetail.size();
	}


} // fin DataStatistiquesCA
