/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un historique des articles nomenclaturs fabriqus
 */

package org.opensi.facturation.actions.fabrication;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;

public class DataHistoriqueFabrication {

	// les lignes de la liste des statistiques
	protected ArrayList<LigneHistoriqueFabrication> lignes = new ArrayList<LigneHistoriqueFabrication>(10);
	protected String finPeriodeStr;
	protected String debutPeriodeStr;
	protected String dateCourante;
	
	protected String dossierId;
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	
	
	public DataHistoriqueFabrication(Session s, long debutPeriode, long finPeriode) {
		try {
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String base = s.getCookie().get("BaseDossier");
			this.dossierId = s.getCookie().get("Dossier_Id");
			
			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			this.finPeriodeStr = formatDate.format(new Date(finPeriode));
			this.debutPeriodeStr = formatDate.format(new Date(debutPeriode));
			
			String reqLeDossier = "select * from "+ base +".SOCIETE";

			stt = con.createStatement();
			ResultSet rset = stt.executeQuery(reqLeDossier);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			rset.close();
			
			String reqHistorique = "select hf.Ref_Article, hf.Quantite, hf.Type, hf.Date, a.Designation";
			reqHistorique += " from "+ base +".HISTORIQUE_FABRICATION hf, "+ base +".FICHE_ARTICLE a";
			reqHistorique += " where hf.Ref_Article=a.Article_Id and hf.Date>="+ debutPeriode +" and hf.Date<="+ finPeriode +" order by hf.Date desc";
			rset = stt.executeQuery(reqHistorique);
		
			while (rset.next()) {
				LigneHistoriqueFabrication lhf = new LigneHistoriqueFabrication();				
				lhf.setDateFabrication(rset.getLong("Date"));
				lhf.setRefArticle(rset.getString("Ref_Article"));
				lhf.setDesignation(rset.getString("Designation"));
				lhf.setQuantite(rset.getDouble("Quantite"));
				lhf.setType(rset.getString("Type").equals("A")?"Assemblage":"D\u00E9sassemblage");
				lignes.add(lhf);
			}
			rset.close();
				
			stt.close();
			s.closeConnection(con, null);
		}
		catch(Exception e) {
			e.printStackTrace();
		}			
	}
	
	public int getNbLignes() {
		return lignes.size();
	}
	

} // fin DataHistoriqueFabrication
