/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *   Export des donnes pour Idep
 */

package org.opensi.facturation.actions.idep;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;


public class CsvExportDeclaration {
		
	public CsvExportDeclaration(String buffer, String fichier, DataExportIdep dei) throws Exception {
		try
		{
			// EXPORT AU FORMAT DECLARATION
			// Les units supplmentaires ne sont pas gres (par dfaut  0)
			// Donc la masse nette est toujours remplie
			
			// Paramtrer IDEP pour qu'il n'y ait 0 saut de ligne  l'import (c'est le cas par dfaut)
			
			ListingFile lf = new ListingTabFile();
			
			int nbLignes = dei.getNbLignes();
			
			if (dei.declarationIntro) {
				// DECLARATION A L'INTRODUCTION
				for (int i=0; i<nbLignes; i++) {
					LigneExportIdep lei = dei.lignes.get(i);
					
					lf.newLine();
					lf.addToLine(lei.refFacture);
					lf.addToLine(dei.niveauObligation==1?""+dei.codeRegime:"");
					lf.addToLine("");
					lf.addToLine(lei.provenanceDestination);
					lf.addToLine(!dei.declarationSimplifiee?lei.paysOrigine:"");
					lf.addToLine(!dei.declarationSimplifiee?""+dei.codeTransactionA:"");
					lf.addToLine(!dei.declarationSimplifiee?""+dei.codeTransactionB:"");
					lf.addToLine(dei.niveauObligation==1?""+dei.codeTransport:"");
					lf.addToLine(dei.niveauObligation==1?""+dei.departement:"");
					lf.addToLine(!dei.declarationSimplifiee?dei.conditionsLiv:"");
					lf.addToLine(!dei.declarationSimplifiee?""+dei.situationLieu:"");
					lf.addToLine(lei.referenceProduit);
					lf.addToLine(lei.codeNGP9);
					lf.addToLine("\""+lei.libelleProduit.replaceAll("\"", "\\\"")+"\"");
					lf.addToLine(!dei.declarationSimplifiee?""+lei.unitesSupplementaires:"");
					lf.addToLine(!dei.declarationSimplifiee?""+lei.masseNette:"");
					lf.addToLine("");
					lf.addToLine(lei.codeDevise);
					lf.addToLine(dei.codeRegime!=19 || dei.declarationSimplifiee?""+lei.valeurDevise:"");
					lf.addToLine(dei.codeRegime!=19 || dei.declarationSimplifiee?""+lei.valeur:"");
					lf.addToLine(dei.codeRegime==19 && !dei.declarationSimplifiee?""+lei.valeurStatDevise:"");
					lf.addToLine(dei.codeRegime==19 && !dei.declarationSimplifiee?""+lei.valeurStatistique:"");
				}
			} else {
				// DECLARATION A L'EXPEDITION
				for (int i=0; i<nbLignes; i++) {
					LigneExportIdep lei = dei.lignes.get(i);
					
					lf.newLine();
					lf.addToLine(lei.refFacture);
					lf.addToLine(dei.codeRegime!=29 || (dei.niveauObligation!=2 && dei.niveauObligation!=3)?""+dei.codeRegime:"");
					lf.addToLine(dei.niveauObligation==4 || dei.codeRegime!=29?lei.numTVAPartenaire:"");
					lf.addToLine(dei.niveauObligation!=4 && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?lei.provenanceDestination:"");
					lf.addToLine("");
					lf.addToLine(!dei.declarationSimplifiee && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?""+dei.codeTransactionA:"");
					lf.addToLine(!dei.declarationSimplifiee && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?""+dei.codeTransactionB:"");
					lf.addToLine(dei.niveauObligation==1 && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?""+dei.codeTransport:"");
					lf.addToLine(dei.niveauObligation==1 && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?""+dei.departement:"");
					lf.addToLine(!dei.declarationSimplifiee?dei.conditionsLiv:"");
					lf.addToLine(!dei.declarationSimplifiee?""+dei.situationLieu:"");
					lf.addToLine(dei.niveauObligation!=4 && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?lei.referenceProduit:"");
					lf.addToLine(dei.niveauObligation!=4 && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?lei.codeNGP9:"");
					lf.addToLine(dei.niveauObligation!=4 && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?"\""+lei.libelleProduit.replaceAll("\"", "\\\"")+"\"":"");
					lf.addToLine(!dei.declarationSimplifiee && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?""+lei.unitesSupplementaires:"");
					lf.addToLine(!dei.declarationSimplifiee && dei.codeRegime!=25 && dei.codeRegime!=26 && dei.codeRegime!=31?""+lei.masseNette:"");
					lf.addToLine("");
					lf.addToLine(lei.codeDevise);
					lf.addToLine(dei.codeRegime!=29 || dei.declarationSimplifiee?""+lei.valeurDevise:"");
					lf.addToLine(dei.codeRegime!=29 || dei.declarationSimplifiee?""+lei.valeur:"");
					lf.addToLine(dei.codeRegime==29 && !dei.declarationSimplifiee?""+lei.valeurStatDevise:"");
					lf.addToLine(dei.codeRegime==29 && !dei.declarationSimplifiee?""+lei.valeurStatistique:"");
				}
			}
			
			lf.write(buffer, fichier, true);
		}
		catch(Exception ioe) {
			System.out.println("erreur : " + ioe );
		}
	}
	
} // fin CsvExportDeclaration
