/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'export pour IDEP
 */

package org.opensi.facturation.actions.idep;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;

public class DataExportIdep {
	
	// les lignes de l'export
	protected ArrayList<LigneExportIdep> lignes = new ArrayList<LigneExportIdep>(10);
	
	protected int niveauObligation=0;
	protected boolean declarationIntro = false;
	protected boolean declarationSimplifiee = false;
	protected int departement=0;
	protected int codeRegime=0;
	protected int codeTransactionA=0;
	protected int codeTransactionB=0;
	protected String conditionsLiv="";
	protected int situationLieu=1;
	protected int codeTransport=0;

	public DataExportIdep(Session s, long debutPeriode, long finPeriode, long dateReedition, String typeExport) {

		try {
			
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String base = s.getCookie().get("BaseDossier");
			this.declarationIntro = typeExport.equals("I");			
			this.situationLieu = (this.declarationIntro?1:2);
			
			String req = "select Code_Postal from "+ base +".SOCIETE";
			ResultSet rset = stt.executeQuery(req);
			if (rset.next()) {
				this.departement=Integer.parseInt(rset.getString("Code_Postal").substring(0,2));
			}
			rset.close();
			
			boolean reedition = (dateReedition!=0);
			long dateCourante = new DateTime().getTimeInMillis();
			
			// Si on dite pour la premire fois l'export IDEP, on va tagger les documents concerns
			// REMARQUE : les lignes dont le montant total arrondi est gal  0 ne sont pas dclares
			if (!reedition) {
				if (this.declarationIntro) {
					req = "select br.BR_Id as Doc_Id, 'BR' as Type_Doc, (sum(abr.Montant_Ligne) * (1-c.Remise/100)) as Valeur";
					req += " from "+ base +".BON_RECEPTION br join "+ base +".LIGNE_BON_RECEPTION abr on abr.BR_Id=br.BR_Id and abr.Facture=1 and br.Etat='V' and br.Date_DEB=0";
					req += " join "+ base +".LIGNE_COMMANDE_FOURNISSEUR ac on abr.Ref_Ligne=ac.Ligne_Id and ac.Type_Ligne='S' join "+ base +".COMMANDE_FOURNISSEUR c on ac.Commande_Id=c.Commande_Id and c.Code_Pays<>'FR'";
					req += " join "+ base +".LIGNE_FACTURE_FOURNISSEUR aff on abr.Ref_Ligne=aff.Ref_Ligne join "+ base +".FACTURE_FOURNISSEUR ff on aff.Facture_Id=ff.Facture_Id and ff.Statut='V'";
					req += " join PAYS p on c.Code_Pays=p.Code_Pays and p.Zone_UE=1";
					req += " join "+ base +".FICHE_ARTICLE fa on fa.Article_Id=ac.Reference";
					req += " where ff.Date_Facture>="+ debutPeriode +" and ff.Date_Facture<="+ finPeriode;
					req += " group by br.BR_Id having round(Valeur)>0";
				}
				else {
					req = "select bl.Bon_Id as Doc_Id, 'BL' as Type_Doc, (sum(if(cc.Edition_TTC=0,abl.Montant_Ligne,abl.Montant_Ligne/(1+ac.Taux_TVA/100))) * (1-cc.Remise/100)) as Valeur";
					req += " from "+ base +".BON_LIVRAISON bl join "+ base +".LIGNE_BON_LIVRAISON abl on abl.Bon_Id=bl.Bon_Id and bl.Date_DEB=0 and bl.Etat='V' and bl.Code_Pays_Liv<>'FR' and abl.Statut='V'";
					req += " join "+ base +".BON_LIVRAISON_FACTURE blf on bl.Bon_Id=blf.Bon_Id join "+ base +".FACTURE fact on blf.Facture_Id=fact.Facture_Id and fact.Numero>0";
					req += " join "+ base +".LIGNE_COMMANDE_CLIENT ac on abl.Ref_Ligne=ac.Ligne_Id and ac.Type_Ligne='S' and ac.Statut='V' join "+ base +".COMMANDE_CLIENT cc on ac.Commande_Id=cc.Commande_Id";
					req += " join PAYS p on bl.Code_Pays_Liv=p.Code_Pays and p.Zone_UE=1 join "+ base +".OPTION_TAXATION tx on p.Code_Pays=tx.Code_Pays";
					req += " join "+ base +".FICHE_ARTICLE fa on fa.Article_Id=ac.Reference";
					req += " where (cc.Assujetti_TVA=1 or tx.Taxe_Arrivee=1) and fact.Date_Facture>="+ debutPeriode +" and fact.Date_Facture<="+ finPeriode;
					req += " group by bl.Bon_Id having round(Valeur)>0";
					req += " union";
					req += " select fact.Facture_Id as Doc_Id, 'FACT' as Type_Doc, (sum(if(fact.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100))) * (1-fact.Remise/100)) as Valeur";
					req += " from "+ base +".FACTURE fact join "+ base +".LIGNE_FACTURE af on af.Facture_Id=fact.Facture_Id and fact.Numero>0 and fact.Directe=1 and fact.Date_DEB=0 and fact.Code_Pays_Liv<>'FR' and af.Type_Ligne='S'";
					req += " join PAYS p on fact.Code_Pays_Liv=p.Code_Pays and p.Zone_UE=1 join "+ base +".OPTION_TAXATION tx on p.Code_Pays=tx.Code_Pays";
					req += " join "+ base +".FICHE_ARTICLE fa on fa.Article_Id=af.Reference";
					req += " where (fact.Assujetti_TVA=1 or tx.Taxe_Arrivee=1) and fact.Date_Facture>="+ debutPeriode +" and fact.Date_Facture<="+ finPeriode;
					req += " group by fact.Facture_Id having round(Valeur)>0";
				}
				
				String reqMajTagBR = "update "+ base +".BON_RECEPTION set Date_DEB="+dateCourante+" where BR_Id=?";
				String reqMajTagBL = "update "+ base +".BON_LIVRAISON set Date_DEB="+dateCourante+" where Bon_Id=?";
				String reqMajTagFact = "update "+ base +".FACTURE set Date_DEB="+dateCourante+" where Facture_Id=?";
				PreparedStatement psTagBR = con.prepareStatement(reqMajTagBR);
				PreparedStatement psTagBL = con.prepareStatement(reqMajTagBL);
				PreparedStatement psTagFact = con.prepareStatement(reqMajTagFact);
				
				rset = stt.executeQuery(req);
				while (rset.next()) {
					if (rset.getString("Type_Doc").equals("BR")) {
						psTagBR.setInt(1, rset.getInt("Doc_Id"));
						psTagBR.executeUpdate();
					} else if (rset.getString("Type_Doc").equals("BL")) {
						psTagBL.setInt(1, rset.getInt("Doc_Id"));
						psTagBL.executeUpdate();
					} else if (rset.getString("Type_Doc").equals("FACT")) {
						psTagFact.setInt(1, rset.getInt("Doc_Id"));
						psTagFact.executeUpdate();
					}
				}
				rset.close();
				
				psTagBR.close();
				psTagBL.close();
				psTagFact.close();
			}
			
			
			String reqParam = "";
			
			if (this.declarationIntro) {
				reqParam = "select Niveau_Obligation_Intro as Niveau_Obligation, Code_Regime_Intro as Code_Regime, Nature_Transaction_Intro as Nature_Transaction, Conditions_Liv_Intro as Conditions_Liv, Mode_Transport_Intro as Mode_Transport";
				reqParam += " from "+ base +".PARAM_DOSSIER";
				
				req = "select (sum(abr.Montant_Ligne) * (1-c.Remise/100)) as Valeur,";
				req += " coalesce(sum(fa.Poids_Net*abr.Quantite),0) as Masse_Nette, coalesce(fa.Mesure_Poids,'K') as Mesure_Poids,";
				req += " fa.Code_NC8, coalesce(n.Libelle,'') as Libelle_Produit, c.Code_Pays,";
				req += " ff.Numero as Ref_Facture";
				req += " from "+ base +".BON_RECEPTION br join "+ base +".LIGNE_BON_RECEPTION abr on abr.BR_Id=br.BR_Id and abr.Facture=1";
				req += " join "+ base +".LIGNE_COMMANDE_FOURNISSEUR ac on abr.Ref_Ligne=ac.Ligne_Id and ac.Type_Ligne='S' join "+ base +".COMMANDE_FOURNISSEUR c on ac.Commande_Id=c.Commande_Id";
				req += " join "+ base +".LIGNE_FACTURE_FOURNISSEUR aff on abr.Ref_Ligne=aff.Ref_Ligne join "+ base +".FACTURE_FOURNISSEUR ff on aff.Facture_Id=ff.Facture_Id";
				req += " join PAYS p on c.Code_Pays=p.Code_Pays";
				req += " join "+ base +".FICHE_ARTICLE fa on fa.Article_Id=ac.Reference left join NOMENCLATURE_NC8 n on n.Code_NC8=fa.Code_NC8";
				req += " where br.Date_DEB="+(reedition?dateReedition:dateCourante);
				req += " group by ff.Facture_Id, fa.Code_NC8 having round(Valeur)>0";
			} else {
				reqParam = "select Niveau_Obligation_Expe as Niveau_Obligation, Code_Regime_Expe as Code_Regime, Nature_Transaction_Expe as Nature_Transaction, Conditions_Liv_Expe as Conditions_Liv, Mode_Transport_Expe as Mode_Transport";
				reqParam += " from "+ base +".PARAM_DOSSIER";
			
				req = "select Valeur, coalesce(Masse_Nette,0) as Masse_Nette, coalesce(Mesure_Poids,'K') as Mesure_Poids,";
				req += " Com.Code_NC8, coalesce(n.Libelle,'') as Libelle_Produit, Num_TVA_Intra, Code_Pays_Liv as Code_Pays,";
				req += " Num_Entier as Ref_Facture from";
				req += " (select (sum(if(cc.Edition_TTC=0,abl.Montant_Ligne,abl.Montant_Ligne/(1+ac.Taux_TVA/100))) * (1-cc.Remise/100)) as Valeur,";
				req += " sum(coalesce(fa.Poids_Net,1)*abl.Quantite) as Masse_Nette, fa.Mesure_Poids, fa.Code_NC8, cc.Num_TVA_Intra,";
				req += " bl.Code_Pays_Liv, fact.Num_Entier";
				req += " from "+ base +".BON_LIVRAISON bl join "+ base +".LIGNE_BON_LIVRAISON abl on abl.Bon_Id=bl.Bon_Id and abl.Statut='V'";
				req += " join "+ base +".BON_LIVRAISON_FACTURE blf on bl.Bon_Id=blf.Bon_Id join "+ base +".FACTURE fact on blf.Facture_Id=fact.Facture_Id and fact.Numero>0";
				req += " join "+ base +".LIGNE_COMMANDE_CLIENT ac on abl.Ref_Ligne=ac.Ligne_Id and ac.Statut='V' and ac.Type_Ligne='S' join "+ base +".COMMANDE_CLIENT cc on ac.Commande_Id=cc.Commande_Id";
				req += " join PAYS p on bl.Code_Pays_Liv=p.Code_Pays";
				req += " join "+ base +".FICHE_ARTICLE fa on fa.Article_Id=ac.Reference";
				req += " where bl.Date_DEB="+(reedition?dateReedition:dateCourante);
				req += " group by fact.Facture_Id, Code_NC8 having round(Valeur)>0";
				req += " union";
				req += " select (sum(if(fact.Edition_TTC=0,af.Montant_Ligne,af.Montant_Ligne/(1+af.Taux_TVA/100))) * (1-fact.Remise/100)) as Valeur,";
				req += " sum(coalesce(fa.Poids_Net,1)*af.Quantite) as Masse_Nette, fa.Mesure_Poids, coalesce(fa.Code_NC8,'') as Code_NC8, fact.Num_TVA_Intra,";
				req += " fact.Code_Pays_Liv, fact.Num_Entier";
				req += " from "+ base +".FACTURE fact join "+ base +".LIGNE_FACTURE af on af.Facture_Id=fact.Facture_Id and af.Type_Ligne='S'";
				req += " join PAYS p on fact.Code_Pays_Liv=p.Code_Pays";
				req += " join "+ base +".FICHE_ARTICLE fa on fa.Article_Id=af.Reference ";
				req += " where fact.Date_DEB="+(reedition?dateReedition:dateCourante);
				req += " group by fact.Facture_Id, Code_NC8 having round(Valeur)>0) as Com";
				req += " left join NOMENCLATURE_NC8 n on n.Code_NC8=Com.Code_NC8 order by Ref_Facture";
			}
			rset = stt.executeQuery(reqParam);
			if (rset.next()) {
				this.niveauObligation=rset.getInt("Niveau_Obligation");
				this.declarationSimplifiee=(this.niveauObligation>2);
				this.codeRegime=rset.getInt("Code_Regime");
				String natureTransaction=rset.getString("Nature_Transaction");
				this.codeTransactionA=Integer.parseInt(natureTransaction.substring(0,1));
				this.codeTransactionB=Integer.parseInt(natureTransaction.substring(1,2));
				this.conditionsLiv=rset.getString("Conditions_Liv");
				this.codeTransport=rset.getInt("Mode_Transport");
			}
			rset.close();
			
			rset = stt.executeQuery(req);
			while (rset.next()) {
				LigneExportIdep lei = new LigneExportIdep();
				
				lei.setProvenanceDestination(rset.getString("Code_Pays"));
				lei.setValeur(rset.getDouble("Valeur"));
				lei.setReferenceProduit(rset.getString("Code_NC8"));
				lei.setCodeNGP9("");
				lei.setLibelleProduit(rset.getString("Libelle_Produit"));
				
				double poids = rset.getDouble("Masse_Nette");
				String uniteMesure = rset.getString("Mesure_Poids");
				if (uniteMesure.equals("G")) { poids = poids/1000; }
				else if (uniteMesure.equals("T")) { poids = poids*1000; }
				
				lei.setMasseNette(poids);
				lei.setValeurStatistique(rset.getDouble("Valeur"));
				lei.setUnitesSupplementaires(0);
				lei.setPaysOrigine(rset.getString("Code_Pays"));
				lei.setNumTVAPartenaire(this.declarationIntro?"":rset.getString("Num_TVA_Intra"));				
				lei.setRefFacture(rset.getString("Ref_Facture"));
				lei.setCodeDevise("EUR");
				lei.setValeurDevise(rset.getDouble("Valeur"));
				lei.setValeurStatDevise(rset.getDouble("Valeur"));

				lignes.add(lei);
			}
			rset.close();
			
			stt.close();
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}			
	}
		
		
	public int getNbLignes() {
		return lignes.size();
	}



} // fin DataExportIdep
