/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un inventaire
 */

package org.opensi.facturation.actions.inventaire;


import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.pdf.GlobalDocument;


public class GenInventaire extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
	  	String fichier = r.getParameter("Fichier");
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		
		String sortie = r.getParameter("Sortie");
		int inventaireId = Integer.parseInt(r.getParameter("Inventaire_Id"));
		int marque = Integer.parseInt(r.getParameter("Marque"));
		int famille1 = Integer.parseInt(r.getParameter("Famille_1"));
		int famille2 = Integer.parseInt(r.getParameter("Famille_2"));
		int famille3 = Integer.parseInt(r.getParameter("Famille_3"));
		String typeInventaire = r.getParameter("Type_Inventaire");
		String typeEdition = r.getParameter("Type_Edition");
		
		DataInventaire di = new DataInventaire(s, inventaireId, marque, famille1, famille2, famille3, typeInventaire, typeEdition);
		
		if (sortie.equals("PDF")) {
			// Cration d'un PDF
			String repPdf = absdir +"/pdf/";
			String repTemp = repPdf;
			
			GlobalDocument gd = new GlobalDocument(repPdf, fichier);
			
			InventaireStd inventaire = new InventaireStd(repTemp, di);
		
			gd.addInternal(inventaire);
			
			gd.close(GlobalDocument.ON_EXIT);
		} else if (sortie.equals("CSV")) {
			// Cration d'un CSV
			String buffer = absdir +"/iobuffer/";
			new CsvInventaire(buffer, fichier, di);
		}
	
		return true;
		
	} // fin service


} // fin GenInventaire
