/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.api.SessionOSI;

import org.opensi.util.sql.SqlUtils;


public class TransfertAnnulEncaissementsClient extends TransfertCompta {

	private String codeJournal;
	private String listeId;
	private String compteClientsDivers;

	private PreparedStatement psCpteClient;
	private PreparedStatement psCpteJournal;
	private PreparedStatement psMarqueRegl;


	public TransfertAnnulEncaissementsClient(SessionOSI sosi, String codeJournal, String listeId) throws Exception {

		super(sosi);
		this.codeJournal = codeJournal;
		this.listeId = (listeId.length()==0?"-1":SqlUtils.normalizeCSList(listeId));
	}


	public void transfert() throws Exception {

		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery("select Numero_Compte_Clients from "+ baseDossier +".PARAM_DOSSIER");
		rset.next();

		compteClientsDivers = rset.getString("Numero_Compte_Clients");

		psCpteClient = con.prepareStatement("select c.Numero_Compte from "+ baseDossier +".FICHE_CLIENT e,"+ baseDossier +".COMPTE c where e.Client_Id=? and e.Numero_Compte=c.Numero_Compte");
		psCpteJournal = con.prepareStatement("select Contrepartie from "+ baseDossier +".JOURNAL where Code_Journal=?");
		psMarqueRegl = con.prepareStatement("update "+ baseDossier +".REGLEMENT_CLIENT set Compta_Annul=1 where Reglement_Id=?");


		rset = stt.executeQuery("select rc.*, coalesce(m.Code_Journal,'') as Journal_Enc from "+ baseDossier +".REGLEMENT_CLIENT rc"
														+" join "+ baseDossier +".MODE_REGLEMENT m on rc.Mode_Reg_Id=m.Mode_Reg_Id"
														+" left join "+ baseDossier +".REMISE_REGLEMENT_CLIENT rrc on rc.Reglement_Id=rrc.Reglement_Id"
														+" left join "+ baseDossier +".REMISE_BANQUE rb on rb.Remise_Id=rrc.Remise_Id and rb.Etat='V'"
														+" where rc.Compta_Enc=1 and coalesce(rb.Comptabilise,0)=0 and rc.Compta_Annul=0 and rc.Reglement_Id in ("+ listeId +") group by rc.Reglement_Id order by rc.Date_Reg");

		while (rset.next()) {

			long dateReglement = rset.getLong("Date_Reg");
			int reglementId = rset.getInt("Reglement_Id");
			String clientId = rset.getString("Client_Id");
			String numPiece = rset.getString("Num_Piece");
			double montant = rset.getDouble("Montant");
			String journalEnc = codeJournal.isEmpty()?rset.getString("Journal_Enc"):codeJournal;

			Ecriture ecriture = new Ecriture();
			ecriture.setCodeJournal(journalEnc);
			ecriture.setDateEcriture(dateReglement);

			String compteClient = getCompteClient(clientId);

			Operation op = new Operation();
			op.setDateOp(dateReglement);
			op.setNumPiece(numPiece);

			op.setNumeroCompte(compteClient);
			op.setLibelle(getIntitule(compteClient));
			op.setMontantD(montant);

			ecriture.addOperation(op);

			String compteEnc = getContrepartieJournal(journalEnc);

			op = new Operation();
			op.setDateOp(dateReglement);
			op.setNumPiece(numPiece);
			op.setNumeroCompte(compteEnc);
			op.setLibelle(getIntitule(compteEnc));
			op.setMontantC(montant);

			ecriture.addOperation(op);

			validerEcriture(ecriture, reglementId, dateReglement);
		}
	}


	protected void marquerDocument(int reglementId) throws SQLException {

		psMarqueRegl.setInt(1, reglementId);
		psMarqueRegl.executeUpdate();
	}


	private String getCompteClient(String clientId) throws SQLException {

		if (clientId==null || clientId.equals("")) {
			return compteClientsDivers;
		}
		else {
			psCpteClient.setString(1, clientId);
			ResultSet rset = psCpteClient.executeQuery();

			if (rset.next()) {
				return rset.getString("Numero_Compte");
			}
			else {
				return compteClientsDivers;
			}
		}
	}

	private String getContrepartieJournal(String codeJournal) throws SQLException {
		if (codeJournal.equals("")) {
			return "";
		}
		else {
			psCpteJournal.setString(1, codeJournal);
			ResultSet rset = psCpteJournal.executeQuery();
			if (rset.next()) {
				return rset.getString("Contrepartie");
			}
			else {
				return "";
			}
		}
	}


} // fin TransfertAnnulEncaissementsClient
