/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.api.SessionOSI;

import org.opensi.util.sql.SqlUtils;


public class TransfertAnnulRemboursementsClient extends TransfertCompta {

	private String codeJournal;
	private String compteClientsDivers;
	private String listeId;

	private PreparedStatement psCpteClient;
	private PreparedStatement psCpteJournal;
	private PreparedStatement psMarqueRemb;


	public TransfertAnnulRemboursementsClient(SessionOSI sosi, String codeJournal, String listeId) throws Exception {

		super(sosi);
		this.codeJournal = codeJournal;
		this.listeId = (listeId.length()==0?"-1":SqlUtils.normalizeCSList(listeId));
	}


	public void transfert() throws Exception {

		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery("select Numero_Compte_Clients from "+ baseDossier +".PARAM_DOSSIER");
		rset.next();

		compteClientsDivers = rset.getString("Numero_Compte_Clients");

		psCpteClient = con.prepareStatement("select c.Numero_Compte from "+ baseDossier +".FICHE_CLIENT e,"+ baseDossier +".COMPTE c where e.Client_Id=? and e.Numero_Compte=c.Numero_Compte");
		psCpteJournal = con.prepareStatement("select Contrepartie from "+ baseDossier +".JOURNAL where Code_Journal=?");
		psMarqueRemb = con.prepareStatement("update "+ baseDossier +".REMBOURSEMENT_CLIENT set Compta_Annul=1 where Remboursement_Id=?");

		rset = stt.executeQuery("select r.*, coalesce(b.Code_Journal,'') as Code_Journal from "+ baseDossier +".REMBOURSEMENT_CLIENT r"
														+" join "+ baseDossier +".BANQUE b on b.Banque_Id=r.Banque_Retrait"
														+" where Montant>0 and Comptabilise=1 and Compta_Annul=0 and Remboursement_Id in ("+ listeId +")");

		while (rset.next()) {

			String clientId = rset.getString("Client_Id");
			String numPiece = rset.getString("Num_Piece");
			double montant = rset.getDouble("Montant");
			int remboursementId = rset.getInt("Remboursement_Id");
			long dateRemboursement = rset.getLong("Date_Remboursement");
			String journalBanque = codeJournal.isEmpty()?rset.getString("Code_Journal"):codeJournal;

			Ecriture ecriture = new Ecriture();
			ecriture.setCodeJournal(journalBanque);
			ecriture.setDateEcriture(dateRemboursement);

			String compteClient = getCompteClient(clientId);

			Operation op = new Operation();
			op.setDateOp(dateRemboursement);
			op.setNumPiece(numPiece);

			op.setNumeroCompte(compteClient);
			op.setLibelle(getIntitule(compteClient));
			op.setMontantC(montant);

			ecriture.addOperation(op);

			String compteBanque = getContrepartieJournal(journalBanque);

			op = new Operation();
			op.setDateOp(dateRemboursement);
			op.setNumPiece(numPiece);
			op.setNumeroCompte(compteBanque);
			op.setLibelle(getIntitule(compteBanque));
			op.setMontantD(montant);

			ecriture.addOperation(op);

			validerEcriture(ecriture, remboursementId, dateRemboursement);
		}
	}


	protected void marquerDocument(int remboursementId) throws SQLException {

		psMarqueRemb.setInt(1, remboursementId);
		psMarqueRemb.executeUpdate();
	}


	private String getCompteClient(String clientId) throws SQLException {

		if (clientId==null || clientId.equals("")) {
			return compteClientsDivers;
		}
		else {
			psCpteClient.setString(1, clientId);
			ResultSet rset = psCpteClient.executeQuery();

			if (rset.next()) {
				return rset.getString("Numero_Compte");
			}
			else {
				return compteClientsDivers;
			}
		}
	}


	private String getContrepartieJournal(String codeJournal) throws SQLException {
		if (codeJournal.equals("")) {
			return "";
		}
		else {
			psCpteJournal.setString(1, codeJournal);
			ResultSet rset = psCpteJournal.executeQuery();
			if (rset.next()) {
				return rset.getString("Contrepartie");
			}
			else {
				return "";
			}
		}
	}


} // fin TransfertAnnulRemboursementsClient
